/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support;

import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.support.MessageXmlPart;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlContext;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlUtils;
import com.eviware.soapui.support.xml.XmlUtils;
import java.util.ArrayList;
import java.util.List;
import javax.wsdl.BindingOperation;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class MessageXmlObject {
    private XmlObject messageObj;
    private WsdlContext wsdlContext;
    private List<MessageXmlPart> messageParts = new ArrayList<MessageXmlPart>();
    private static final Logger log = LogManager.getLogger(MessageXmlObject.class);
    private final String messageContent;
    private WsdlOperation operation;
    private final boolean isRequest;

    public MessageXmlObject(WsdlOperation operation, String messageContent, boolean isRequest) {
        this.messageContent = messageContent;
        this.operation = operation;
        this.isRequest = isRequest;
        this.wsdlContext = operation.getInterface().getWsdlContext();
    }

    public String getMessageContent() {
        if (this.messageObj == null) {
            return this.messageContent;
        }
        for (int c = 0; c < this.messageParts.size(); ++c) {
            this.messageParts.get(c).update();
        }
        return this.messageObj.xmlText();
    }

    public XmlObject getMessageObj() throws XmlException {
        if (this.messageObj == null) {
            this.messageObj = XmlUtils.createXmlObject(this.getMessageContent(), XmlUtils.createDefaultXmlOptions());
        }
        return this.messageObj;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MessageXmlPart[] getMessageParts() throws Exception {
        String operationName = this.operation.getName();
        BindingOperation bindingOperation = this.operation.getBindingOperation();
        if (bindingOperation == null) {
            throw new Exception("Missing operation [" + operationName + "] in wsdl definition");
        }
        if (!this.wsdlContext.hasSchemaTypes()) {
            throw new Exception("Missing schema types for message");
        }
        XmlObject msgXml = this.getMessageObj();
        Part[] inputParts = this.isRequest ? WsdlUtils.getInputParts(bindingOperation) : WsdlUtils.getOutputParts(bindingOperation);
        this.messageParts.clear();
        if (WsdlUtils.isRpc(this.wsdlContext.getDefinition(), bindingOperation)) {
            XmlObject[] paths = msgXml.selectPath("declare namespace env='" + this.wsdlContext.getSoapVersion().getEnvelopeNamespace() + "';declare namespace ns='" + WsdlUtils.getTargetNamespace(this.wsdlContext.getDefinition()) + "';$this/env:Envelope/env:Body/ns:" + bindingOperation.getName());
            if (paths.length != 1) {
                throw new Exception("Missing message wrapper element [" + WsdlUtils.getTargetNamespace(this.wsdlContext.getDefinition()) + "@" + bindingOperation.getName());
            }
            XmlObject wrapper = paths[0];
            for (int i = 0; i < inputParts.length; ++i) {
                SchemaType type;
                QName typeName;
                Part part = inputParts[i];
                QName partName = part.getElementName();
                if (partName == null) {
                    partName = new QName(part.getName());
                }
                XmlObject[] children = wrapper.selectChildren(partName);
                if (WsdlUtils.isAttachmentInputPart(part, bindingOperation)) {
                    if (children.length != 1) continue;
                    typeName = part.getTypeName();
                    type = typeName == null ? null : this.wsdlContext.getSchemaTypeLoader().findType(typeName);
                    this.messageParts.add(new MessageXmlPart(children[0], type, part, bindingOperation, this.isRequest));
                    continue;
                }
                if (children.length != 1) {
                    log.error("Missing message part [" + part.getName() + "]");
                    continue;
                }
                typeName = part.getTypeName();
                if (typeName == null) {
                    typeName = partName;
                    type = this.wsdlContext.getSchemaTypeLoader().findElement(typeName);
                    if (type != null) {
                        this.messageParts.add(new MessageXmlPart(children[0], type.getType(), part, bindingOperation, this.isRequest));
                        continue;
                    }
                    log.error("Missing element [" + typeName + "] in associated schema for part [" + part.getName() + "]");
                    continue;
                }
                type = this.wsdlContext.getSchemaTypeLoader().findType(typeName);
                if (type != null) {
                    this.messageParts.add(new MessageXmlPart(children[0], type, part, bindingOperation, this.isRequest));
                    continue;
                }
                log.error("Missing type [" + typeName + "] in associated schema for part [" + part.getName() + "]");
            }
            return this.messageParts.toArray(new MessageXmlPart[this.messageParts.size()]);
        } else {
            Part part = inputParts[0];
            QName elementName = part.getElementName();
            if (elementName == null) return this.messageParts.toArray(new MessageXmlPart[this.messageParts.size()]);
            XmlObject[] paths = msgXml.selectPath("declare namespace env='" + this.wsdlContext.getSoapVersion().getEnvelopeNamespace() + "';declare namespace ns='" + elementName.getNamespaceURI() + "';$this/env:Envelope/env:Body/ns:" + elementName.getLocalPart());
            if (paths.length != 1) throw new Exception("Missing message part with name [" + elementName + "]");
            SchemaGlobalElement elm = this.wsdlContext.getSchemaTypeLoader().findElement(elementName);
            if (elm == null) throw new Exception("Missing part type in associated schema");
            this.messageParts.add(new MessageXmlPart(paths[0], elm.getType(), part, bindingOperation, this.isRequest));
        }
        return this.messageParts.toArray(new MessageXmlPart[this.messageParts.size()]);
    }
}

