/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps;

import com.eviware.soapui.impl.EmptyPanelBuilder;
import com.eviware.soapui.impl.wsdl.panels.teststeps.GraphQLRequestTestStepDesktopPanel;
import com.eviware.soapui.impl.wsdl.support.wss.WssCrypto;
import com.eviware.soapui.impl.wsdl.teststeps.GraphQLRequestTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.GraphQLTestRequest;
import com.eviware.soapui.support.components.JPropertiesTable;
import com.eviware.soapui.ui.desktop.DesktopPanel;
import java.awt.Component;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

public class GraphQLRequestTestStepPanelBuilder
extends EmptyPanelBuilder<GraphQLRequestTestStep> {
    @Override
    public DesktopPanel buildDesktopPanel(GraphQLRequestTestStep graphQLTestRequestTestStep) {
        return new GraphQLRequestTestStepDesktopPanel(graphQLTestRequestTestStep);
    }

    @Override
    public boolean hasDesktopPanel() {
        return true;
    }

    @Override
    public Component buildOverviewPanel(GraphQLRequestTestStep testStep) {
        GraphQLTestRequest request = testStep.getTestRequest();
        JPropertiesTable<GraphQLTestRequest> table = new JPropertiesTable<GraphQLTestRequest>("GraphQL Request Properties");
        table.addProperty("Name", "name", true);
        table.addProperty("Description", "description", true);
        table.addProperty("Encoding", "encoding", new String[]{null, StandardCharsets.UTF_8.name(), "iso-8859-1"});
        table.addProperty("Endpoint", "endpoint", true);
        table.addProperty("Timeout", "timeout", true);
        table.addProperty("Bind Address", "bindAddress", true);
        table.addProperty("Follow Redirects", "followRedirects", JPropertiesTable.BOOLEAN_OPTIONS);
        ArrayList<WssCrypto> keystores = new ArrayList<WssCrypto>(request.getTestStep().getTestCase().getTestSuite().getProject().getWssContainer().getCryptoList());
        keystores.add(0, null);
        table.addProperty("SSL Keystore", "sslKeystore", keystores.toArray());
        table.addProperty("Dump File", "dumpFile", true).setDescription("Dumps response message to specified file");
        table.addProperty("Max Size", "maxSize", true).setDescription("The maximum number of bytes to receive");
        table.addProperty("Discard Response", "discardResponse", JPropertiesTable.BOOLEAN_OPTIONS);
        table.setPropertyObject(request);
        return table;
    }

    @Override
    public boolean hasOverviewPanel() {
        return true;
    }
}

