/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.rest.panels.request.views.content.GraphQLRequestContentView;
import com.eviware.soapui.impl.support.HttpUtils;
import com.eviware.soapui.impl.support.components.ModelItemXmlEditor;
import com.eviware.soapui.impl.support.panels.AbstractHttpXmlRequestDesktopPanel;
import com.eviware.soapui.impl.wsdl.panels.teststeps.AssertionsPanel;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.impl.wsdl.teststeps.GraphQLRequestTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.GraphQLTestRequestInterface;
import com.eviware.soapui.impl.wsdl.teststeps.GraphQLTestRequestStepInterface;
import com.eviware.soapui.impl.wsdl.teststeps.RestTestRequestInterface;
import com.eviware.soapui.impl.wsdl.teststeps.actions.AddAssertionAction;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionsListener;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.model.testsuite.TestAssertion;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.monitor.support.TestMonitorListenerAdapter;
import com.eviware.soapui.security.SecurityTestRunner;
import com.eviware.soapui.support.DateUtil;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.ListDataChangeListener;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JComponentInspector;
import com.eviware.soapui.support.components.JInspectorPanel;
import com.eviware.soapui.support.components.JInspectorPanelFactory;
import com.eviware.soapui.support.components.JUndoableTextField;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.editor.EditorView;
import com.eviware.soapui.support.editor.inspectors.auth.AuthInspectorFactory;
import com.eviware.soapui.support.editor.inspectors.httpheaders.HttpHeadersInspectorFactory;
import com.eviware.soapui.support.editor.views.xml.raw.RawXmlEditorFactory;
import com.eviware.soapui.support.editor.xml.XmlDocument;
import com.eviware.soapui.support.editor.xml.XmlInspector;
import com.eviware.soapui.support.editor.xml.support.DefaultXmlDocument;
import com.eviware.soapui.support.log.JLogList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import net.miginfocom.swing.MigLayout;

public class GraphQLRequestTestStepDesktopPanel
extends AbstractHttpXmlRequestDesktopPanel<GraphQLTestRequestStepInterface, GraphQLTestRequestInterface> {
    private static final RestRequestInterface.HttpMethod[] graphQLMethods = new RestRequestInterface.HttpMethod[]{RestRequestInterface.HttpMethod.GET, RestRequestInterface.HttpMethod.POST};
    private JLogList logArea;
    private InternalTestMonitorListener testMonitorListener = new InternalTestMonitorListener();
    private InternalAssertionsListener assertionsListener = new InternalAssertionsListener();
    private JButton addAssertionButton;
    private JUndoableTextField pathTextField;
    private AssertionsPanel assertionsPanel;
    private JComponentInspector<?> assertionInspector;
    private JInspectorPanel inspectorPanel;
    private JComponentInspector<?> logInspector;
    private boolean updating;
    private long startTime;

    public GraphQLRequestTestStepDesktopPanel(GraphQLRequestTestStep testStep) {
        super(testStep, testStep.getTestRequest());
        SoapUI.getTestMonitor().addTestMonitorListener(this.testMonitorListener);
        this.setEnabled(!SoapUI.getTestMonitor().hasRunningTest(testStep.getTestCase()));
        testStep.getTestRequest().addAssertionsListener(this.assertionsListener);
        this.getSubmitButton().setEnabled(this.getSubmit() == null && StringUtils.hasContent(((GraphQLTestRequestInterface)this.getRequest()).getEndpoint()));
    }

    protected EditorView getRequestEditorView(GraphQLRequestMessageEditor editor, GraphQLTestRequestInterface graphQLRequest) {
        return new GraphQLRequestContentView(editor, graphQLRequest);
    }

    @Override
    protected ModelItemXmlEditor<?, ?> buildRequestEditor() {
        GraphQLRequestMessageEditor graphQLRequestMessageEditor = new GraphQLRequestMessageEditor((GraphQLTestRequestInterface)this.getRequest());
        graphQLRequestMessageEditor.addEditorView(this.getRequestEditorView(graphQLRequestMessageEditor, (GraphQLTestRequestInterface)this.getRequest()));
        RawXmlEditorFactory rawXmlEditorFactory = new RawXmlEditorFactory();
        graphQLRequestMessageEditor.addEditorView(rawXmlEditorFactory.createRequestEditorView(graphQLRequestMessageEditor, (ModelItem)this.getRequest()));
        AuthInspectorFactory authInspectorFactory = new AuthInspectorFactory();
        HttpHeadersInspectorFactory httpHeadersInspectorFactory = new HttpHeadersInspectorFactory();
        graphQLRequestMessageEditor.addInspector((XmlInspector)authInspectorFactory.createRequestInspector(graphQLRequestMessageEditor, (ModelItem)this.getRequest()));
        graphQLRequestMessageEditor.addInspector((XmlInspector)httpHeadersInspectorFactory.createRequestInspector(graphQLRequestMessageEditor, (ModelItem)this.getRequest()));
        return graphQLRequestMessageEditor;
    }

    @Override
    protected ModelItemXmlEditor<?, ?> buildResponseEditor() {
        return new GraphQLResponseMessageEditor((GraphQLTestRequestInterface)this.getRequest());
    }

    @Override
    public void setContent(JComponent content) {
        this.inspectorPanel.setContentComponent(content);
    }

    @Override
    public void removeContent(JComponent content) {
        this.inspectorPanel.setContentComponent(null);
    }

    @Override
    protected String getHelpUrl() {
        return "/docs/graphql-testing";
    }

    protected JComponent buildLogPanel() {
        this.logArea = new JLogList("Request Log");
        this.logArea.getLogList().getModel().addListDataListener(new ListDataChangeListener(){

            @Override
            public void dataChanged(ListModel model) {
                GraphQLRequestTestStepDesktopPanel.this.logInspector.setTitle("Request Log (" + model.getSize() + ")");
            }
        });
        return this.logArea;
    }

    @Override
    protected void insertButtons(JXToolBar toolbar) {
        toolbar.add(this.addAssertionButton);
    }

    @Override
    protected JComponent buildEndpointComponent() {
        return null;
    }

    @Override
    protected JComponent buildContent() {
        JComponent component = super.buildContent();
        this.inspectorPanel = JInspectorPanelFactory.build(component);
        this.assertionsPanel = this.buildAssertionsPanel();
        this.assertionInspector = new JComponentInspector<AssertionsPanel>(this.assertionsPanel, "Assertions (" + ((GraphQLTestRequestStepInterface)this.getModelItem()).getAssertionCount() + ")", "Assertions for this request", true);
        this.inspectorPanel.addInspector(this.assertionInspector);
        this.logInspector = new JComponentInspector<JComponent>(this.buildLogPanel(), "Request Log (0)", "Log of requests", true);
        this.inspectorPanel.addInspector(this.logInspector);
        this.inspectorPanel.setDefaultDividerLocation(0.6f);
        this.inspectorPanel.setCurrentInspector("Assertions");
        this.updateStatusIcon();
        this.getSubmitButton().setEnabled(this.getSubmit() == null && StringUtils.hasContent(((GraphQLTestRequestInterface)this.getRequest()).getEndpoint()));
        return this.inspectorPanel.getComponent();
    }

    private void updateStatusIcon() {
        Assertable.AssertionStatus status = ((GraphQLTestRequestStepInterface)this.getModelItem()).getTestRequest().getAssertionStatus();
        switch (status) {
            case FAILED: {
                this.assertionInspector.setIcon(UISupport.createImageIcon("/failed_assertion.gif"));
                this.inspectorPanel.activate(this.assertionInspector);
                break;
            }
            case UNKNOWN: {
                this.assertionInspector.setIcon(UISupport.createImageIcon("/unknown_assertion.png"));
                break;
            }
            case VALID: {
                this.assertionInspector.setIcon(UISupport.createImageIcon("/vFalid_assertion.gif"));
                this.inspectorPanel.deactivate();
            }
        }
    }

    private JComponent createPathPanel() {
        MigLayout layout = new MigLayout("", "[grow]", "[][]");
        JPanel panel = new JPanel((LayoutManager)layout);
        this.pathTextField = new JUndoableTextField();
        UISupport.setPreferredHeight(this.pathTextField, 23);
        this.pathTextField.setText(((GraphQLTestRequestInterface)this.getRequest()).getEndpoint());
        this.pathTextField.setToolTipText(this.pathTextField.getText());
        this.pathTextField.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            @Override
            public void update(Document document) {
                if (GraphQLRequestTestStepDesktopPanel.this.updating) {
                    return;
                }
                GraphQLRequestTestStepDesktopPanel.this.updating = true;
                String text = GraphQLRequestTestStepDesktopPanel.this.pathTextField.getText();
                ((GraphQLTestRequestInterface)GraphQLRequestTestStepDesktopPanel.this.getRequest()).setEndpoint(HttpUtils.completeUrlWithHttpIfProtocolIsNotHttpOrHttpsOrPropertyExpansion(text));
                if (!text.equals(((GraphQLTestRequestInterface)GraphQLRequestTestStepDesktopPanel.this.getRequest()).getEndpoint())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GraphQLRequestTestStepDesktopPanel.this.pathTextField.setText(((GraphQLTestRequestInterface)GraphQLRequestTestStepDesktopPanel.this.getRequest()).getEndpoint());
                        }
                    });
                }
                GraphQLRequestTestStepDesktopPanel.this.updating = false;
            }
        });
        this.pathTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    GraphQLRequestTestStepDesktopPanel.this.onSubmit();
                }
            }
        });
        panel.add((Component)new JLabel("Request URL"), "wrap");
        panel.add((Component)this.pathTextField, "growx, hmin 20");
        return panel;
    }

    protected void addToolbarComponents(JPanel toolbar) {
        this.addMethodCombo(toolbar);
        toolbar.add((Component)this.createPathPanel(), "growx");
    }

    protected void addMethodCombo(JPanel toolbar) {
        MigLayout layout = new MigLayout("", "[]", "[][]");
        JPanel panel = new JPanel((LayoutManager)layout);
        final JComboBox<RestRequestInterface.HttpMethod> methodCombo = new JComboBox<RestRequestInterface.HttpMethod>(graphQLMethods);
        methodCombo.setSelectedItem((Object)((GraphQLTestRequestInterface)this.getRequest()).getMethod());
        methodCombo.setToolTipText("Select HTTP method");
        methodCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ((GraphQLTestRequestInterface)GraphQLRequestTestStepDesktopPanel.this.getRequest()).setMethod((RestRequestInterface.HttpMethod)((Object)methodCombo.getSelectedItem()));
            }
        });
        panel.add((Component)new JLabel("Method"), "wrap");
        panel.add(methodCombo);
        toolbar.add(panel);
    }

    @Override
    protected JComponent buildToolbar() {
        this.addAssertionButton = GraphQLRequestTestStepDesktopPanel.createActionButton(new AddAssertionAction((Assertable)this.getRequest()), true);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)super.buildToolbar(), "North");
        JPanel lowerToolbar = new JPanel((LayoutManager)new MigLayout("", "0[][grow][]0", "0[]0"));
        this.addToolbarComponents(lowerToolbar);
        panel.add(lowerToolbar);
        return panel;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled) {
            enabled = !SoapUI.getTestMonitor().hasRunningLoadTest(((GraphQLTestRequestStepInterface)this.getModelItem()).getTestCase()) && !SoapUI.getTestMonitor().hasRunningSecurityTest(((GraphQLTestRequestStepInterface)this.getModelItem()).getTestCase());
        }
        super.setEnabled(enabled);
        this.addAssertionButton.setEnabled(enabled);
        this.assertionsPanel.setEnabled(enabled);
        if (SoapUI.getTestMonitor().hasRunningLoadTest(((GraphQLTestRequestInterface)this.getRequest()).getTestCase()) || SoapUI.getTestMonitor().hasRunningSecurityTest(((GraphQLTestRequestStepInterface)this.getModelItem()).getTestCase())) {
            ((GraphQLTestRequestInterface)this.getRequest()).removeSubmitListener(this);
        } else {
            ((GraphQLTestRequestInterface)this.getRequest()).addSubmitListener(this);
        }
    }

    @Override
    protected Submit doSubmit() throws Request.SubmitException {
        return ((GraphQLTestRequestInterface)this.getRequest()).submit(new WsdlTestRunContext((TestStep)this.getModelItem()), true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(RestTestRequestInterface.STATUS_PROPERTY)) {
            this.updateStatusIcon();
        } else if (evt.getPropertyName().equals("path")) {
            this.getSubmitButton().setEnabled(this.getSubmit() == null && StringUtils.hasContent(((GraphQLTestRequestInterface)this.getRequest()).getEndpoint()));
        } else if (evt.getPropertyName().equals("endpoint")) {
            this.getSubmitButton().setEnabled(this.getSubmit() == null && StringUtils.hasContent(((GraphQLTestRequestInterface)this.getRequest()).getEndpoint()));
            if (this.updating) {
                return;
            }
            this.updating = true;
            this.pathTextField.setText(String.valueOf(evt.getNewValue()));
            this.updating = false;
        }
        super.propertyChange(evt);
    }

    @Override
    public boolean beforeSubmit(Submit submit, SubmitContext context) {
        boolean result = super.beforeSubmit(submit, context);
        this.startTime = System.currentTimeMillis();
        return result;
    }

    @Override
    protected void logMessages(String message, String infoMessage) {
        super.logMessages(message, infoMessage);
        this.logArea.addLine(DateUtil.formatExtraFull(new Date(this.startTime)) + " - " + message);
    }

    protected AssertionsPanel buildAssertionsPanel() {
        return new AssertionsPanel((Assertable)this.getRequest()){

            @Override
            protected void selectError(AssertionError error) {
                ModelItemXmlEditor<?, ?> editor = GraphQLRequestTestStepDesktopPanel.this.getResponseEditor();
                editor.requestFocus();
            }
        };
    }

    @Override
    public boolean onClose(boolean canCancel) {
        if (super.onClose(canCancel)) {
            GraphQLTestRequestInterface testRequestInterface;
            if (this.assertionsPanel != null) {
                this.assertionsPanel.release();
            }
            if (this.inspectorPanel != null) {
                this.inspectorPanel.release();
            }
            if (this.testMonitorListener != null) {
                SoapUI.getTestMonitor().removeTestMonitorListener(this.testMonitorListener);
            }
            if ((testRequestInterface = (GraphQLTestRequestInterface)this.getRequest()) != null) {
                testRequestInterface.removeAssertionsListener(this.assertionsListener);
            }
            return true;
        }
        return false;
    }

    private class InternalTestMonitorListener
    extends TestMonitorListenerAdapter {
        private InternalTestMonitorListener() {
        }

        @Override
        public void loadTestFinished(LoadTestRunner runner) {
            GraphQLRequestTestStepDesktopPanel.this.setEnabled(!SoapUI.getTestMonitor().hasRunningTest(((GraphQLTestRequestStepInterface)GraphQLRequestTestStepDesktopPanel.this.getModelItem()).getTestCase()));
        }

        @Override
        public void loadTestStarted(LoadTestRunner runner) {
            if (runner.getLoadTest().getTestCase() == ((GraphQLTestRequestStepInterface)GraphQLRequestTestStepDesktopPanel.this.getModelItem()).getTestCase()) {
                GraphQLRequestTestStepDesktopPanel.this.setEnabled(false);
            }
        }

        @Override
        public void securityTestFinished(SecurityTestRunner runner) {
            GraphQLRequestTestStepDesktopPanel.this.setEnabled(!SoapUI.getTestMonitor().hasRunningTest(((GraphQLTestRequestStepInterface)GraphQLRequestTestStepDesktopPanel.this.getModelItem()).getTestCase()));
        }

        @Override
        public void securityTestStarted(SecurityTestRunner runner) {
            if (runner.getSecurityTest().getTestCase() == ((GraphQLTestRequestStepInterface)GraphQLRequestTestStepDesktopPanel.this.getModelItem()).getTestCase()) {
                GraphQLRequestTestStepDesktopPanel.this.setEnabled(false);
            }
        }

        @Override
        public void testCaseFinished(TestCaseRunner runner) {
            GraphQLRequestTestStepDesktopPanel.this.setEnabled(!SoapUI.getTestMonitor().hasRunningTest(((GraphQLTestRequestStepInterface)GraphQLRequestTestStepDesktopPanel.this.getModelItem()).getTestCase()));
        }

        @Override
        public void testCaseStarted(TestCaseRunner runner) {
            if (runner.getTestCase() == ((GraphQLTestRequestStepInterface)GraphQLRequestTestStepDesktopPanel.this.getModelItem()).getTestCase()) {
                GraphQLRequestTestStepDesktopPanel.this.setEnabled(false);
            }
        }
    }

    private final class InternalAssertionsListener
    implements AssertionsListener {
        private InternalAssertionsListener() {
        }

        @Override
        public void assertionAdded(TestAssertion assertion) {
            GraphQLRequestTestStepDesktopPanel.this.assertionInspector.setTitle("Assertions (" + ((GraphQLTestRequestStepInterface)GraphQLRequestTestStepDesktopPanel.this.getModelItem()).getAssertionCount() + ")");
        }

        @Override
        public void assertionRemoved(TestAssertion assertion) {
            GraphQLRequestTestStepDesktopPanel.this.assertionInspector.setTitle("Assertions (" + ((GraphQLTestRequestStepInterface)GraphQLRequestTestStepDesktopPanel.this.getModelItem()).getAssertionCount() + ")");
        }

        @Override
        public void assertionMoved(TestAssertion assertion, int ix, int offset) {
            GraphQLRequestTestStepDesktopPanel.this.assertionInspector.setTitle("Assertions (" + ((GraphQLTestRequestStepInterface)GraphQLRequestTestStepDesktopPanel.this.getModelItem()).getAssertionCount() + ")");
        }
    }

    public class GraphQLRequestMessageEditor
    extends ModelItemXmlEditor<GraphQLTestRequestInterface, XmlDocument> {
        public GraphQLRequestMessageEditor(GraphQLTestRequestInterface modelItem) {
            super(new DefaultXmlDocument(), modelItem);
        }
    }

    public class GraphQLResponseMessageEditor
    extends AbstractHttpXmlRequestDesktopPanel.HttpResponseMessageEditor {
        public GraphQLResponseMessageEditor(GraphQLTestRequestInterface modelItem) {
            super(modelItem);
        }
    }
}

