/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.loadtest.data;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.loadtest.ColorPalette;
import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTest;
import com.eviware.soapui.impl.wsdl.loadtest.data.StatisticsHistory;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.model.support.LoadTestRunListenerAdapter;
import com.eviware.soapui.model.support.TestSuiteListenerAdapter;
import com.eviware.soapui.model.testsuite.LoadTestRunContext;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.support.types.StringList;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.table.AbstractTableModel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class LoadTestStatistics
extends AbstractTableModel
implements Runnable {
    public static final String NO_STATS_TESTCASE_CANCEL_REASON = "NO_STATS_TESTCASE_CANCEL_REASON";
    private static final Logger log = LogManager.getLogger(LoadTestStatistics.class);
    private final WsdlLoadTest loadTest;
    private long[][] data;
    private static final int MIN_COLUMN = 0;
    private static final int MAX_COLUMN = 1;
    private static final int AVG_COLUMN = 2;
    private static final int LAST_COLUMN = 3;
    private static final int CNT_COLUMN = 4;
    private static final int TPS_COLUMN = 5;
    private static final int BYTES_COLUMN = 6;
    private static final int BPS_COLUMN = 7;
    private static final int ERR_COLUMN = 8;
    private static final int SUM_COLUMN = 9;
    private static final int CURRENT_CNT_COLUMN = 10;
    private static final int RATIO_COLUMN = 11;
    public static final int TOTAL = -1;
    public static final int DEFAULT_SAMPLE_INTERVAL = 250;
    private InternalTestRunListener testRunListener;
    private InternalTestSuiteListener testSuiteListener;
    private InternalPropertyChangeListener propertyChangeListener;
    private StatisticsHistory history;
    private boolean changed;
    private long updateFrequency = 250L;
    private Queue<SamplesHolder> samplesStack = new ConcurrentLinkedQueue<SamplesHolder>();
    private long currentThreadCountStartTime;
    private long totalAverageSum;
    private boolean resetStatistics;
    private boolean running;
    private boolean adding;
    private static final Map<Integer, Statistic> statisticIndexMap = new HashMap<Integer, Statistic>();
    private Updater updater = new Updater();

    public LoadTestStatistics(WsdlLoadTest loadTest) {
        this.loadTest = loadTest;
        this.testRunListener = new InternalTestRunListener();
        this.testSuiteListener = new InternalTestSuiteListener();
        this.propertyChangeListener = new InternalPropertyChangeListener();
        WsdlTestCase testCase = loadTest.getTestCase();
        loadTest.addPropertyChangeListener(this.propertyChangeListener);
        loadTest.addLoadTestRunListener(this.testRunListener);
        testCase.getTestSuite().addTestSuiteListener(this.testSuiteListener);
        for (TestStep testStep : testCase.getTestStepList()) {
            testStep.addPropertyChangeListener(this.propertyChangeListener);
        }
        this.history = new StatisticsHistory(this);
        this.init();
    }

    private void init() {
        this.data = new long[this.getRowCount()][11];
    }

    public StatisticsHistory getHistory() {
        return this.history;
    }

    @Override
    public int getRowCount() {
        return this.loadTest.getTestCase().getTestStepCount() + 1;
    }

    public WsdlLoadTest getLoadTest() {
        return this.loadTest;
    }

    @Override
    public int getColumnCount() {
        return 12;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return " ";
            }
            case 1: {
                return "Test Step";
            }
            case 2: {
                return Statistic.MININMUM.getName();
            }
            case 3: {
                return Statistic.MAXIMUM.getName();
            }
            case 4: {
                return Statistic.AVERAGE.getName();
            }
            case 5: {
                return Statistic.LAST.getName();
            }
            case 6: {
                return Statistic.COUNT.getName();
            }
            case 7: {
                return Statistic.TPS.getName();
            }
            case 8: {
                return Statistic.BYTES.getName();
            }
            case 9: {
                return Statistic.BPS.getName();
            }
            case 10: {
                return Statistic.ERRORS.getName();
            }
            case 11: {
                return Statistic.ERRORRATIO.getName();
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Color.class;
            }
            case 1: {
                return String.class;
            }
            case 4: 
            case 7: {
                return Float.class;
            }
        }
        return Long.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public long getStatistic(int stepIndex, Statistic statistic) {
        if (stepIndex == -1) {
            stepIndex = this.data.length - 1;
        }
        switch (statistic) {
            case TPS: 
            case AVERAGE: {
                return this.data[stepIndex][statistic.getIndex()] / 100L;
            }
            case ERRORRATIO: {
                return this.data[stepIndex][Statistic.COUNT.getIndex()] == 0L ? 0L : (long)(((double)((float)this.data[stepIndex][Statistic.ERRORS.getIndex()] / (float)this.data[stepIndex][Statistic.COUNT.getIndex()]) + 0.5) * 100.0);
            }
        }
        return this.data[stepIndex][statistic.getIndex()];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        WsdlTestCase testCase = this.loadTest.getTestCase();
        switch (columnIndex) {
            case 0: {
                return rowIndex == testCase.getTestStepCount() ? null : ColorPalette.getColor(testCase.getTestStepAt(rowIndex));
            }
            case 1: {
                if (rowIndex == testCase.getTestStepCount()) {
                    return "TestCase:";
                }
                return testCase.getTestStepAt(rowIndex).getLabel();
            }
            case 4: 
            case 7: {
                return new Float((float)this.data[rowIndex][columnIndex - 2] / 100.0f);
            }
            case 11: {
                return this.data[rowIndex][Statistic.COUNT.getIndex()] == 0L ? 0L : (long)((float)this.data[rowIndex][Statistic.ERRORS.getIndex()] / (float)this.data[rowIndex][Statistic.COUNT.getIndex()] * 100.0f);
            }
        }
        return this.data == null || rowIndex >= this.data.length ? new Long(0L) : new Long(this.data[rowIndex][columnIndex - 2]);
    }

    public void pushSamples(long[] samples, long[] sizes, long[] sampleCounts, long startTime, long timeTaken, boolean complete) {
        if (!this.running || samples.length == 0 || sizes.length == 0) {
            return;
        }
        this.samplesStack.add(new SamplesHolder(samples, sizes, sampleCounts, startTime, timeTaken, complete));
    }

    @Override
    public void run() {
        Thread.currentThread().setName(this.loadTest.getName() + " LoadTestStatistics");
        while (this.running || !this.samplesStack.isEmpty()) {
            try {
                while (!this.samplesStack.isEmpty()) {
                    SamplesHolder holder = this.samplesStack.poll();
                    if (holder == null) continue;
                    this.addSamples(holder);
                }
                Thread.sleep(200L);
            }
            catch (EmptyStackException holder) {
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
        }
    }

    private synchronized void addSamples(SamplesHolder holder) {
        if (this.adding) {
            throw new RuntimeException("Already adding!");
        }
        this.adding = true;
        int totalIndex = this.data.length - 1;
        if (holder.samples.length != totalIndex || holder.sizes.length != totalIndex) {
            this.adding = false;
            throw new RuntimeException("Unexpected number of samples: " + holder.samples.length + ", exptected " + totalIndex);
        }
        if (holder.startTime < this.currentThreadCountStartTime) {
            this.adding = false;
            return;
        }
        long timePassed = holder.startTime + holder.timeTaken - this.currentThreadCountStartTime;
        if (this.resetStatistics) {
            for (int c = 0; c < this.data.length; ++c) {
                this.data[c][10] = 0L;
                this.data[c][2] = 0L;
                this.data[c][9] = 0L;
                this.data[c][5] = 0L;
                this.data[c][6] = 0L;
            }
            this.totalAverageSum = 0L;
            this.resetStatistics = false;
        }
        long totalMin = 0L;
        long totalMax = 0L;
        long totalBytes = 0L;
        long totalAvg = 0L;
        long totalSum = 0L;
        long totalLast = 0L;
        long threadCount = this.loadTest.getThreadCount();
        for (int c = 0; c < holder.samples.length; ++c) {
            if (holder.sampleCounts[c] > 0L) {
                if (holder.complete != this.loadTest.getUpdateStatisticsPerTestStep()) {
                    long sampleAvg;
                    this.data[c][3] = sampleAvg = holder.samples[c] / holder.sampleCounts[c];
                    long[] lArray = this.data[c];
                    lArray[4] = lArray[4] + holder.sampleCounts[c];
                    long[] lArray2 = this.data[c];
                    lArray2[10] = lArray2[10] + holder.sampleCounts[c];
                    long[] lArray3 = this.data[c];
                    lArray3[9] = lArray3[9] + holder.samples[c];
                    if (sampleAvg > 0L && (sampleAvg < this.data[c][0] || this.data[c][0] == 0L)) {
                        this.data[c][0] = sampleAvg;
                    }
                    if (sampleAvg > this.data[c][1]) {
                        this.data[c][1] = sampleAvg;
                    }
                    float average = (float)this.data[c][9] / (float)this.data[c][10];
                    this.data[c][2] = (long)(average * 100.0f);
                    long[] lArray4 = this.data[c];
                    lArray4[6] = lArray4[6] + holder.sizes[c];
                    if (timePassed > 0L) {
                        if (this.loadTest.getCalculateTPSOnTimePassed()) {
                            this.data[c][5] = this.data[c][10] * 100000L / timePassed;
                            this.data[c][7] = this.data[c][6] * 1000L / timePassed;
                        } else {
                            this.data[c][5] = (long)(this.data[c][2] > 0L ? 100000.0f / average * (float)threadCount : 0.0f);
                            long avgBytes = this.data[c][4] == 0L ? 0L : this.data[c][6] / this.data[c][4];
                            this.data[c][7] = avgBytes * this.data[c][5] / 100L;
                        }
                    }
                }
                totalMin += this.data[c][0] * holder.sampleCounts[c];
                totalMax += this.data[c][1] * holder.sampleCounts[c];
                totalBytes += this.data[c][6] * holder.sampleCounts[c];
                totalAvg += this.data[c][2] * holder.sampleCounts[c];
                totalSum += this.data[c][9] * holder.sampleCounts[c];
                totalLast += this.data[c][3] * holder.sampleCounts[c];
                continue;
            }
            totalMin += this.data[c][0];
            totalMax += this.data[c][1];
            totalBytes += this.data[c][6];
        }
        if (holder.complete) {
            long[] lArray = this.data[totalIndex];
            lArray[4] = lArray[4] + 1L;
            long[] lArray5 = this.data[totalIndex];
            lArray5[10] = lArray5[10] + 1L;
            this.totalAverageSum += totalLast * 100L;
            this.data[totalIndex][2] = (long)((float)this.totalAverageSum / (float)this.data[totalIndex][10]);
            this.data[totalIndex][6] = totalBytes;
            if (timePassed > 0L) {
                if (this.loadTest.getCalculateTPSOnTimePassed()) {
                    this.data[totalIndex][5] = this.data[totalIndex][10] * 100000L / timePassed;
                    this.data[totalIndex][7] = this.data[totalIndex][6] * 1000L / timePassed;
                } else {
                    this.data[totalIndex][5] = (long)(this.data[totalIndex][2] > 0L ? 1.0E7f / (float)this.data[totalIndex][2] * (float)threadCount : 0.0f);
                    long avgBytes = this.data[totalIndex][4] == 0L ? 0L : this.data[totalIndex][6] / this.data[totalIndex][4];
                    this.data[totalIndex][7] = avgBytes * this.data[totalIndex][5] / 100L;
                }
            }
            this.data[totalIndex][0] = totalMin;
            this.data[totalIndex][1] = totalMax;
            this.data[totalIndex][9] = totalSum;
            this.data[totalIndex][3] = totalLast;
        }
        if (this.updateFrequency == 0L) {
            this.fireTableDataChanged();
        } else {
            this.changed = true;
        }
        this.adding = false;
    }

    private void stop() {
        this.running = false;
    }

    public int getStepCount() {
        return this.loadTest.getTestCase().getTestStepCount();
    }

    public void reset() {
        this.init();
        this.fireTableDataChanged();
    }

    public void release() {
        this.reset();
        this.loadTest.removeLoadTestRunListener(this.testRunListener);
        this.loadTest.getTestCase().getTestSuite().removeTestSuiteListener(this.testSuiteListener);
        for (TestStep testStep : this.loadTest.getTestCase().getTestStepList()) {
            testStep.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    public TestStep getTestStepAtRow(int selectedRow) {
        if (selectedRow < this.getRowCount() - 1) {
            return this.loadTest.getTestCase().getTestStepAt(selectedRow);
        }
        return null;
    }

    public long getUpdateFrequency() {
        return this.updateFrequency;
    }

    public void setUpdateFrequency(long updateFrequency) {
        this.updateFrequency = updateFrequency;
    }

    public void addError(int stepIndex) {
        if (stepIndex != -1) {
            long[] lArray = this.data[stepIndex];
            lArray[8] = lArray[8] + 1L;
        }
        long[] lArray = this.data[this.data.length - 1];
        lArray[8] = lArray[8] + 1L;
        this.changed = true;
    }

    public synchronized StringList[] getSnapshot() {
        long[][] clone = (long[][])this.data.clone();
        StringList[] result = new StringList[this.getRowCount()];
        for (int c = 0; c < clone.length; ++c) {
            StringList values = new StringList();
            block4: for (int columnIndex = 2; columnIndex < this.getColumnCount(); ++columnIndex) {
                switch (columnIndex) {
                    case 4: 
                    case 7: {
                        values.add(String.valueOf((float)this.data[c][columnIndex - 2] / 100.0f));
                        continue block4;
                    }
                    default: {
                        values.add(String.valueOf(this.data[c][columnIndex - 2]));
                    }
                }
            }
            result[c] = values;
        }
        return result;
    }

    public synchronized void finish() {
        while (!this.samplesStack.isEmpty()) {
            SamplesHolder holder = this.samplesStack.poll();
            if (holder == null) continue;
            this.addSamples(holder);
        }
    }

    private class InternalPropertyChangeListener
    implements PropertyChangeListener {
        private InternalPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == LoadTestStatistics.this.loadTest && evt.getPropertyName().equals(WsdlLoadTest.THREADCOUNT_PROPERTY)) {
                if (LoadTestStatistics.this.loadTest.getResetStatisticsOnThreadCountChange()) {
                    LoadTestStatistics.this.resetStatistics = true;
                    LoadTestStatistics.this.currentThreadCountStartTime = System.currentTimeMillis();
                }
            } else if (evt.getPropertyName().equals(TestStep.NAME_PROPERTY) || evt.getPropertyName().equals(TestStep.DISABLED_PROPERTY)) {
                if (evt.getSource() instanceof TestStep) {
                    LoadTestStatistics.this.fireTableCellUpdated(LoadTestStatistics.this.loadTest.getTestCase().getIndexOfTestStep((TestStep)evt.getSource()), 1);
                }
            } else if (evt.getPropertyName().equals(WsdlLoadTest.HISTORYLIMIT_PROPERTY) && LoadTestStatistics.this.loadTest.getHistoryLimit() == 0L) {
                LoadTestStatistics.this.history.reset();
            }
        }
    }

    private final class Updater
    implements Runnable {
        private Updater() {
        }

        @Override
        public void run() {
            Thread.currentThread().setName(LoadTestStatistics.this.loadTest.getName() + " LoadTestStatistics Updater");
            while (LoadTestStatistics.this.running || LoadTestStatistics.this.changed || !LoadTestStatistics.this.samplesStack.isEmpty()) {
                if (LoadTestStatistics.this.changed) {
                    LoadTestStatistics.this.fireTableDataChanged();
                    LoadTestStatistics.this.changed = false;
                }
                if (!LoadTestStatistics.this.running && LoadTestStatistics.this.samplesStack.isEmpty()) break;
                try {
                    Thread.sleep(LoadTestStatistics.this.updateFrequency < 1L ? 1000L : LoadTestStatistics.this.updateFrequency);
                }
                catch (InterruptedException e) {
                    SoapUI.logError(e);
                }
            }
        }
    }

    private class InternalTestRunListener
    extends LoadTestRunListenerAdapter {
        private InternalTestRunListener() {
        }

        @Override
        public void beforeLoadTest(LoadTestRunner loadTestRunner, LoadTestRunContext context) {
            LoadTestStatistics.this.samplesStack.clear();
            LoadTestStatistics.this.running = true;
            SoapUI.getThreadPool().submit(LoadTestStatistics.this.updater);
            SoapUI.getThreadPool().submit(LoadTestStatistics.this);
            LoadTestStatistics.this.currentThreadCountStartTime = System.currentTimeMillis();
            LoadTestStatistics.this.totalAverageSum = 0L;
        }

        @Override
        public void afterTestStep(LoadTestRunner loadTestRunner, LoadTestRunContext context, TestCaseRunner testRunner, TestCaseRunContext runContext, TestStepResult testStepResult) {
            if (LoadTestStatistics.this.loadTest.getUpdateStatisticsPerTestStep()) {
                int index;
                TestCase testCase = testRunner.getTestCase();
                if (testStepResult == null) {
                    log.warn("Result is null in TestCase [" + testCase.getName() + "]");
                    return;
                }
                long[] samples = new long[testCase.getTestStepCount()];
                long[] sizes = new long[samples.length];
                long[] sampleCounts = new long[samples.length];
                int n = index = testCase.getIndexOfTestStep(testStepResult.getTestStep());
                sampleCounts[n] = sampleCounts[n] + 1L;
                int n2 = index;
                samples[n2] = samples[n2] + testStepResult.getTimeTaken();
                int n3 = index;
                sizes[n3] = sizes[n3] + testStepResult.getSize();
                LoadTestStatistics.this.pushSamples(samples, sizes, sampleCounts, testRunner.getStartTime(), testRunner.getTimeTaken(), false);
            }
        }

        @Override
        public void afterTestCase(LoadTestRunner loadTestRunner, LoadTestRunContext context, TestCaseRunner testRunner, TestCaseRunContext runContext) {
            if (testRunner.getStatus() == TestRunner.Status.CANCELED && testRunner.getReason().equals(LoadTestStatistics.NO_STATS_TESTCASE_CANCEL_REASON)) {
                return;
            }
            List<TestStepResult> results = testRunner.getResults();
            TestCase testCase = testRunner.getTestCase();
            long[] samples = new long[testCase.getTestStepCount()];
            long[] sizes = new long[samples.length];
            long[] sampleCounts = new long[samples.length];
            for (int c = 0; c < results.size(); ++c) {
                TestStepResult testStepResult = results.get(c);
                if (testStepResult == null) {
                    log.warn("Result [" + c + "] is null in TestCase [" + testCase.getName() + "]");
                    continue;
                }
                int index = testCase.getIndexOfTestStep(testStepResult.getTestStep());
                if (index < 0) continue;
                int n = index;
                sampleCounts[n] = sampleCounts[n] + 1L;
                int n2 = index;
                samples[n2] = samples[n2] + testStepResult.getTimeTaken();
                int n3 = index;
                sizes[n3] = sizes[n3] + testStepResult.getSize();
            }
            LoadTestStatistics.this.pushSamples(samples, sizes, sampleCounts, testRunner.getStartTime(), testRunner.getTimeTaken(), true);
        }

        @Override
        public void afterLoadTest(LoadTestRunner loadTestRunner, LoadTestRunContext context) {
            LoadTestStatistics.this.stop();
        }
    }

    private class InternalTestSuiteListener
    extends TestSuiteListenerAdapter {
        private InternalTestSuiteListener() {
        }

        @Override
        public void testStepAdded(TestStep testStep, int index) {
            if (testStep.getTestCase() == LoadTestStatistics.this.loadTest.getTestCase()) {
                LoadTestStatistics.this.init();
                testStep.addPropertyChangeListener(TestStep.NAME_PROPERTY, LoadTestStatistics.this.propertyChangeListener);
                LoadTestStatistics.this.fireTableDataChanged();
                LoadTestStatistics.this.history.reset();
            }
        }

        @Override
        public void testStepRemoved(TestStep testStep, int index) {
            if (testStep.getTestCase() == LoadTestStatistics.this.loadTest.getTestCase()) {
                LoadTestStatistics.this.init();
                testStep.removePropertyChangeListener(LoadTestStatistics.this.propertyChangeListener);
                LoadTestStatistics.this.fireTableDataChanged();
                LoadTestStatistics.this.history.reset();
            }
        }
    }

    public static enum Statistic {
        MININMUM(0, "min", "the minimum measured teststep time"),
        MAXIMUM(1, "max", "the maximum measured testste time"),
        AVERAGE(2, "avg", "the average measured teststep time"),
        LAST(3, "last", "the last measured teststep time"),
        COUNT(4, "cnt", "the number of teststep samples measured"),
        TPS(5, "tps", "the number of transactions per second for this teststep"),
        BYTES(6, "bytes", "the total number of bytes returned by this teststep"),
        BPS(7, "bps", "the number of bytes per second returned by this teststep"),
        ERRORS(8, "err", "the total number of assertion errors for this teststep"),
        SUM(9, "sum", "internal sum"),
        CURRENT_CNT(10, "ccnt", "internal cnt"),
        ERRORRATIO(11, "rat", "the ratio between exections and failures");

        private final String description;
        private final String name;
        private final int index;

        private Statistic(int index, String name, String description) {
            this.index = index;
            this.name = name;
            this.description = description;
            statisticIndexMap.put(index, this);
        }

        public String getDescription() {
            return this.description;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public static Statistic forIndex(int column) {
            return (Statistic)((Object)statisticIndexMap.get(column));
        }
    }

    private static final class SamplesHolder {
        private final long[] samples;
        private final long[] sizes;
        private final long[] sampleCounts;
        private final long startTime;
        private final long timeTaken;
        private final boolean complete;

        public SamplesHolder(long[] samples, long[] sizes, long[] sampleCounts, long startTime, long timeTaken, boolean complete) {
            this.samples = samples;
            this.sizes = sizes;
            this.startTime = startTime;
            this.timeTaken = timeTaken;
            this.sampleCounts = sampleCounts;
            this.complete = complete;
        }
    }
}

