/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.endpoint;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.CredentialsConfig;
import com.eviware.soapui.config.DefaultEndpointStrategyConfig;
import com.eviware.soapui.config.EndpointConfig;
import com.eviware.soapui.config.ProjectConfig;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.support.AbstractHttpRequestInterface;
import com.eviware.soapui.impl.support.AbstractInterface;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.endpoint.DefaultEndpointStrategyConfigurationPanel;
import com.eviware.soapui.impl.wsdl.submit.filters.HttpAuthenticationRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.WssAuthenticationRequestFilter;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Response;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.project.EndpointStrategy;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.project.ProjectListener;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContainer;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionsResult;
import com.eviware.soapui.model.support.ProjectListenerAdapter;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.types.StringList;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.commons.httpclient.URI;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.xmlbeans.XmlObject;

public class DefaultEndpointStrategy
implements EndpointStrategy,
PropertyExpansionContainer {
    private WsdlProject project;
    private DefaultEndpointStrategyConfig config;
    private Map<String, EndpointDefaults> defaults = new HashMap<String, EndpointDefaults>();
    private PropertyChangeListener propertyChangeListener = new InternalPropertyChangeListener();
    private ProjectListener projectListener = new InternalProjectListener();
    private DefaultEndpointStrategyConfigurationPanel configurationPanel;

    @Override
    public void init(Project project) {
        this.project = (WsdlProject)project;
        this.initConfig();
        project.addProjectListener(this.projectListener);
        for (Interface iface : project.getInterfaceList()) {
            for (String endpoint : iface.getEndpoints()) {
                this.getEndpointDefaults(endpoint);
            }
            iface.addPropertyChangeListener(AbstractInterface.ENDPOINT_PROPERTY, this.propertyChangeListener);
        }
        this.removeUnusedEndpoints();
    }

    private void initConfig() {
        ProjectConfig projectConfig = (ProjectConfig)this.project.getConfig();
        if (!projectConfig.isSetEndpointStrategy()) {
            projectConfig.addNewEndpointStrategy();
        }
        this.config = (DefaultEndpointStrategyConfig)projectConfig.getEndpointStrategy().changeType(DefaultEndpointStrategyConfig.type);
        for (EndpointConfig endpointConfig : this.config.getEndpointList()) {
            if (!endpointConfig.isSetMode()) {
                endpointConfig.setMode(EndpointConfig.Mode.COMPLEMENT);
            }
            this.defaults.put(endpointConfig.getStringValue(), new EndpointDefaults(endpointConfig));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUnusedEndpoints() {
        if (this.config == null) {
            return;
        }
        HashSet<String> endpoints = new HashSet<String>();
        for (Interface iface : this.project.getInterfaceList()) {
            endpoints.addAll(Arrays.asList(iface.getEndpoints()));
        }
        StringList keys = new StringList();
        Map<String, EndpointDefaults> map = this.defaults;
        synchronized (map) {
            for (String key : this.defaults.keySet()) {
                if (endpoints.contains(key)) continue;
                keys.add(key);
            }
            for (String key : keys) {
                EndpointDefaults def = this.defaults.remove(key);
                this.config.getEndpointList().remove(def);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void filterRequest(SubmitContext context, Request wsdlRequest) {
        HttpRequestBase httpMethod = (HttpRequestBase)context.getProperty("httpMethod");
        URI tempUri = (URI)context.getProperty("requestUri");
        java.net.URI uri = null;
        try {
            uri = new java.net.URI(tempUri.toString());
        }
        catch (URISyntaxException e) {
            SoapUI.logError(e);
        }
        if (uri == null) {
            uri = httpMethod.getURI();
        }
        if (uri == null) {
            return;
        }
        EndpointDefaults def = this.defaults.get(uri.toString());
        if (def == null) {
            Map<String, EndpointDefaults> map = this.defaults;
            synchronized (map) {
                URL tempUrl2;
                for (String ep : this.defaults.keySet()) {
                    try {
                        tempUrl2 = new URL(PropertyExpander.expandProperties(context, ep));
                        if (!tempUrl2.toString().equalsIgnoreCase(uri.toString())) continue;
                        def = this.defaults.get(ep);
                        break;
                    }
                    catch (Exception tempUrl2) {
                    }
                }
                if (wsdlRequest instanceof RestRequestInterface) {
                    for (String ep : this.defaults.keySet()) {
                        try {
                            tempUrl2 = new URL(PropertyExpander.expandProperties(context, ep));
                            if (!tempUrl2.getHost().toString().equalsIgnoreCase(uri.getHost().toString())) continue;
                            def = this.defaults.get(ep);
                            break;
                        }
                        catch (Exception exception) {
                        }
                    }
                }
            }
            if (def == null) {
                return;
            }
        }
        this.applyDefaultsToWsdlRequest(context, (AbstractHttpRequestInterface)wsdlRequest, def);
    }

    protected void applyDefaultsToWsdlRequest(SubmitContext context, AbstractHttpRequestInterface<?> wsdlRequest, EndpointDefaults def) {
        String requestUsername = PropertyExpander.expandProperties(context, wsdlRequest.getUsername());
        String requestPassword = PropertyExpander.expandProperties(context, wsdlRequest.getPassword());
        String requestDomain = PropertyExpander.expandProperties(context, wsdlRequest.getDomain());
        String defUsername = PropertyExpander.expandProperties(context, def.getUsername());
        String defPassword = PropertyExpander.expandProperties(context, def.getPassword());
        String defDomain = PropertyExpander.expandProperties(context, def.getDomain());
        CredentialsConfig.AuthType.Enum authType = CredentialsConfig.AuthType.Enum.forString(wsdlRequest.getAuthType());
        if (def.getMode() == EndpointConfig.Mode.OVERRIDE) {
            this.overrideRequest(context, wsdlRequest, def, requestUsername, requestPassword, requestDomain, defUsername, defPassword, defDomain, authType);
        } else if (def.getMode() == EndpointConfig.Mode.COPY) {
            this.copyToRequest(context, wsdlRequest, def, requestUsername, requestPassword, requestDomain, defUsername, defPassword, defDomain, authType);
        } else if (def.getMode() == EndpointConfig.Mode.COMPLEMENT) {
            this.complementRequest(context, wsdlRequest, def, requestUsername, requestPassword, requestDomain, defUsername, defPassword, defDomain, authType);
        }
    }

    private void overrideRequest(SubmitContext context, AbstractHttpRequestInterface<?> wsdlRequest, EndpointDefaults def, String requestUsername, String requestPassword, String requestDomain, String defUsername, String defPassword, String defDomain, CredentialsConfig.AuthType.Enum authType) {
        String password;
        String username = StringUtils.hasContent(defUsername) ? defUsername : requestUsername;
        String string = password = StringUtils.hasContent(defPassword) ? defPassword : requestPassword;
        if (StringUtils.hasContent(username) || StringUtils.hasContent(password)) {
            String wssType = def.getWssType();
            String wssTimeToLive = def.getWssTimeToLive();
            if (wssType == null) {
                String domain = StringUtils.hasContent(defDomain) ? defDomain : requestDomain;
                HttpAuthenticationRequestFilter.initRequestCredentials(context, username, this.project.getSettings(), password, domain, authType);
            }
            if (StringUtils.hasContent(wssType) || StringUtils.hasContent(wssTimeToLive)) {
                try {
                    if (wssTimeToLive != null && wssTimeToLive.length() == 0) {
                        wssTimeToLive = null;
                    }
                    WssAuthenticationRequestFilter.setWssHeaders(context, username, password, wssType, wssTimeToLive);
                }
                catch (Exception e) {
                    SoapUI.logError(e);
                }
            }
        }
    }

    private void copyToRequest(SubmitContext context, AbstractHttpRequestInterface<?> wsdlRequest, EndpointDefaults def, String requestUsername, String requestPassword, String requestDomain, String defUsername, String defPassword, String defDomain, CredentialsConfig.AuthType.Enum authType) {
        String wssType = def.getWssType();
        if (wssType != null) {
            HttpAuthenticationRequestFilter.initRequestCredentials(context, null, this.project.getSettings(), null, null, null);
        } else {
            HttpAuthenticationRequestFilter.initRequestCredentials(context, defUsername, this.project.getSettings(), defPassword, defDomain, authType);
        }
        String wssTimeToLive = def.getWssTimeToLive();
        if (wssTimeToLive == null) {
            wssTimeToLive = "";
        }
        try {
            WssAuthenticationRequestFilter.setWssHeaders(context, defUsername, defPassword, wssType, wssTimeToLive);
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }

    private void complementRequest(SubmitContext context, AbstractHttpRequestInterface<?> httpRequest, EndpointDefaults def, String requestUsername, String requestPassword, String requestDomain, String defUsername, String defPassword, String defDomain, CredentialsConfig.AuthType.Enum authType) {
        String password;
        String username = StringUtils.hasContent(requestUsername) ? requestUsername : defUsername;
        String string = password = StringUtils.hasContent(requestPassword) ? requestPassword : defPassword;
        if (httpRequest instanceof WsdlRequest) {
            String wssTimeToLive;
            WsdlRequest wsdlRequest = (WsdlRequest)httpRequest;
            String wssType = StringUtils.isNullOrEmpty(wsdlRequest.getWssPasswordType()) ? def.getWssType() : (StringUtils.hasContent(username) && StringUtils.hasContent(password) ? null : wsdlRequest.getWssPasswordType());
            String string2 = wssTimeToLive = StringUtils.isNullOrEmpty(wsdlRequest.getWssTimeToLive()) ? def.getWssTimeToLive() : null;
            if (!StringUtils.hasContent(wssType) && (StringUtils.hasContent(username) || StringUtils.hasContent(password))) {
                String domain = StringUtils.hasContent(requestDomain) ? requestDomain : defDomain;
                HttpAuthenticationRequestFilter.initRequestCredentials(context, username, this.project.getSettings(), password, domain, authType);
            } else if (StringUtils.hasContent(wssType) || StringUtils.hasContent(wssTimeToLive)) {
                try {
                    if (wssTimeToLive != null && wssTimeToLive.length() == 0) {
                        wssTimeToLive = null;
                    }
                    if (StringUtils.hasContent(username) || StringUtils.hasContent(password)) {
                        WssAuthenticationRequestFilter.setWssHeaders(context, username, password, wssType, wssTimeToLive);
                    }
                }
                catch (Exception e) {
                    SoapUI.logError(e);
                }
            }
        } else if (StringUtils.hasContent(username) || StringUtils.hasContent(password)) {
            String domain = StringUtils.hasContent(requestDomain) ? requestDomain : defDomain;
            HttpAuthenticationRequestFilter.initRequestCredentials(context, username, this.project.getSettings(), password, domain, authType);
        }
    }

    @Override
    public void release() {
        this.project.removeProjectListener(this.projectListener);
        for (Interface iface : this.project.getInterfaceList()) {
            iface.removePropertyChangeListener(AbstractInterface.ENDPOINT_PROPERTY, this.propertyChangeListener);
        }
        if (this.configurationPanel != null) {
            this.configurationPanel.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointDefaults getEndpointDefaults(String endpoint) {
        if (this.config == null) {
            this.initConfig();
        }
        if (!this.defaults.containsKey(endpoint)) {
            Map<String, EndpointDefaults> map = this.defaults;
            synchronized (map) {
                EndpointConfig newEndpoint = this.config.addNewEndpoint();
                newEndpoint.setStringValue(endpoint);
                this.defaults.put(endpoint, new EndpointDefaults(newEndpoint));
            }
        }
        return this.defaults.get(endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSave() {
        if (this.config == null) {
            return;
        }
        this.removeUnusedEndpoints();
        for (int c = 0; c < this.config.sizeOfEndpointArray(); ++c) {
            EndpointConfig ec = this.config.getEndpointArray(c);
            if (!StringUtils.isNullOrEmpty(ec.getDomain()) || !StringUtils.isNullOrEmpty(ec.getUsername()) || !StringUtils.isNullOrEmpty(ec.getPassword()) || !StringUtils.isNullOrEmpty(ec.getWssType()) || !StringUtils.isNullOrEmpty(ec.getWssTimeToLive()) || !StringUtils.isNullOrEmpty(ec.getIncomingWss()) || !StringUtils.isNullOrEmpty(ec.getOutgoingWss()) || ec.getMode() != EndpointConfig.Mode.COMPLEMENT) continue;
            Map<String, EndpointDefaults> map = this.defaults;
            synchronized (map) {
                this.defaults.remove(ec.getStringValue());
                this.config.removeEndpoint(c);
                --c;
                continue;
            }
        }
        if (this.config.sizeOfEndpointArray() == 0) {
            ((ProjectConfig)this.project.getConfig()).unsetEndpointStrategy();
            this.config = null;
        }
    }

    @Override
    public void importEndpoints(Interface iface) {
        EndpointStrategy ep = iface.getProject().getEndpointStrategy();
        if (ep instanceof DefaultEndpointStrategy) {
            String[] endpoints;
            DefaultEndpointStrategy dep = (DefaultEndpointStrategy)ep;
            for (String endpoint : endpoints = iface.getEndpoints()) {
                this.getEndpointDefaults(endpoint).getConfig().set((XmlObject)dep.getEndpointDefaults(endpoint).getConfig());
            }
        }
    }

    @Override
    public JComponent getConfigurationPanel(Interface iface) {
        this.configurationPanel = new DefaultEndpointStrategyConfigurationPanel(iface, this);
        return this.configurationPanel;
    }

    @Override
    public void afterRequest(SubmitContext context, Response response) {
    }

    @Override
    public PropertyExpansion[] getPropertyExpansions() {
        PropertyExpansionsResult result = new PropertyExpansionsResult(this.project, this);
        for (EndpointDefaults ed : this.defaults.values()) {
            result.addAll(ed.getPropertyExpansions());
        }
        return result.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeEndpoint(String oldEndpoint, String newEndpoint) {
        Map<String, EndpointDefaults> map = this.defaults;
        synchronized (map) {
            EndpointDefaults endpointDefaults = this.defaults.remove(oldEndpoint);
            if (endpointDefaults != null) {
                endpointDefaults.getConfig().setStringValue(newEndpoint);
                this.defaults.put(newEndpoint, endpointDefaults);
            }
        }
    }

    @Override
    public void afterRequest(SubmitContext context, Request request) {
    }

    private class InternalPropertyChangeListener
    implements PropertyChangeListener {
        private InternalPropertyChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String newValue;
            String string = newValue = evt.getNewValue() == null ? null : evt.getNewValue().toString();
            if (evt.getOldValue() == null) {
                DefaultEndpointStrategy.this.getEndpointDefaults(newValue);
            } else if (newValue != null) {
                String oldValue = evt.getOldValue().toString();
                EndpointDefaults def = DefaultEndpointStrategy.this.defaults.containsKey(newValue) ? (EndpointDefaults)DefaultEndpointStrategy.this.defaults.get(newValue) : DefaultEndpointStrategy.this.getEndpointDefaults(oldValue);
                def.endpointConfig.setStringValue(newValue);
                Map map = DefaultEndpointStrategy.this.defaults;
                synchronized (map) {
                    DefaultEndpointStrategy.this.defaults.remove(oldValue);
                    DefaultEndpointStrategy.this.defaults.put(newValue, def);
                }
            } else {
                DefaultEndpointStrategy.this.removeUnusedEndpoints();
            }
        }
    }

    private class InternalProjectListener
    extends ProjectListenerAdapter {
        private InternalProjectListener() {
        }

        @Override
        public void interfaceAdded(Interface iface) {
            for (String endpoint : iface.getEndpoints()) {
                DefaultEndpointStrategy.this.getEndpointDefaults(endpoint);
            }
            iface.addPropertyChangeListener(AbstractInterface.ENDPOINT_PROPERTY, DefaultEndpointStrategy.this.propertyChangeListener);
        }

        @Override
        public void interfaceRemoved(Interface iface) {
            iface.removePropertyChangeListener(AbstractInterface.ENDPOINT_PROPERTY, DefaultEndpointStrategy.this.propertyChangeListener);
            DefaultEndpointStrategy.this.removeUnusedEndpoints();
        }
    }

    public class EndpointDefaults
    implements PropertyExpansionContainer {
        private final EndpointConfig endpointConfig;

        public EndpointConfig getEndpointConfig() {
            return this.endpointConfig;
        }

        public EndpointDefaults(EndpointConfig endpointConfig) {
            this.endpointConfig = endpointConfig;
            if (!endpointConfig.isSetMode()) {
                endpointConfig.setMode(EndpointConfig.Mode.COMPLEMENT);
            }
        }

        public String getDomain() {
            return this.endpointConfig.getDomain();
        }

        public String getPassword() {
            return this.endpointConfig.getPassword();
        }

        public String getUsername() {
            return this.endpointConfig.getUsername();
        }

        public String getWssTimeToLive() {
            return this.endpointConfig.getWssTimeToLive();
        }

        public String getWssType() {
            String wssPasswordType = this.endpointConfig.getWssType();
            return StringUtils.isNullOrEmpty(wssPasswordType) || "None".equals(wssPasswordType) ? null : wssPasswordType;
        }

        public void setDomain(String arg0) {
            this.endpointConfig.setDomain(arg0);
        }

        public void setPassword(String arg0) {
            this.endpointConfig.setPassword(arg0);
        }

        public void setUsername(String arg0) {
            this.endpointConfig.setUsername(arg0);
        }

        public void setWssTimeToLive(String arg0) {
            this.endpointConfig.setWssTimeToLive(arg0);
        }

        public String getIncomingWss() {
            return this.endpointConfig.getIncomingWss();
        }

        public String getOutgoingWss() {
            return this.endpointConfig.getOutgoingWss();
        }

        public void setIncomingWss(String arg0) {
            this.endpointConfig.setIncomingWss(arg0);
        }

        public void setOutgoingWss(String arg0) {
            this.endpointConfig.setOutgoingWss(arg0);
        }

        public void setWssType(String wssPasswordType) {
            if (wssPasswordType == null || wssPasswordType.equals("None")) {
                if (this.endpointConfig.isSetWssType()) {
                    this.endpointConfig.unsetWssType();
                }
            } else {
                this.endpointConfig.setWssType(wssPasswordType);
            }
        }

        public EndpointConfig.Mode.Enum getMode() {
            return this.endpointConfig.getMode();
        }

        public void setMode(EndpointConfig.Mode.Enum mode) {
            this.endpointConfig.setMode(mode);
        }

        protected EndpointConfig getConfig() {
            return this.endpointConfig;
        }

        @Override
        public PropertyExpansion[] getPropertyExpansions() {
            PropertyExpansionsResult result = new PropertyExpansionsResult(DefaultEndpointStrategy.this.project, this);
            result.extractAndAddAll("username");
            result.extractAndAddAll("password");
            result.extractAndAddAll("domain");
            return result.toArray();
        }
    }
}

