/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.loadtest;

import com.eviware.soapui.impl.settings.XmlBeansSettingsImpl;
import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTest;
import com.eviware.soapui.settings.HttpSettings;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import com.eviware.x.form.support.APage;

public class LoadTestOptionsAction
extends AbstractSoapUIAction<WsdlLoadTest> {
    public static final String SOAPUI_ACTION_ID = "LoadTestOptionsAction";
    private XFormDialog dialog;

    public LoadTestOptionsAction() {
        super("Options", "Sets options for this LoadTest");
    }

    @Override
    public void perform(WsdlLoadTest loadTest, Object param) {
        if (this.dialog == null) {
            this.buildDialog();
        }
        this.dialog.setIntValue("Thread Startup Delay", loadTest.getStartDelay());
        this.dialog.setBooleanValue("Reset Statistics", loadTest.getResetStatisticsOnThreadCountChange());
        this.dialog.setBooleanValue("Calculate TPS/BPS", loadTest.getCalculateTPSOnTimePassed());
        this.dialog.setIntValue("Sample Interval", (int)loadTest.getSampleInterval());
        this.dialog.setBooleanValue("Disable History", loadTest.getHistoryLimit() == 0L);
        this.dialog.setIntValue("Max Assertions in Log", (int)loadTest.getMaxAssertionErrors());
        this.dialog.setBooleanValue("Cancel Running", loadTest.getCancelOnReachedLimit());
        this.dialog.setIntValue("Strategy Interval", loadTest.getStrategyInterval());
        this.dialog.setBooleanValue("Cancel Excessive", loadTest.getCancelExcessiveThreads());
        this.dialog.setBooleanValue("TestStep Statistics", loadTest.getUpdateStatisticsPerTestStep());
        XmlBeansSettingsImpl settings = loadTest.getSettings();
        this.dialog.setBooleanValue("Include Request Write", settings.getBoolean(HttpSettings.INCLUDE_REQUEST_IN_TIME_TAKEN));
        this.dialog.setBooleanValue("Include Response Read", settings.getBoolean(HttpSettings.INCLUDE_RESPONSE_IN_TIME_TAKEN));
        this.dialog.setBooleanValue("Close Connections", settings.getBoolean(HttpSettings.CLOSE_CONNECTIONS));
        this.dialog.setValue("Log Folder", loadTest.getStatisticsLogFolder());
        this.dialog.setIntValue("Log Interval", (int)loadTest.getStatisticsLogInterval());
        this.dialog.setBooleanValue("Log on ThreadCount change", loadTest.getLogStatisticsOnThreadChange());
        if (this.dialog.show() && !loadTest.isRunning()) {
            try {
                loadTest.setStartDelay(this.dialog.getIntValue("Thread Startup Delay", loadTest.getStartDelay()));
                loadTest.setResetStatisticsOnThreadCountChange(this.dialog.getBooleanValue("Reset Statistics"));
                loadTest.setCalculateTPSOnTimePassed(this.dialog.getBooleanValue("Calculate TPS/BPS"));
                loadTest.setSampleInterval(this.dialog.getIntValue("Sample Interval", (int)loadTest.getSampleInterval()));
                loadTest.setHistoryLimit(this.dialog.getBooleanValue("Disable History") ? 0L : -1L);
                loadTest.setMaxAssertionErrors(this.dialog.getIntValue("Max Assertions in Log", 1000));
                loadTest.setCancelOnReachedLimit(this.dialog.getBooleanValue("Cancel Running"));
                loadTest.setStrategyInterval(this.dialog.getIntValue("Strategy Interval", 500));
                loadTest.setCancelExcessiveThreads(this.dialog.getBooleanValue("Cancel Excessive"));
                loadTest.setUpdateStatisticsPerTestStep(this.dialog.getBooleanValue("TestStep Statistics"));
                settings.setBoolean(HttpSettings.INCLUDE_REQUEST_IN_TIME_TAKEN, this.dialog.getBooleanValue("Include Request Write"));
                settings.setBoolean(HttpSettings.INCLUDE_RESPONSE_IN_TIME_TAKEN, this.dialog.getBooleanValue("Include Response Read"));
                settings.setBoolean(HttpSettings.CLOSE_CONNECTIONS, this.dialog.getBooleanValue("Close Connections"));
                loadTest.setLogStatisticsOnThreadChange(this.dialog.getBooleanValue("Log on ThreadCount change"));
                loadTest.setStatisticsLogFolder(this.dialog.getValue("Log Folder"));
                loadTest.setStatisticsLogInterval(this.dialog.getIntValue("Log Interval", (int)loadTest.getStatisticsLogInterval()));
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void buildDialog() {
        this.dialog = ADialogBuilder.buildTabbedDialog(WizardForm.class, null);
        this.dialog.getFormField("Disable History").addFormFieldListener(new XFormFieldListener(){

            @Override
            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                LoadTestOptionsAction.this.dialog.getFormField("Sample Interval").setEnabled(!Boolean.parseBoolean(newValue));
            }
        });
    }

    @AForm(name="LoadTest Options", description="", helpUrl="/load-testing/reference/navigation.html", icon="/preferences-system.png")
    private static interface SettingsForm {
        @AField(name="Thread Startup Delay", description="The delay before starting a thread in ms", type=AField.AFieldType.INT)
        public static final String THREAD_STARTUP_DELAY = "Thread Startup Delay";
        @AField(name="Reset Statistics", description="when the number of threads changes", type=AField.AFieldType.BOOLEAN)
        public static final String RESET_STATISTICS = "Reset Statistics";
        @AField(name="Calculate TPS/BPS", description="based on actual time passed", type=AField.AFieldType.BOOLEAN)
        public static final String CALC_TPS = "Calculate TPS/BPS";
        @AField(name="TestStep Statistics", description="update statistics every TestStep", type=AField.AFieldType.BOOLEAN)
        public static final String TESTSTEP_STATISTICS = "TestStep Statistics";
        @AField(name="Include Request Write", description="in calculated time", type=AField.AFieldType.BOOLEAN)
        public static final String INCLUDE_REQUEST = "Include Request Write";
        @AField(name="Include Response Read", description="in calculated time", type=AField.AFieldType.BOOLEAN)
        public static final String INCLUDE_RESPONSE = "Include Response Read";
        @AField(name="Close Connections", description="between each request", type=AField.AFieldType.BOOLEAN)
        public static final String CLOSE_CONNECTIONS = "Close Connections";
        @AField(name="Sample Interval", description="statistics sample interval in milliseconds", type=AField.AFieldType.INT)
        public static final String SAMPLE_INTERVAL = "Sample Interval";
        @AField(name="Disable History", description="to preserve memory (will disable diagrams)", type=AField.AFieldType.BOOLEAN)
        public static final String DISABLE_HISTORY = "Disable History";
        @AField(name="Max Assertions in Log", description="the maximum number of assertion errors to keep in log (to preserve memory)", type=AField.AFieldType.INT)
        public static final String MAX_ASSERTIONS = "Max Assertions in Log";
        @AField(name="Cancel Running", description="Cancel running TestCases when Limit has been reached", type=AField.AFieldType.BOOLEAN)
        public static final String CANCEL_RUNNING = "Cancel Running";
        @AField(name="Cancel Excessive", description="Cancel excessive threads when ThreadCount decreases", type=AField.AFieldType.BOOLEAN)
        public static final String CANCEL_EXCESSIVE = "Cancel Excessive";
        @AField(name="Strategy Interval", description="LoadTest Strategy application interval in milliseconds", type=AField.AFieldType.INT)
        public static final String STRATEGY_INTERVAL = "Strategy Interval";
    }

    @AForm(name="Logging", description="", helpUrl="/load-testing/reference/navigation.html", icon="/preferences-system.png")
    private static interface LogForm {
        @AField(name="Log Folder", description="The folder in which to create log files", type=AField.AFieldType.FOLDER)
        public static final String LOG_FOLDER = "Log Folder";
        @AField(name="Log Interval", description="The log interval in milliseconds, 0 only logs at end", type=AField.AFieldType.INT)
        public static final String LOG_INTERVAL = "Log Interval";
        @AField(name="Log on ThreadCount change", description="Log every time the number of threads changes", type=AField.AFieldType.BOOLEAN)
        public static final String LOG_ON_THREADCOUNT_CHANGE = "Log on ThreadCount change";
    }

    @AForm(description="Set options for this LoadTest", name="LoadTest Options", helpUrl="/load-testing/reference/navigation.html", icon="/applications-system.png")
    private static interface WizardForm {
        @APage(name="Settings")
        public static final SettingsForm INPUT = null;
        @APage(name="Statistics Log")
        public static final LogForm LogForm = null;
    }
}

