/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.iface.tools.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.actions.SoapUIPreferencesAction;
import com.eviware.soapui.impl.support.AbstractInterface;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ArgumentBuilder;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ToolHost;
import com.eviware.soapui.impl.wsdl.support.PathUtils;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.settings.ProjectSettings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.DefaultActionList;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormTextField;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractToolsAction<T extends ModelItem>
extends AbstractSoapUIAction<T> {
    private static final Logger log = LogManager.getLogger(AbstractToolsAction.class);
    protected static final String WSDL = "WSDL";
    protected static final String CACHED_WSDL = "Use cached WSDL";
    protected static final String JAVA_ARGS = "Java Args";
    protected static final String TOOL_ARGS = "Tool Args";
    protected static final String SOAPUISETTINGSPASSWORD = "user-settings.xml Password";
    private XFormDialog dialog;
    protected String valuesSettingID;
    private XFormField useCached;
    private T modelItem;
    private boolean fixedWSDL = false;
    private Action toolsSettingsAction = new ShowIntegratedToolsSettingsAction();

    public AbstractToolsAction(String name, String description) {
        super(name, description);
    }

    public XFormDialog getDialog() {
        return this.dialog;
    }

    public String getValuesSettingID() {
        return this.valuesSettingID;
    }

    public void setValuesSettingID(String valuesSettingID) {
        this.valuesSettingID = valuesSettingID;
    }

    public void setFixedWSDL(boolean b) {
        this.fixedWSDL = b;
    }

    public T getModelItem() {
        return this.modelItem;
    }

    @Override
    public void perform(T target, Object param) {
        this.valuesSettingID = this.getClass().getName() + "@values";
        this.valuesSettingID = target == null ? this.valuesSettingID + "-global" : this.valuesSettingID + "-local";
        this.modelItem = target;
        this.dialog = this.buildDialog(target);
        if (this.dialog == null) {
            try {
                this.generate(this.initValues(target, param), UISupport.getToolHost(), target);
            }
            catch (Exception e1) {
                UISupport.showErrorMessage(e1);
            }
        } else {
            StringToStringMap values = this.initValues(target, param);
            this.dialog.setValues(values);
            this.dialog.setVisible(true);
        }
    }

    public void performHeadless(T target, Object param) {
        this.valuesSettingID = this.getClass().getName() + "@values";
        this.valuesSettingID = target == null ? this.valuesSettingID + "-global" : this.valuesSettingID + "-local";
        this.modelItem = target;
        try {
            this.generate(this.initValues(target, param), UISupport.getToolHost(), target);
        }
        catch (Exception e1) {
            UISupport.showErrorMessage(e1);
        }
    }

    protected StringToStringMap initValues(T modelItem, Object param) {
        String projectRoot;
        StringToStringMap result;
        String settingValues = modelItem == null ? SoapUI.getSettings().getString(this.valuesSettingID, null) : modelItem.getSettings().getString(this.valuesSettingID, null);
        StringToStringMap stringToStringMap = result = settingValues == null ? new StringToStringMap() : StringToStringMap.fromXml(settingValues);
        if (modelItem instanceof WsdlInterface) {
            this.initWSDL(result, (WsdlInterface)modelItem);
        }
        if (this.dialog != null && modelItem != null && (projectRoot = modelItem.getSettings().getString(ProjectSettings.PROJECT_ROOT, null)) != null) {
            this.dialog.setFormFieldProperty(ProjectSettings.PROJECT_ROOT, projectRoot);
        }
        return result;
    }

    protected XFormDialog buildDialog(T modelItem) {
        return null;
    }

    protected void addWSDLFields(XForm mainForm, T modelItem) {
        if (!this.fixedWSDL) {
            XFormTextField tf = mainForm.addTextField(WSDL, "url to wsdl", XForm.FieldType.URL);
            if (modelItem instanceof Interface) {
                this.useCached = mainForm.addCheckBox(CACHED_WSDL, null);
                this.useCached.addComponentEnabler(tf, "false");
            }
        } else if (modelItem instanceof Interface) {
            this.useCached = mainForm.addCheckBox(CACHED_WSDL, null);
        }
    }

    protected void initWSDL(StringToStringMap values, WsdlInterface iface) {
        boolean cached = iface.isCached();
        if (this.useCached != null) {
            this.useCached.setEnabled(cached);
        }
        if (!values.containsKey(CACHED_WSDL)) {
            values.put(CACHED_WSDL, Boolean.toString(cached));
        }
        if (values.getBoolean(CACHED_WSDL) || !values.hasValue(WSDL)) {
            values.put(WSDL, PathUtils.expandPath(iface.getDefinition(), iface));
        }
    }

    protected abstract void generate(StringToStringMap var1, ToolHost var2, T var3) throws Exception;

    public void run(ToolHost toolHost, T modelItem, Object param) throws Exception {
        this.generate(this.initValues(modelItem, param), toolHost, modelItem);
    }

    public void onClose(T modelItem) {
        if (this.dialog == null) {
            return;
        }
        if (modelItem == null) {
            SoapUI.getSettings().setString(this.valuesSettingID, this.dialog.getValues().toXml());
        } else {
            modelItem.getSettings().setString(this.valuesSettingID, this.dialog.getValues().toXml());
        }
    }

    protected String getWsdlUrl(StringToStringMap values, T modelItem) {
        String wsdl = (String)values.get(WSDL);
        boolean useCached = values.getBoolean(CACHED_WSDL);
        if (modelItem instanceof AbstractInterface) {
            AbstractInterface iface = (AbstractInterface)modelItem;
            boolean hasDefinition = StringUtils.hasContent(iface.getDefinition());
            if (wsdl == null && !useCached && hasDefinition) {
                return PathUtils.expandPath(iface.getDefinition(), iface);
            }
            if (!hasDefinition || useCached && iface.getDefinitionContext().isCached()) {
                try {
                    File tempFile = File.createTempFile("tempdir", null);
                    String path = tempFile.getAbsolutePath();
                    tempFile.delete();
                    wsdl = iface.getDefinitionContext().export(path);
                }
                catch (Exception e) {
                    SoapUI.logError(e);
                }
            }
        }
        return wsdl;
    }

    protected String buildClasspath(File jarDir) {
        String[] jars = jarDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        StringBuilder classpath = new StringBuilder();
        for (int c = 0; c < jars.length; ++c) {
            if (c > 0) {
                classpath.append(File.pathSeparatorChar);
            }
            classpath.append(jars[c]);
        }
        return classpath.toString();
    }

    protected ActionList buildDefaultActions(String helpUrl, T modelItem) {
        DefaultActionList actions = new DefaultActionList("Actions");
        if (helpUrl != null) {
            actions.addAction(new ShowOnlineHelpAction(helpUrl));
            actions.addSeparator();
        }
        Action runAction = this.createRunOption(modelItem);
        actions.addAction(runAction);
        actions.setDefaultAction(runAction);
        actions.addAction(new CloseAction(this, modelItem));
        if (this.toolsSettingsAction != null) {
            actions.addAction(this.toolsSettingsAction);
        }
        return actions;
    }

    public Action getToolsSettingsAction() {
        return this.toolsSettingsAction;
    }

    public void setToolsSettingsAction(Action toolsSettingsAction) {
        this.toolsSettingsAction = toolsSettingsAction;
    }

    protected Action createRunOption(T modelItem) {
        return new GenerateAction(this, modelItem);
    }

    protected String getDefinition(T modelItem) {
        if (modelItem == null) {
            return "";
        }
        WsdlInterface iface = (WsdlInterface)modelItem;
        String definition = PathUtils.expandPath(iface.getDefinition(), iface);
        if (definition.startsWith("file:")) {
            definition = definition.substring(5);
        }
        return definition;
    }

    protected void addJavaArgs(StringToStringMap values, ArgumentBuilder builder) {
        String[] javaArgs = Tools.tokenizeArgs((String)values.get(JAVA_ARGS));
        if (javaArgs != null) {
            builder.addArgs(javaArgs);
        }
    }

    protected void addToolArgs(StringToStringMap values, ArgumentBuilder builder) {
        String[] toolArgs = Tools.tokenizeArgs((String)values.get(TOOL_ARGS));
        if (toolArgs != null) {
            builder.addArgs(toolArgs);
        }
    }

    protected XForm buildArgsForm(XFormDialogBuilder builder, boolean addJavaArgs, String toolName) {
        XForm argsForm = builder.createForm("Custom Args");
        if (addJavaArgs) {
            argsForm.addTextField(JAVA_ARGS, "additional arguments to java", XForm.FieldType.TEXT);
        }
        argsForm.addTextField(TOOL_ARGS, "additional arguments to " + toolName, XForm.FieldType.TEXT);
        return argsForm;
    }

    public void closeDialog(T modelItem) {
        this.onClose(modelItem);
        if (this.dialog != null) {
            this.dialog.setVisible(false);
        }
    }

    public static final class ShowIntegratedToolsSettingsAction
    extends AbstractAction {
        public ShowIntegratedToolsSettingsAction() {
            super("Tools");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SoapUIPreferencesAction.getInstance().show("Tools");
        }
    }

    protected static final class CloseAction
    extends AbstractAction {
        private final T modelItem;
        final /* synthetic */ AbstractToolsAction this$0;

        public CloseAction(T modelItem) {
            this.this$0 = this$0;
            super("Close");
            this.modelItem = modelItem;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.this$0.closeDialog(this.modelItem);
        }
    }

    protected static final class GenerateAction
    extends AbstractAction {
        private final T modelItem;
        final /* synthetic */ AbstractToolsAction this$0;

        public GenerateAction(T modelItem) {
            this.this$0 = this$0;
            super("Generate");
            this.modelItem = modelItem;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (this.this$0.dialog.validate()) {
                    this.this$0.generate(this.this$0.dialog.getValues(), UISupport.getToolHost(), this.modelItem);
                }
            }
            catch (Exception e1) {
                UISupport.showErrorMessage(e1);
            }
        }
    }
}

