/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.iface.tools.jaxb;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.analytics.Analytics;
import com.eviware.soapui.analytics.SoapUIActions;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.AbstractToolsAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ArgumentBuilder;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ProcessToolRunner;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ToolHost;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.settings.ToolsSettings;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormFactory;
import java.io.File;

public class JaxbXjcAction
extends AbstractToolsAction<Interface> {
    private static final String PACKAGE = "package";
    private static final String OUTPUT = "output";
    private static final String NOVALIDATION = "no validation";
    private static final String BINDINGS = "binding files";
    private static final String CLASSPATH = "classpath";
    private static final String CATALOG = "catalog";
    private static final String HTTPPROXY = "http proxy";
    private static final String READONLY = "read-only";
    private static final String NPA = "npa";
    private static final String VERBOSE = "verbose";
    public static final String SOAPUI_ACTION_ID = "JaxbXjcAction";
    private String output = null;

    public JaxbXjcAction() {
        super("JAXB 2.0 Artifacts", "Generates JAXB artifacts");
    }

    @Override
    public boolean applies(Interface target) {
        Interface iface = target;
        return !iface.getProject().hasNature("com.eviware.soapui.jbosside.jbosswsNature");
    }

    public void setOutput(String output) {
        this.output = output;
    }

    @Override
    protected StringToStringMap initValues(Interface modelItem, Object param) {
        StringToStringMap values = super.initValues(modelItem, param);
        if (this.output != null) {
            values.put(OUTPUT, this.output);
        }
        return values;
    }

    @Override
    protected XFormDialog buildDialog(Interface modelItem) {
        XFormDialogBuilder builder = XFormFactory.createDialogBuilder("JAXB Artifacts");
        XForm mainForm = builder.createForm("Basic");
        this.addWSDLFields(mainForm, modelItem);
        mainForm.addTextField(OUTPUT, "generated files will go into this directory", XForm.FieldType.PROJECT_FOLDER);
        mainForm.addTextField(PACKAGE, "the target package", XForm.FieldType.JAVA_PACKAGE);
        mainForm.addTextField(BINDINGS, "external bindings file(s), comma-separated", XForm.FieldType.PROJECT_FILE);
        mainForm.addTextField(CATALOG, "catalog files to resolve external entity references", XForm.FieldType.PROJECT_FILE);
        mainForm.addTextField(CLASSPATH, "where to find user class files", XForm.FieldType.PROJECT_FOLDER);
        mainForm.addTextField(HTTPPROXY, "set HTTP/HTTPS proxy. Format is [user[:password]@]proxyHost[:proxyPort]", XForm.FieldType.TEXT);
        mainForm.addCheckBox(READONLY, "(generated files will be in read-only mode)");
        mainForm.addCheckBox(NOVALIDATION, "(do not resolve strict validation of the input schema(s))");
        mainForm.addCheckBox(NPA, "(suppress generation of package level annotations (**/package-info.java))");
        mainForm.addCheckBox(VERBOSE, "(be extra verbose)");
        this.buildArgsForm(builder, false, "xjc");
        return builder.buildDialog(this.buildDefaultActions("http://java.sun.com/webservices/docs/2.0/jaxb/xjc.html", modelItem), "Specify arguments for the JAXB 2 xjc compiler", UISupport.TOOL_ICON);
    }

    @Override
    protected void generate(StringToStringMap values, ToolHost toolHost, Interface modelItem) throws Exception {
        String jaxbDir = SoapUI.getSettings().getString(ToolsSettings.JAXB_LOCATION, null);
        if (Tools.isEmpty(jaxbDir)) {
            UISupport.showErrorMessage("JAXB location must be set in global preferences");
            return;
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        ArgumentBuilder argumentBuilder = this.buildArgs(values, modelItem);
        builder.command(argumentBuilder.getArgs());
        builder.directory(new File(jaxbDir + File.separatorChar + "bin"));
        toolHost.run(new ProcessToolRunner(builder, "JAXB xjc", (ModelItem)modelItem, argumentBuilder));
        Analytics.trackAction(SoapUIActions.USE_JAXB_2_ARTIFACTS_TOOL);
    }

    private ArgumentBuilder buildArgs(StringToStringMap values, Interface modelItem) {
        String[] bindings;
        ArgumentBuilder builder = new ArgumentBuilder(values);
        builder.startScript("xjc", ".bat", ".sh");
        String outputValue = this.output != null ? this.output : (String)values.get(OUTPUT);
        values.put(OUTPUT, Tools.ensureDir(outputValue, ""));
        builder.addString(OUTPUT, "-d");
        builder.addString(PACKAGE, "-p");
        builder.addString(CLASSPATH, "-classpath");
        builder.addString(CATALOG, "-catalog");
        builder.addString(HTTPPROXY, "-httpproxy ");
        builder.addBoolean(NOVALIDATION, "-nv");
        builder.addBoolean(NPA, "-npa");
        builder.addBoolean(READONLY, "-readOnly");
        builder.addBoolean(VERBOSE, "-verbose");
        this.addToolArgs(values, builder);
        builder.addArgs("-wsdl", this.getWsdlUrl(values, modelItem));
        for (String binding : bindings = ((String)values.get(BINDINGS)).split(",")) {
            if (binding.trim().length() <= 0) continue;
            builder.addArgs("-b", binding.trim());
        }
        return builder;
    }
}

