/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.iface.tools.axis2;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.analytics.Analytics;
import com.eviware.soapui.analytics.SoapUIActions;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.AbstractToolsAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ArgumentBuilder;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.NamespaceTable;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ProcessToolRunner;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ToolHost;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.settings.ToolsSettings;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormFactory;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormOptionsField;
import com.eviware.x.form.XFormTextField;
import java.io.File;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.xml.namespace.QName;

public class Axis2WSDL2CodeAction
extends AbstractToolsAction<Interface> {
    private static final String WSDL2JAVA_SCRIPT_NAME = "wsdl2java";
    private static final String PACKAGE = "Package";
    private static final String OUTPUT = "Output Directory";
    private static final String SERVICE_NAME = "service name";
    private static final String PORT_NAME = "port name";
    private static final String ASYNC = "async";
    private static final String SYNC = "sync";
    private static final String TESTCASE = "test-case";
    private static final String SERVERSIDE = "server-side";
    private static final String SERICEDESCRIPTOR = "service descriptor";
    private static final String DATABINDING = "databinding method";
    private static final String GENERATEALL = "generate all";
    private static final String UNPACK = "unpack classes";
    private static final String SERVERSIDEINTERFACE = "serverside-interface";
    private static final String ADB_WRITE = "adb writeClasses";
    private static final String ADB_WRAP = "adb wrapClasses";
    private static final String NAMESPACE_MAPPING = "namespace mapping";
    private static final String JIBX_BINDING_FILE = "JIBX bindingfile";
    public static final String SOAPUI_ACTION_ID = "Axis2WSDL2CodeAction";

    public Axis2WSDL2CodeAction() {
        super("Axis 2 Artifacts", "Generates Axis 2 artifacts using wsdl2java");
    }

    @Override
    protected StringToStringMap initValues(Interface modelItem, Object param) {
        StringToStringMap values = super.initValues(modelItem, param);
        if (!values.hasValue(PORT_NAME) || !values.hasValue(SERVICE_NAME)) {
            this.initServiceAndPort(values, (WsdlInterface)modelItem);
        }
        return values;
    }

    private void initServiceAndPort(StringToStringMap values, WsdlInterface modelItem) {
        if (modelItem == null) {
            return;
        }
        try {
            QName bindingName = modelItem.getBindingName();
            Definition definition = modelItem.getWsdlContext().getDefinition();
            Map services = definition.getAllServices();
            for (Map.Entry entry : services.entrySet()) {
                Service service = (Service)entry.getValue();
                Map portMap = service.getPorts();
                for (String portName : portMap.keySet()) {
                    Port port = (Port)portMap.get(portName);
                    if (!port.getBinding().getQName().equals(bindingName)) continue;
                    values.put(SERVICE_NAME, ((QName)entry.getKey()).getLocalPart());
                    values.put(PORT_NAME, portName);
                    break;
                }
                if (!values.containsKey(PORT_NAME)) continue;
                break;
            }
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }

    @Override
    protected XFormDialog buildDialog(Interface modelItem) {
        XFormDialogBuilder builder = XFormFactory.createDialogBuilder("Axis2 artifacts");
        XForm mainForm = builder.createForm("Basic");
        this.addWSDLFields(mainForm, modelItem);
        mainForm.addTextField(OUTPUT, "root directory for generated files.", XForm.FieldType.PROJECT_FOLDER);
        mainForm.addTextField(PACKAGE, "target package nam", XForm.FieldType.JAVA_PACKAGE);
        XFormOptionsField dbComboBox = mainForm.addComboBox(DATABINDING, new String[]{"xmlbeans", "adb", "jibx", "jaxme"}, "Specifies the Databinding framework.");
        mainForm.addCheckBox(ASYNC, "(generate code only for async style)");
        mainForm.addCheckBox(SYNC, "(generate code only for sync style)");
        mainForm.addCheckBox(TESTCASE, "(Generate a test case)");
        XFormField serverSideCB = mainForm.addCheckBox(SERVERSIDE, "(Generate server side code (i.e. skeletons))");
        XFormField ssiCB = mainForm.addCheckBox(SERVERSIDEINTERFACE, "(Generate interface for server side)");
        XFormField sdCB = mainForm.addCheckBox(SERICEDESCRIPTOR, "(Generate the service descriptor (i.e. server.xml).)");
        serverSideCB.addComponentEnabler(ssiCB, "true");
        serverSideCB.addComponentEnabler(sdCB, "true");
        XForm advForm = builder.createForm("Advanced");
        advForm.addCheckBox(GENERATEALL, "(Genrates all the classes)");
        advForm.addCheckBox(UNPACK, "(Unpacks the databinding classes)");
        advForm.addTextField(SERVICE_NAME, "the service name to be code generated", XForm.FieldType.TEXT);
        advForm.addTextField(PORT_NAME, "the port name to be code generated", XForm.FieldType.TEXT);
        advForm.addComponent(NAMESPACE_MAPPING, new NamespaceTable((WsdlInterface)modelItem));
        XFormField adbWrapCB = advForm.addCheckBox(ADB_WRAP, "(Sets the packing flag. if true the classes will be packed.)");
        XFormField adbWriteCB = advForm.addCheckBox(ADB_WRITE, "(Sets the write flag. If set to true the classes will be written by ADB)");
        XFormTextField jibxCB = advForm.addTextField(JIBX_BINDING_FILE, "The JIBX binding file to use", XForm.FieldType.PROJECT_FILE);
        dbComboBox.addComponentEnabler(adbWrapCB, "adb");
        dbComboBox.addComponentEnabler(adbWriteCB, "adb");
        dbComboBox.addComponentEnabler(jibxCB, "jibx");
        this.buildArgsForm(builder, false, "WSDL2Java");
        return builder.buildDialog(this.buildDefaultActions("http://ws.apache.org/axis2/tools/1_0/CodegenToolReference.html", modelItem), "Specify arguments for Axis 2.X Wsdl2Java", UISupport.TOOL_ICON);
    }

    @Override
    protected void generate(StringToStringMap values, ToolHost toolHost, Interface modelItem) throws Exception {
        String axis2Dir = SoapUI.getSettings().getString(ToolsSettings.AXIS_2_LOCATION, null);
        if (Tools.isEmpty(axis2Dir)) {
            UISupport.showErrorMessage("Axis 2 wsdl2java directory must be set in global preferences");
            return;
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        ArgumentBuilder args = this.buildArgs(values, (WsdlInterface)modelItem);
        builder.command(args.getArgs());
        builder.directory(new File(axis2Dir + File.separatorChar + "bin"));
        toolHost.run(new ProcessToolRunner(builder, "Axis2 wsdl2java", (ModelItem)modelItem));
        Analytics.trackAction(SoapUIActions.USE_AXIS_2_ARTIFACTS_TOOL);
    }

    private ArgumentBuilder buildArgs(StringToStringMap values, WsdlInterface modelItem) {
        values.put(OUTPUT, Tools.ensureDir((String)values.get(OUTPUT), ""));
        ArgumentBuilder builder = new ArgumentBuilder(values);
        builder.startScript(WSDL2JAVA_SCRIPT_NAME);
        builder.addArgs("-uri", this.getWsdlUrl(values, modelItem));
        builder.addString(OUTPUT, "-o");
        builder.addString(PACKAGE, "p");
        builder.addString(DATABINDING, "-d");
        builder.addBoolean(ASYNC, "-a");
        builder.addBoolean(SYNC, "-s");
        builder.addBoolean(TESTCASE, "-t");
        builder.addBoolean(SERVERSIDE, "-ss");
        builder.addBoolean(SERVERSIDEINTERFACE, "-ssi");
        builder.addBoolean(SERICEDESCRIPTOR, "-sd");
        builder.addBoolean(GENERATEALL, "-g");
        builder.addBoolean(UNPACK, "-u");
        builder.addString(SERVICE_NAME, "-sn");
        builder.addString(PORT_NAME, "-pn");
        if ("adb".equals(values.get(DATABINDING))) {
            builder.addBoolean(ADB_WRAP, "-Ew", "true", "false");
            builder.addBoolean(ADB_WRITE, "-Er");
        }
        if ("jibx".equals(values.get(DATABINDING))) {
            builder.addString(JIBX_BINDING_FILE, "-E", "");
        }
        try {
            StringBuilder nsMapArg = new StringBuilder();
            StringToStringMap nsMappings = StringToStringMap.fromXml((String)values.get(NAMESPACE_MAPPING));
            for (Map.Entry entry : nsMappings.entrySet()) {
                if (nsMapArg.length() > 0) {
                    nsMapArg.append(',');
                }
                nsMapArg.append((String)entry.getKey()).append('=').append((String)entry.getValue());
            }
            builder.addArgs("-ns2p", nsMapArg.toString());
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        this.addToolArgs(values, builder);
        return builder;
    }
}

