/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.iface;

import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.registry.WsdlTestRequestStepFactory;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormOptionsField;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import java.util.List;

public class GenerateWsdlTestSuiteAction
extends AbstractSoapUIAction<WsdlInterface> {
    public GenerateWsdlTestSuiteAction() {
        super("Generate TestSuite", "Generates TestSuite with TestCase(s) for all Operations in this Interface");
    }

    @Override
    public void perform(WsdlInterface target, Object param) {
        this.generateTestSuite(target, false);
    }

    public WsdlTestSuite generateTestSuite(WsdlInterface iface, boolean atCreation) {
        XFormDialog dialog = ADialogBuilder.buildDialog(GenerateForm.class);
        dialog.setValue("Style", "One TestCase for each Operation");
        dialog.setValue("Request Content", "Create new empty requests");
        Object[] names = ModelSupport.getNames(iface.getOperationList());
        dialog.setOptions("Operations", names);
        XFormOptionsField operationsFormField = (XFormOptionsField)dialog.getFormField("Operations");
        operationsFormField.setSelectedOptions(names);
        WsdlProject project = iface.getProject();
        Object[] testSuites = ModelSupport.getNames(new String[]{"<create>"}, project.getTestSuiteList());
        dialog.setOptions("TestSuite", testSuites);
        if (dialog.show()) {
            List<String> operations = StringUtils.toStringList(operationsFormField.getSelectedOptions());
            if (operations.size() == 0) {
                UISupport.showErrorMessage("No Operations selected..");
                return null;
            }
            String testSuiteName = dialog.getValue("TestSuite");
            if (testSuiteName.equals("<create>")) {
                testSuiteName = UISupport.prompt("Enter name of TestSuite to create", "Generate TestSuite", iface.getName() + " TestSuite");
            }
            if (testSuiteName != null && testSuiteName.trim().length() > 0) {
                WsdlTestSuite testSuite = project.getTestSuiteByName(testSuiteName);
                if (testSuite == null) {
                    testSuite = project.addNewTestSuite(testSuiteName);
                }
                int style = dialog.getValueIndex("Style");
                boolean useExistingRequests = dialog.getValueIndex("Request Content") == 0;
                boolean generateLoadTest = dialog.getBooleanValue("Generate LoadTest");
                if (style == 0) {
                    this.generateMulipleTestCases(testSuite, iface, useExistingRequests, generateLoadTest, operations);
                } else if (style == 1) {
                    this.generateSingleTestCase(testSuite, iface, useExistingRequests, generateLoadTest, operations);
                }
                if (!atCreation) {
                    UISupport.showDesktopPanel(testSuite);
                }
                return testSuite;
            }
        }
        return null;
    }

    private void generateSingleTestCase(WsdlTestSuite testSuite, WsdlInterface iface, boolean useExisting, boolean createLoadTest, List<String> operations) {
        WsdlTestCase testCase = testSuite.addNewTestCase(iface.getName() + " TestSuite");
        for (int i = 0; i < iface.getOperationCount(); ++i) {
            WsdlOperation operation = iface.getOperationAt(i);
            if (!operations.contains(operation.getName())) continue;
            if (useExisting && operation.getRequestCount() > 0) {
                for (int x = 0; x < operation.getRequestCount(); ++x) {
                    testCase.addTestStep(WsdlTestRequestStepFactory.createConfig(operation.getRequestAt(x), operation.getName()));
                }
                continue;
            }
            testCase.addTestStep(WsdlTestRequestStepFactory.createConfig(operation, operation.getName()));
        }
        if (createLoadTest) {
            testCase.addNewLoadTest("LoadTest 1");
        }
    }

    private void generateMulipleTestCases(WsdlTestSuite testSuite, WsdlInterface iface, boolean useExisting, boolean createLoadTest, List<String> operations) {
        for (int i = 0; i < iface.getOperationCount(); ++i) {
            WsdlOperation operation = iface.getOperationAt(i);
            if (!operations.contains(operation.getName())) continue;
            WsdlTestCase testCase = testSuite.addNewTestCase(operation.getName() + " TestCase");
            if (useExisting && operation.getRequestCount() > 0) {
                for (int x = 0; x < operation.getRequestCount(); ++x) {
                    testCase.addTestStep(WsdlTestRequestStepFactory.createConfig(operation.getRequestAt(x), operation.getName()));
                }
            } else {
                testCase.addTestStep(WsdlTestRequestStepFactory.createConfig(operation, operation.getName()));
            }
            if (!createLoadTest) continue;
            testCase.addNewLoadTest("LoadTest 1");
        }
    }

    @AForm(name="Generate TestSuite", description="Generates TestSuite with TestCase(s) for all Operations in this Interface", helpUrl="/Functional-Testing/structuring-and-running-tests.html", icon="/applications-system.png")
    private class GenerateForm {
        @AField(name="TestSuite", description="The TestSuite to create or use", type=AField.AFieldType.ENUMERATION)
        public static final String TESTSUITE = "TestSuite";
        @AField(name="Style", description="Select the style of TestCases to create", type=AField.AFieldType.RADIOGROUP, values={"One TestCase for each Operation", "Single TestCase with one Request for each Operation"})
        public static final String STYLE = "Style";
        @AField(name="Request Content", description="Select how to create Test Requests", type=AField.AFieldType.RADIOGROUP, values={"Use existing Requests in Interface", "Create new empty requests"})
        public static final String REQUEST_CONTENT = "Request Content";
        @AField(name="Operations", description="The Operations for which to Generate Tests", type=AField.AFieldType.MULTILIST)
        public static final String OPERATIONS = "Operations";
        @AField(name="Generate LoadTest", description="Generates a default LoadTest for each created TestCase", type=AField.AFieldType.BOOLEAN)
        public static final String GENERATE_LOADTEST = "Generate LoadTest";

        private GenerateForm() {
        }
    }
}

