/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.AnonymousTypeConfig;
import com.eviware.soapui.config.DefinitionCacheConfig;
import com.eviware.soapui.config.OperationConfig;
import com.eviware.soapui.config.SoapVersionTypesConfig;
import com.eviware.soapui.config.WsaVersionTypeConfig;
import com.eviware.soapui.config.WsdlInterfaceConfig;
import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.support.AbstractHttpRequestInterface;
import com.eviware.soapui.impl.support.AbstractInterface;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.support.ExternalDependency;
import com.eviware.soapui.impl.wsdl.support.InterfaceExternalDependency;
import com.eviware.soapui.impl.wsdl.support.PathUtils;
import com.eviware.soapui.impl.wsdl.support.policy.PolicyUtils;
import com.eviware.soapui.impl.wsdl.support.soap.SoapMessageBuilder;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlContext;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlLoader;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlUtils;
import com.eviware.soapui.impl.wsdl.teststeps.BeanPathPropertySupport;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.settings.WsaSettings;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.resolver.ResolveContext;
import com.eviware.soapui.support.types.StringList;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ElementExtensible;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3.x2006.x05.addressing.wsdl.UsingAddressingDocument;
import org.w3.x2007.x05.addressing.metadata.AddressingDocument;
import org.w3.x2007.x05.addressing.metadata.AnonymousResponsesDocument;
import org.w3.x2007.x05.addressing.metadata.NonAnonymousResponsesDocument;
import org.xmlsoap.schemas.ws.x2004.x09.policy.Policy;

public class WsdlInterface
extends AbstractInterface<WsdlInterfaceConfig> {
    public static final String STYLE_DOCUMENT = "Document";
    public static final String STYLE_RPC = "RPC";
    public static final String JBOSSWS_ACTIONS = "jbossws";
    public static final String WSTOOLS_ACTIONS = "wstools";
    public static final String XML_ACTIONS = "xml";
    private static final Logger log = LogManager.getLogger(WsdlInterface.class);
    private List<WsdlOperation> operations = new ArrayList<WsdlOperation>();
    private WsdlProject project;
    private SoapMessageBuilder soapMessageBuilder;
    private WsdlContext wsdlContext;
    private boolean updating = false;
    private BeanPathPropertySupport definitionProperty;
    private String interfaceAnonymous;
    private String interfaceWsaVersion;
    boolean policyFlag = false;

    public WsdlInterface(WsdlProject project, WsdlInterfaceConfig interfaceConfig) {
        super(interfaceConfig, project, "/interface.png");
        if (!interfaceConfig.isSetWsaVersion()) {
            interfaceConfig.setWsaVersion(WsaVersionTypeConfig.NONE);
        }
        this.project = project;
        List<OperationConfig> operationConfigs = interfaceConfig.getOperationList();
        for (int i = 0; i < operationConfigs.size(); ++i) {
            this.operations.add(new WsdlOperation(this, operationConfigs.get(i)));
        }
        this.definitionProperty = new BeanPathPropertySupport(this, "definition");
    }

    @Override
    public WsdlOperation getOperationAt(int index) {
        return this.operations.get(index);
    }

    @Override
    public int getOperationCount() {
        return this.operations.size();
    }

    public WsdlOperation addNewOperation(BindingOperation operation) {
        WsdlOperation operationImpl = new WsdlOperation(this, ((WsdlInterfaceConfig)this.getConfig()).addNewOperation());
        this.operations.add(operationImpl);
        operationImpl.initFromBindingOperation(operation);
        this.fireOperationAdded(operationImpl);
        return operationImpl;
    }

    @Override
    public WsdlProject getProject() {
        return this.project;
    }

    public void setDefinition(String wsdlUrl) throws Exception {
        this.setDefinition(wsdlUrl, true);
    }

    public void setDefinition(String wsdlUrl, boolean updateCache) throws Exception {
        String old = this.definitionProperty.set(wsdlUrl, false);
        if (this.wsdlContext != null) {
            this.wsdlContext.setDefinition(this.definitionProperty.expandUrl(), updateCache);
        }
        this.notifyPropertyChanged(DEFINITION_PROPERTY, old, wsdlUrl);
        this.notifyPropertyChanged(UPDATING_PROPERTY, true, false);
    }

    public DefinitionCacheConfig cacheDefinition(WsdlLoader loader) throws Throwable {
        log.debug("Caching definition for [" + loader.getBaseURI() + "]");
        if (((WsdlInterfaceConfig)this.getConfig()).isSetDefinitionCache()) {
            ((WsdlInterfaceConfig)this.getConfig()).unsetDefinitionCache();
        }
        DefinitionCacheConfig definitionCache = null;
        try {
            definitionCache = ((WsdlInterfaceConfig)this.getConfig()).addNewDefinitionCache();
            definitionCache.set(WsdlUtils.cacheWsdl(loader));
        }
        catch (Throwable e) {
            ((WsdlInterfaceConfig)this.getConfig()).unsetDefinitionCache();
            throw e;
        }
        return definitionCache;
    }

    @Override
    public String getDefinition() {
        if (!((WsdlInterfaceConfig)this.getConfig()).isSetDefinition()) {
            return null;
        }
        String result = this.definitionProperty.get();
        if (PathUtils.isFilePath(result) && !PathUtils.isRelativePath(result) && !result.startsWith("file:") && !result.startsWith("$")) {
            try {
                result = new File(result).toURI().toURL().toString();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public String getType() {
        return "wsdl";
    }

    @Override
    public boolean isDefinitionShareble() {
        return true;
    }

    public synchronized WsdlContext getWsdlContext() {
        if (this.wsdlContext == null) {
            this.wsdlContext = new WsdlContext(PathUtils.expandPath(this.getDefinition(), this), this);
        }
        return this.wsdlContext;
    }

    public void setWsdlContext(WsdlContext wsdlContext) {
        this.wsdlContext = wsdlContext;
        this.wsdlContext.setInterface(this);
        if (this.soapMessageBuilder != null) {
            this.soapMessageBuilder.setWsdlContext(wsdlContext);
        }
    }

    public SoapMessageBuilder getMessageBuilder() {
        if (this.soapMessageBuilder == null) {
            try {
                this.soapMessageBuilder = new SoapMessageBuilder(this);
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
        }
        return this.soapMessageBuilder;
    }

    public void setSoapMessageBuilder(SoapMessageBuilder builder) {
        this.soapMessageBuilder = builder;
        this.soapMessageBuilder.setInterface(this);
    }

    public QName getBindingName() {
        return ((WsdlInterfaceConfig)this.getConfig()).getBindingName() == null ? null : QName.valueOf(((WsdlInterfaceConfig)this.getConfig()).getBindingName());
    }

    public void setBindingName(QName name) {
        ((WsdlInterfaceConfig)this.getConfig()).setBindingName(name.toString());
    }

    public SoapVersion getSoapVersion() {
        if (((WsdlInterfaceConfig)this.getConfig()).getSoapVersion() == SoapVersionTypesConfig.X_1_2) {
            return SoapVersion.Soap12;
        }
        return SoapVersion.Soap11;
    }

    public void setSoapVersion(SoapVersion version) {
        if (version == SoapVersion.Soap11) {
            ((WsdlInterfaceConfig)this.getConfig()).setSoapVersion(SoapVersionTypesConfig.X_1_1);
        } else if (version == SoapVersion.Soap12) {
            ((WsdlInterfaceConfig)this.getConfig()).setSoapVersion(SoapVersionTypesConfig.X_1_2);
        } else {
            throw new RuntimeException("Unknown soapVersion [" + version + "], must be 1.1 or 1.2");
        }
    }

    public boolean updateDefinition(String url, boolean createRequests) throws Exception {
        WsdlContext.uncache(url);
        WsdlContext newContext = new WsdlContext(url, (WsdlInterface)null);
        if (!newContext.load()) {
            return false;
        }
        BindingTuple tuple = this.findBinding(newContext);
        if (tuple == null) {
            return false;
        }
        this.setBindingName(tuple.binding.getQName());
        if (this.getSettings().getBoolean(WsdlSettings.NAME_WITH_BINDING)) {
            this.setName(tuple.binding.getQName().getLocalPart());
        }
        this.setWsdlContext(newContext);
        this.transferOperations(tuple.binding, createRequests);
        this.setDefinition(url, false);
        this.transferEndpoints(tuple.port);
        this.updateWsaPolicy(url, newContext);
        this.getProject().fireInterfaceUpdated(this);
        return true;
    }

    private void updateWsaPolicy(String url, WsdlContext newContext) throws Exception {
        Definition definition = newContext.getDefinition();
        this.policyFlag = false;
        this.processPolicy(PolicyUtils.getAttachedPolicy((ElementExtensible)this.getBinding(), definition));
        Map serviceMap = definition.getAllServices();
        if (serviceMap.isEmpty()) {
            log.info("Missing services in [" + url + "], check for bindings");
        } else {
            for (Service service : serviceMap.values()) {
                Map portMap = service.getPorts();
                for (Port port : portMap.values()) {
                    this.processPolicy(PolicyUtils.getAttachedPolicy((ElementExtensible)port, definition));
                }
            }
        }
    }

    public BindingTuple prepareUpdateDefinition(String url) throws Exception {
        WsdlContext newContext = new WsdlContext(url, this.getSoapVersion());
        if (!newContext.load()) {
            return null;
        }
        BindingTuple tuple = this.findBinding(newContext);
        return tuple;
    }

    public void updateDefinition(BindingTuple tuple) throws Exception {
        this.setBindingName(tuple.binding.getQName());
        if (((WsdlInterfaceConfig)this.getConfig()).isSetDefinitionCache()) {
            ((WsdlInterfaceConfig)this.getConfig()).unsetDefinitionCache();
        }
        if (this.getSettings().getBoolean(WsdlSettings.NAME_WITH_BINDING)) {
            this.setName(tuple.binding.getQName().getLocalPart());
        }
        this.wsdlContext = tuple.context;
        this.wsdlContext.setInterface(this);
        if (this.soapMessageBuilder != null) {
            this.soapMessageBuilder.setWsdlContext(this.wsdlContext);
        }
    }

    public BindingOperation findBindingOperation(Definition definition, String bindingOperationName, String inputName, String outputName) {
        Binding binding = definition.getBinding(this.getBindingName());
        return WsdlUtils.findBindingOperation(binding, bindingOperationName, inputName, outputName);
    }

    public Binding getBinding() {
        try {
            return this.findBinding((WsdlContext)this.getWsdlContext()).binding;
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return null;
        }
    }

    private BindingTuple findBinding(WsdlContext newContext) throws Exception {
        BindingTuple tuple = new BindingTuple();
        tuple.context = newContext;
        Definition definition = newContext.getDefinition();
        Map serviceMap = definition.getAllServices();
        Iterator i = serviceMap.keySet().iterator();
        while (i.hasNext()) {
            tuple.service = (Service)serviceMap.get(i.next());
            Map portMap = tuple.service.getPorts();
            Iterator i2 = portMap.keySet().iterator();
            while (i2.hasNext()) {
                tuple.port = (Port)portMap.get(i2.next());
                if (!tuple.port.getBinding().getQName().equals(this.getBindingName())) continue;
                tuple.binding = tuple.port.getBinding();
            }
            if (tuple.binding != null) break;
            tuple.service = null;
        }
        if (tuple.service == null && tuple.binding == null) {
            tuple.binding = definition.getBinding(this.getBindingName());
        }
        if (tuple.binding == null) {
            Map bindings = definition.getAllBindings();
            Object retval = UISupport.prompt("Missing matching binding [" + this.getBindingName() + "] in definition, select new\nbinding to map to", "Map Binding", bindings.keySet().toArray());
            if (retval == null) {
                return null;
            }
            tuple.binding = (Binding)bindings.get(retval);
        }
        return tuple;
    }

    public void transferOperations(Binding binding, boolean createRequests) {
        WsdlOperation wsdlOperation;
        int c;
        ArrayList newOperations = new ArrayList(binding.getBindingOperations());
        HashMap<String, WsdlOperation> oldOperations = new HashMap<String, WsdlOperation>();
        for (c = 0; c < this.operations.size(); ++c) {
            oldOperations.put(this.operations.get(c).getBindingOperationName(), this.operations.get(c));
        }
        for (c = 0; c < newOperations.size(); ++c) {
            BindingOperation newOperation = (BindingOperation)newOperations.get(c);
            String bindingOperationName = newOperation.getName();
            if (!oldOperations.containsKey(bindingOperationName)) continue;
            log.info("Synchronizing existing operation [" + bindingOperationName + "]");
            wsdlOperation = (WsdlOperation)oldOperations.get(bindingOperationName);
            WsdlUtils.getAnonymous(wsdlOperation);
            wsdlOperation.initFromBindingOperation(newOperation);
            this.fireOperationUpdated(wsdlOperation);
            oldOperations.remove(bindingOperationName);
            newOperations.remove(c);
            --c;
        }
        Iterator i = oldOperations.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (newOperations.size() > 0) {
                int ix;
                ArrayList<String> list = new ArrayList<String>();
                list.add("none - delete operation");
                for (int c2 = 0; c2 < newOperations.size(); ++c2) {
                    list.add(((BindingOperation)newOperations.get(c2)).getName());
                }
                String retval = (String)UISupport.prompt("Binding operation [" + name + "] not found in new interface, select new\nbinding operation to map to", "Map Operation", list.toArray(), "none/cancel - delete operation");
                int n = ix = retval == null ? -1 : list.indexOf(retval) - 1;
                if (ix < 0) {
                    this.deleteOperation(name);
                } else {
                    BindingOperation newOperation = (BindingOperation)newOperations.get(ix);
                    WsdlOperation wsdlOperation2 = (WsdlOperation)oldOperations.get(name);
                    wsdlOperation2.initFromBindingOperation(newOperation);
                    this.fireOperationUpdated(wsdlOperation2);
                    newOperations.remove(ix);
                }
                oldOperations.remove(name);
            } else {
                this.deleteOperation(name);
                oldOperations.remove(name);
            }
            i = oldOperations.keySet().iterator();
        }
        if (newOperations.size() > 0) {
            for (int c3 = 0; c3 < newOperations.size(); ++c3) {
                BindingOperation newOperation = (BindingOperation)newOperations.get(c3);
                wsdlOperation = this.addNewOperation(newOperation);
                if (!createRequests) continue;
                WsdlRequest request = wsdlOperation.addNewRequest("Request 1");
                try {
                    request.setRequestContent(wsdlOperation.createRequest(true));
                    continue;
                }
                catch (Exception e) {
                    SoapUI.logError(e);
                }
            }
        }
    }

    public void transferEndpoints(Port port) {
        String endpoint;
        if (port != null && (endpoint = WsdlUtils.getSoapEndpoint(port)) != null) {
            int c;
            StringList list = new StringList(this.getEndpoints());
            for (c = 0; c < list.size(); ++c) {
                list.set(c, PropertyExpander.expandProperties(this, (String)list.get(c)));
            }
            if (!list.contains(endpoint)) {
                if (UISupport.confirm("Update existing requests with new endpoint\n[" + endpoint + "]", "Update Definition")) {
                    for (c = 0; c < this.getOperationCount(); ++c) {
                        WsdlOperation operation = this.getOperationAt(c);
                        for (int ix = 0; ix < operation.getRequestCount(); ++ix) {
                            operation.getRequestAt(ix).setEndpoint(endpoint);
                        }
                    }
                }
                this.addEndpoint(endpoint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteOperation(String bindingOperationName) {
        for (int c = 0; c < this.operations.size(); ++c) {
            WsdlOperation wsdlOperation = this.operations.get(c);
            if (!wsdlOperation.getBindingOperationName().equals(bindingOperationName)) continue;
            log.info("deleting operation [" + bindingOperationName + "]");
            while (wsdlOperation.getRequestCount() > 0) {
                wsdlOperation.removeRequest(wsdlOperation.getRequestAt(0));
            }
            this.operations.remove(c);
            try {
                this.fireOperationRemoved(wsdlOperation);
            }
            finally {
                wsdlOperation.release();
                ((WsdlInterfaceConfig)this.getConfig()).removeOperation(c);
            }
            return;
        }
    }

    public void removeOperation(WsdlOperation wsdlOperation) {
        int c = this.operations.indexOf(wsdlOperation);
        if (c < 0) {
            throw new IllegalArgumentException(wsdlOperation.getName() + " not found");
        }
        log.info("deleting operation [" + wsdlOperation.getName() + "]");
        while (wsdlOperation.getRequestCount() > 0) {
            wsdlOperation.removeRequest(wsdlOperation.getRequestAt(0));
        }
        this.operations.remove(c);
        try {
            this.fireOperationRemoved(wsdlOperation);
        }
        finally {
            wsdlOperation.release();
            ((WsdlInterfaceConfig)this.getConfig()).removeOperation(c);
        }
    }

    @Override
    public WsdlOperation getOperationByName(String name) {
        return (WsdlOperation)this.getWsdlModelItemByName(this.operations, name);
    }

    public Map<String, Operation> getOperations() {
        HashMap<String, Operation> result = new HashMap<String, Operation>();
        for (Operation operation : this.operations) {
            result.put(operation.getName(), operation);
        }
        return result;
    }

    public boolean isCached() {
        if (this.wsdlContext != null && this.wsdlContext.isCached()) {
            return true;
        }
        DefinitionCacheConfig cacheConfig = ((WsdlInterfaceConfig)this.getConfig()).getDefinitionCache();
        return cacheConfig != null && cacheConfig.getRootPart() != null && cacheConfig.sizeOfPartArray() != 0;
    }

    public String getStyle() {
        if (this.wsdlContext == null || !this.wsdlContext.isLoaded()) {
            return "<not loaded>";
        }
        try {
            Binding binding = this.wsdlContext.getDefinition().getBinding(this.getBindingName());
            if (binding == null) {
                return "<missing binding>";
            }
            if (WsdlUtils.isRpc(binding)) {
                return STYLE_RPC;
            }
            return STYLE_DOCUMENT;
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return "<error>";
        }
    }

    @Override
    public void release() {
        super.release();
        for (WsdlOperation operation : this.operations) {
            operation.release();
        }
        if (this.wsdlContext != null) {
            this.wsdlContext.release();
        }
    }

    @Override
    public List<Operation> getOperationList() {
        return new ArrayList<Operation>(this.operations);
    }

    public boolean isUpdating() {
        return this.updating;
    }

    public void setUpdating(boolean updating) {
        if (this.updating == updating) {
            return;
        }
        if (updating) {
            List<AbstractWsdlModelItem<?>> messages = this.getAllMessages();
            for (AbstractWsdlModelItem<?> modelItem : messages) {
                modelItem.beforeSave();
            }
        }
        boolean oldValue = this.updating;
        this.updating = updating;
        this.notifyPropertyChanged(UPDATING_PROPERTY, oldValue, updating);
    }

    public List<AbstractWsdlModelItem<?>> getAllMessages() {
        ArrayList list = new ArrayList();
        this.getAllMessages(this.getProject(), list);
        return list;
    }

    private void getAllMessages(ModelItem modelItem, List<AbstractWsdlModelItem<?>> list) {
        WsdlMockResponse mockResponse;
        if (modelItem instanceof AbstractHttpRequestInterface) {
            AbstractHttpRequest wsdlRequest = (AbstractHttpRequest)modelItem;
            if (wsdlRequest.getOperation().getInterface() == this) {
                list.add(wsdlRequest);
            }
        } else if (modelItem instanceof WsdlTestRequestStep) {
            WsdlTestRequestStep testRequestStep = (WsdlTestRequestStep)modelItem;
            WsdlTestRequest wsdlTestRequest = testRequestStep.getTestRequest();
            if (wsdlTestRequest != null && wsdlTestRequest.getOperation() != null && wsdlTestRequest.getOperation().getInterface() == this) {
                list.add(wsdlTestRequest);
            }
        } else if (modelItem instanceof WsdlMockResponse && (mockResponse = (WsdlMockResponse)modelItem).getMockOperation() != null && mockResponse.getMockOperation().getOperation() != null && mockResponse.getMockOperation().getOperation().getInterface() == this) {
            list.add(mockResponse);
        }
        for (ModelItem modelItem2 : modelItem.getChildren()) {
            this.getAllMessages(modelItem2, list);
        }
    }

    @Override
    public void addExternalDependencies(List<ExternalDependency> dependencies) {
        super.addExternalDependencies(dependencies);
        dependencies.add(new InterfaceExternalDependency(this.definitionProperty));
    }

    @Override
    public void resolve(ResolveContext<?> context) {
        super.resolve(context);
        String definition = this.definitionProperty.expandUrl();
        if (!this.isCached() && definition.startsWith("file:")) {
            try {
                File file = new File(definition.substring(5));
                if (!file.exists()) {
                    if (context.hasThisModelItem(this, "Missing WSDL file", definition)) {
                        return;
                    }
                    context.addPathToResolve(this, "Missing WSDL file", definition, new ResolveContext.FileResolver("Select WSDL File", "wsdl", "WSDL Files (*.wsdl)", file.getParent()){

                        @Override
                        public boolean apply(File newFile) {
                            try {
                                WsdlInterface.this.setDefinition(newFile.toURI().toURL().toString());
                                return true;
                            }
                            catch (Exception e) {
                                log.error("Invalid URL for new Definition", (Throwable)e);
                                return false;
                            }
                        }
                    });
                } else if (context.hasThisModelItem(this, "Missing WSDL file", definition)) {
                    context.getPath(this, "Missing WSDL file", definition).setSolved(true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getInterfaceType() {
        return "wsdl";
    }

    @Override
    public String getTechnicalId() {
        return this.getBindingName().toString();
    }

    public String getWsaVersion() {
        if (((Object)((Object)((WsdlInterfaceConfig)this.getConfig()).getWsaVersion())).equals((Object)WsaVersionTypeConfig.X_200408)) {
            return WsaVersionTypeConfig.X_200408.toString();
        }
        if (((Object)((Object)((WsdlInterfaceConfig)this.getConfig()).getWsaVersion())).equals((Object)WsaVersionTypeConfig.X_200508)) {
            return WsaVersionTypeConfig.X_200508.toString();
        }
        return WsaVersionTypeConfig.NONE.toString();
    }

    public void setWsaVersion(String wsAddressing) {
        if (wsAddressing.equals(WsaVersionTypeConfig.X_200508.toString())) {
            ((WsdlInterfaceConfig)this.getConfig()).setWsaVersion(WsaVersionTypeConfig.X_200508);
        } else if (wsAddressing.equals(WsaVersionTypeConfig.X_200408.toString())) {
            ((WsdlInterfaceConfig)this.getConfig()).setWsaVersion(WsaVersionTypeConfig.X_200408);
        } else {
            ((WsdlInterfaceConfig)this.getConfig()).setWsaVersion(WsaVersionTypeConfig.NONE);
        }
    }

    public void setAnonymous(String anonymous) {
        if (anonymous.equals(AnonymousTypeConfig.REQUIRED.toString())) {
            ((WsdlInterfaceConfig)this.getConfig()).setAnonymous(AnonymousTypeConfig.REQUIRED);
        } else if (anonymous.equals(AnonymousTypeConfig.PROHIBITED.toString())) {
            ((WsdlInterfaceConfig)this.getConfig()).setAnonymous(AnonymousTypeConfig.PROHIBITED);
        } else {
            ((WsdlInterfaceConfig)this.getConfig()).setAnonymous(AnonymousTypeConfig.OPTIONAL);
        }
    }

    public String getAnonymous() {
        if (((WsdlInterfaceConfig)this.getConfig()).isSetAnonymous()) {
            if (((Object)((Object)((WsdlInterfaceConfig)this.getConfig()).getAnonymous())).equals((Object)AnonymousTypeConfig.PROHIBITED)) {
                return AnonymousTypeConfig.PROHIBITED.toString();
            }
            if (((Object)((Object)((WsdlInterfaceConfig)this.getConfig()).getAnonymous())).equals((Object)AnonymousTypeConfig.REQUIRED)) {
                return AnonymousTypeConfig.REQUIRED.toString();
            }
        }
        return AnonymousTypeConfig.OPTIONAL.toString();
    }

    @Override
    public WsdlContext getDefinitionContext() {
        return this.getWsdlContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replace(WsdlOperation wsdlOperation, OperationConfig reloadedOperation) {
        int index = this.operations.indexOf(wsdlOperation);
        int c = this.operations.indexOf(wsdlOperation);
        if (c < 0) {
            throw new IllegalArgumentException(wsdlOperation.getName() + " not found");
        }
        log.info("deleting operation [" + wsdlOperation.getName() + "]");
        while (wsdlOperation.getRequestCount() > 0) {
            wsdlOperation.removeRequest(wsdlOperation.getRequestAt(0));
        }
        this.operations.remove(c);
        try {
            this.fireOperationRemoved(wsdlOperation);
        }
        finally {
            wsdlOperation.release();
            ((WsdlInterfaceConfig)this.getConfig()).removeOperation(c);
        }
        OperationConfig newConfig = (OperationConfig)((WsdlInterfaceConfig)this.getConfig()).addNewOperation().set(reloadedOperation).changeType(OperationConfig.type);
        WsdlOperation newOperation = new WsdlOperation(this, newConfig);
        this.operations.add(index, newOperation);
        newOperation.afterLoad();
        this.fireOperationAdded(newOperation);
    }

    public void processPolicy(Policy policy) throws Exception {
        if (!this.policyFlag) {
            this.interfaceAnonymous = AnonymousTypeConfig.OPTIONAL.toString();
            this.interfaceWsaVersion = WsaVersionTypeConfig.NONE.toString();
        }
        this.policyFlag = true;
        if (policy != null) {
            List<AddressingDocument.Addressing> addressingList = policy.getAddressingList();
            List<UsingAddressingDocument.UsingAddressing> usingAddressingList = policy.getUsingAddressingList();
            for (AddressingDocument.Addressing addressing : addressingList) {
                Policy innerPolicy;
                this.policyFlag = true;
                String optional = addressing.getOptional().toString();
                if (StringUtils.isNullOrEmpty(optional) || optional.equals("false") || optional.equals("true") && SoapUI.getSettings().getBoolean(WsaSettings.ENABLE_FOR_OPTIONAL)) {
                    this.interfaceWsaVersion = WsaVersionTypeConfig.X_200508.toString();
                }
                if ((innerPolicy = addressing.getPolicy()) == null) continue;
                List<AnonymousResponsesDocument.AnonymousResponses> anonymousList = innerPolicy.getAnonymousResponsesList();
                List<NonAnonymousResponsesDocument.NonAnonymousResponses> nonAnonymousList = innerPolicy.getNonAnonymousResponsesList();
                if (anonymousList.size() > 0 && nonAnonymousList.size() > 0) {
                    throw new Exception("Wrong addressing policy, anonymousResponses and nonAnonymousResponses can not be specified together");
                }
                if (anonymousList.size() > 0) {
                    this.interfaceAnonymous = AnonymousTypeConfig.REQUIRED.toString();
                    continue;
                }
                if (nonAnonymousList.size() <= 0) continue;
                this.interfaceAnonymous = AnonymousTypeConfig.PROHIBITED.toString();
            }
            if (this.interfaceWsaVersion == WsaVersionTypeConfig.NONE.toString() && !usingAddressingList.isEmpty()) {
                this.interfaceWsaVersion = WsaVersionTypeConfig.X_200508.toString();
            }
        }
        this.setAnonymous(this.interfaceAnonymous);
        if (((Object)((Object)((WsdlInterfaceConfig)this.getConfig()).getWsaVersion())).equals((Object)WsaVersionTypeConfig.NONE)) {
            this.setWsaVersion(this.interfaceWsaVersion);
        }
    }

    public static class BindingTuple {
        public WsdlContext context = null;
        public Service service = null;
        public Port port = null;
        public Binding binding = null;
    }
}

