/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.ModelItemConfig;
import com.eviware.soapui.impl.settings.XmlBeansSettingsImpl;
import com.eviware.soapui.impl.wsdl.support.ExternalDependency;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.Releasable;
import com.eviware.soapui.model.support.AbstractModelItem;
import com.eviware.soapui.model.support.AnimatableItem;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.resolver.ResolveContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.swing.ImageIcon;

public abstract class AbstractWsdlModelItem<T extends ModelItemConfig>
extends AbstractModelItem
implements Releasable,
AnimatableItem {
    private XmlBeansSettingsImpl settings;
    private T config;
    private ImageIcon icon;
    private final ModelItem parent;

    protected AbstractWsdlModelItem(T config, ModelItem parent, String icon) {
        this.parent = parent;
        if (config != null) {
            this.setConfig(config);
            this.ensureIdIsSet();
        }
        if (icon != null) {
            this.icon = UISupport.createImageIcon(icon);
        }
    }

    public boolean dependsOn(ModelItem modelItem) {
        return ModelSupport.dependsOn(this, modelItem);
    }

    @Override
    public ModelItem getParent() {
        return this.parent;
    }

    @Override
    public ImageIcon getIcon() {
        return this.icon;
    }

    @Override
    public void setIcon(ImageIcon icon) {
        if (icon == this.icon) {
            return;
        }
        ImageIcon oldIcon = this.icon;
        this.icon = icon;
        this.notifyPropertyChanged(ICON_PROPERTY, oldIcon, icon);
    }

    @Override
    public String getDescription() {
        String description = this.config.getDescription();
        return StringUtils.hasContent(description) ? description : "";
    }

    public void setDescription(String description) {
        String old = this.getDescription();
        if (String.valueOf(old).equals(description)) {
            return;
        }
        this.config.setDescription(description);
        this.notifyPropertyChanged(DESCRIPTION_PROPERTY, old, description);
    }

    @Override
    public String getName() {
        return this.config.getName();
    }

    public void setName(String name) {
        String old = this.getName();
        name = name.trim();
        this.config.setName(name);
        this.notifyPropertyChanged(NAME_PROPERTY, old, name);
    }

    @Override
    public XmlBeansSettingsImpl getSettings() {
        return this.settings;
    }

    public T getConfig() {
        return this.config;
    }

    public void setConfig(T config) {
        this.config = config;
        if (config != null) {
            this.ensureIdIsSet();
            if (config.isSetName()) {
                config.setName(config.getName().trim());
            }
        }
        if (this.settings != null) {
            this.settings.release();
        }
        if (!config.isSetSettings()) {
            config.addNewSettings();
        }
        this.settings = new XmlBeansSettingsImpl(this, this.parent == null ? SoapUI.getSettings() : this.parent.getSettings(), this.config.getSettings());
    }

    @Override
    public String getId() {
        return this.config.getId();
    }

    private void ensureIdIsSet() {
        if (!this.config.isSetId()) {
            this.config.setId(ModelSupport.generateModelItemID());
        }
    }

    protected void setSettings(XmlBeansSettingsImpl settings) {
        if (this.settings != null) {
            this.settings.release();
        }
        this.settings = settings;
    }

    public ModelItem getWsdlModelItemByName(Collection<? extends ModelItem> items, String name) {
        for (ModelItem modelItem : items) {
            if (modelItem.getName() == null || !modelItem.getName().equals(name)) continue;
            return modelItem;
        }
        return null;
    }

    public ModelItem getWsdlModelItemById(Collection<? extends ModelItem> items, UUID modelItemId) {
        for (ModelItem modelItem : items) {
            if (modelItem.getId() == null || !modelItem.getId().equals(modelItemId.toString())) continue;
            return modelItem;
        }
        return null;
    }

    @Override
    public void release() {
        if (this.settings != null) {
            this.settings.release();
        }
    }

    public void resolve(ResolveContext<?> context) {
        List<? extends ModelItem> children = this.getChildren();
        if (children == null) {
            return;
        }
        for (ModelItem modelItem : children) {
            if (!(modelItem instanceof AbstractWsdlModelItem)) continue;
            ((AbstractWsdlModelItem)modelItem).resolve(context);
        }
    }

    public List<ExternalDependency> getExternalDependencies() {
        ArrayList<ExternalDependency> result = new ArrayList<ExternalDependency>();
        this.addExternalDependencies(result);
        return result;
    }

    protected void addExternalDependencies(List<ExternalDependency> dependencies) {
        List<? extends ModelItem> children = this.getChildren();
        if (children == null) {
            return;
        }
        for (ModelItem modelItem : children) {
            if (!(modelItem instanceof AbstractWsdlModelItem)) continue;
            ((AbstractWsdlModelItem)modelItem).addExternalDependencies(dependencies);
        }
    }

    public void beforeSave() {
        List<? extends ModelItem> children = this.getChildren();
        if (children == null) {
            return;
        }
        for (ModelItem modelItem : children) {
            if (!(modelItem instanceof AbstractWsdlModelItem)) continue;
            ((AbstractWsdlModelItem)modelItem).beforeSave();
        }
    }

    public void afterLoad() {
        List<? extends ModelItem> children = this.getChildren();
        if (children == null) {
            return;
        }
        for (ModelItem modelItem : children) {
            if (!(modelItem instanceof AbstractWsdlModelItem)) continue;
            ((AbstractWsdlModelItem)modelItem).afterLoad();
        }
    }
}

