/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wadl.inference.schema.types;

import com.eviware.soapui.impl.wadl.inference.ConflictHandler;
import com.eviware.soapui.impl.wadl.inference.schema.Content;
import com.eviware.soapui.impl.wadl.inference.schema.Context;
import com.eviware.soapui.impl.wadl.inference.schema.Particle;
import com.eviware.soapui.impl.wadl.inference.schema.Schema;
import com.eviware.soapui.impl.wadl.inference.schema.Type;
import com.eviware.soapui.impl.wadl.inference.schema.content.EmptyContent;
import com.eviware.soapui.inferredSchema.ComplexTypeConfig;
import com.eviware.soapui.inferredSchema.ParticleConfig;
import com.eviware.soapui.inferredSchema.TypeReferenceConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class ComplexType
implements Type {
    private String name;
    private Schema schema;
    private Map<QName, Particle> attributes;
    private Content content;
    private boolean mixed = false;
    private boolean completed = false;

    public ComplexType(Schema schema, String name, boolean completed) {
        this.schema = schema;
        this.name = name;
        this.completed = completed;
        this.content = new EmptyContent(schema, completed);
        this.attributes = new HashMap<QName, Particle>();
        schema.addType(this);
    }

    public ComplexType(ComplexTypeConfig xml, Schema schema) {
        this.schema = schema;
        this.name = xml.getName();
        this.completed = xml.getCompleted();
        this.mixed = xml.getMixed();
        this.content = Content.Factory.parse(xml.getContent(), schema);
        this.attributes = new HashMap<QName, Particle>();
        for (ParticleConfig item : xml.getAttributeList()) {
            Particle p = Particle.Factory.parse(item, schema);
            this.attributes.put(new QName("", p.getName().getLocalPart()), p);
        }
        schema.addType(this);
    }

    public void save(ComplexTypeConfig xml) {
        xml.setName(this.name);
        xml.setCompleted(this.completed);
        xml.setMixed(this.mixed);
        ArrayList<ParticleConfig> particleList = new ArrayList<ParticleConfig>();
        for (Particle item : this.attributes.values()) {
            particleList.add(item.save());
        }
        xml.setAttributeArray(particleList.toArray(new ParticleConfig[0]));
        xml.setContent(this.content.save());
    }

    @Override
    public TypeReferenceConfig save() {
        TypeReferenceConfig xml = TypeReferenceConfig.Factory.newInstance();
        xml.setReference(new QName(this.schema.getNamespace(), this.name));
        return xml;
    }

    public void setContent(Content content) {
        this.content = content;
    }

    @Override
    public Type validate(Context context) throws XmlException {
        XmlCursor cursor = context.getCursor();
        ArrayList<QName> seen = new ArrayList<QName>();
        cursor.push();
        if (!this.mixed && this.isMixed(context)) {
            this.mixed = true;
        }
        cursor.pop();
        cursor.push();
        if (cursor.toFirstAttribute()) {
            do {
                QName qname;
                if (this.attributes.containsKey(qname = cursor.getName())) {
                    this.attributes.get(qname).validate(context);
                } else if (!qname.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema-instance")) {
                    if (context.getHandler().callback(ConflictHandler.Event.CREATION, ConflictHandler.Type.ATTRIBUTE, new QName(this.schema.getNamespace(), qname.getLocalPart()), context.getPath(), "Undeclared attribute.")) {
                        if (qname.getNamespaceURI().equals(this.schema.getNamespace()) || qname.getNamespaceURI().equals("")) {
                            this.newAttribute(qname).validate(context);
                        } else {
                            Particle ref;
                            Schema otherSchema = context.getSchemaSystem().getSchemaForNamespace(qname.getNamespaceURI());
                            this.schema.putPrefixForNamespace(qname.getPrefix(), qname.getNamespaceURI());
                            if (otherSchema == null) {
                                otherSchema = context.getSchemaSystem().newSchema(qname.getNamespaceURI());
                            }
                            if ((ref = otherSchema.getParticle(qname.getLocalPart())) == null) {
                                ref = otherSchema.newAttribute(qname.getLocalPart());
                            }
                            if (this.completed) {
                                ref.setAttribute("use", "optional");
                            }
                            Particle newAttribute = Particle.Factory.newReferenceInstance(this.schema, ref);
                            this.attributes.put(qname, newAttribute);
                            newAttribute.validate(context);
                        }
                    } else {
                        throw new XmlException("Illegal attribute!");
                    }
                }
                seen.add(qname);
            } while (cursor.toNextAttribute());
        }
        for (QName item : this.attributes.keySet()) {
            if (seen.contains(item) || this.attributes.get(item).getAttribute("use").equals("optional")) continue;
            if (context.getHandler().callback(ConflictHandler.Event.MODIFICATION, ConflictHandler.Type.ATTRIBUTE, item, context.getPath(), "Required attribute missing.")) {
                this.attributes.get(item).setAttribute("use", "optional");
                continue;
            }
            throw new XmlException("Required attribute missing!");
        }
        cursor.pop();
        if (!cursor.toFirstChild()) {
            cursor.toFirstContentToken();
        }
        if (!context.getAttribute("nil").equals("true")) {
            this.validateContent(context);
        }
        this.completed = true;
        return this;
    }

    private void validateContent(Context context) throws XmlException {
        context.getCursor().push();
        context.putAttribute("typeName", this.name);
        Content newContent = this.content.validate(context);
        context.clearAttribute("typeName");
        if (this.content != newContent) {
            String problem = "Illegal content for complexType '" + this.name + "'.";
            if (context.getHandler().callback(ConflictHandler.Event.MODIFICATION, ConflictHandler.Type.TYPE, new QName(this.schema.getNamespace(), this.name), context.getPath(), "Illegal complex content.")) {
                this.content = newContent;
                context.getCursor().pop();
                this.validateContent(context);
                return;
            }
            throw new XmlException(problem);
        }
        context.getCursor().pop();
    }

    private boolean isMixed(Context context) {
        QName name = context.getCursor().getName();
        try {
            SchemaTypeSystem sts = XmlBeans.compileXsd((XmlObject[])new XmlObject[]{XmlObject.Factory.parse((String)("<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns=\"" + name.getNamespaceURI() + "\" targetNamespace=\"" + name.getNamespaceURI() + "\"><xs:element name=\"" + name.getLocalPart() + "\"><xs:complexType><xs:sequence><xs:any processContents=\"skip\" minOccurs=\"0\" maxOccurs=\"unbounded\" /></xs:sequence><xs:anyAttribute processContents=\"skip\"/></xs:complexType></xs:element></xs:schema>"))}, (SchemaTypeLoader)XmlBeans.getBuiltinTypeSystem(), null);
            SchemaTypeLoader stl = XmlBeans.typeLoaderUnion((SchemaTypeLoader[])new SchemaTypeLoader[]{sts, XmlBeans.getBuiltinTypeSystem()});
            if (!stl.parse(context.getCursor().xmlText(), null, null).validate()) {
                return true;
            }
        }
        catch (XmlException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    @Override
    public String toString() {
        String xsdns = this.schema.getPrefixForNamespace("http://www.w3.org/2001/XMLSchema");
        StringBuilder s = new StringBuilder("<" + xsdns + ":complexType name=\"" + this.name + "\"");
        if (this.mixed) {
            s.append(" mixed=\"true\"");
        }
        s.append(">");
        StringBuilder attrs = new StringBuilder();
        for (Particle item : this.attributes.values()) {
            attrs.append(item);
        }
        s.append(this.content.toString(attrs.toString()));
        s.append("</" + xsdns + ":complexType>");
        return s.toString();
    }

    private Particle newAttribute(QName qname) {
        Particle p = Particle.Factory.newAttributeInstance(this.schema, qname.getLocalPart());
        this.attributes.put(qname, p);
        if (this.completed) {
            p.setAttribute("use", "optional");
        }
        return p;
    }
}

