/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.support.definition.export;

import com.eviware.soapui.impl.rest.RestService;
import com.eviware.soapui.impl.support.definition.InterfaceDefinition;
import com.eviware.soapui.impl.support.definition.InterfaceDefinitionPart;
import com.eviware.soapui.impl.support.definition.export.DefinitionExporter;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xmlbeans.SimpleValue;
import org.apache.xmlbeans.XmlObject;

public abstract class AbstractDefinitionExporter<T extends Interface>
implements DefinitionExporter {
    private InterfaceDefinition<T> definition;

    public AbstractDefinitionExporter(InterfaceDefinition<T> definition) {
        this.definition = definition;
    }

    public InterfaceDefinition<T> getDefinition() {
        return this.definition;
    }

    public void setDefinition(InterfaceDefinition<T> definition) {
        this.definition = definition;
    }

    @Override
    public String export(String folderName) throws Exception {
        if (this.definition.getDefinitionCache() == null || !this.definition.getDefinitionCache().validate()) {
            throw new Exception("Definition is not cached for export");
        }
        File outFolder = new File(folderName);
        if (!outFolder.exists() && !outFolder.mkdirs()) {
            throw new Exception("Failed to create directory [" + folderName + "]");
        }
        HashMap<String, String> urlToFileMap = new HashMap<String, String>();
        this.setFilenameForPart(this.definition.getDefinitionCache().getRootPart(), urlToFileMap, null);
        List<InterfaceDefinitionPart> partList = this.definition.getDefinitionCache().getDefinitionParts();
        for (InterfaceDefinitionPart part : partList) {
            this.setFilenameForPart(part, urlToFileMap, null);
        }
        for (InterfaceDefinitionPart part : partList) {
            XmlObject obj = XmlUtils.createXmlObject(part.getContent());
            this.replaceImportsAndIncludes(obj, urlToFileMap, part.getUrl());
            this.postProcessing(obj, part);
            obj.save(new File(outFolder, (String)urlToFileMap.get(part.getUrl())));
        }
        return folderName + File.separatorChar + (String)urlToFileMap.get(this.definition.getDefinitionCache().getRootPart().getUrl());
    }

    @Override
    public StringToStringMap createFilesForExport(String urlPrefix) throws Exception {
        StringToStringMap result = new StringToStringMap();
        HashMap<String, String> urlToFileMap = new HashMap<String, String>();
        if (urlPrefix == null) {
            urlPrefix = "";
        }
        this.setFilenameForPart(this.definition.getDefinitionCache().getRootPart(), urlToFileMap, urlPrefix);
        List<InterfaceDefinitionPart> partList = this.definition.getDefinitionCache().getDefinitionParts();
        for (InterfaceDefinitionPart part : partList) {
            if (part.isRootPart()) continue;
            this.setFilenameForPart(part, urlToFileMap, urlPrefix);
        }
        for (InterfaceDefinitionPart part : partList) {
            XmlObject obj = XmlUtils.createXmlObject(part.getContent());
            this.replaceImportsAndIncludes(obj, urlToFileMap, part.getUrl());
            String urlString = (String)urlToFileMap.get(part.getUrl());
            if (urlString.startsWith(urlPrefix)) {
                urlString = urlString.substring(urlPrefix.length());
            }
            result.put(urlString, obj.xmlText());
            if (!part.isRootPart()) continue;
            result.put("#root#", urlString);
        }
        return result;
    }

    protected void postProcessing(XmlObject obj, InterfaceDefinitionPart part) {
    }

    private void setFilenameForPart(InterfaceDefinitionPart part, Map<String, String> urlToFileMap, String urlPrefix) throws MalformedURLException {
        String type;
        Object fileName;
        String path = part.getUrl();
        try {
            URL url = new URL(path);
            path = url.getPath();
        }
        catch (MalformedURLException url) {
            // empty catch block
        }
        int ix = path.lastIndexOf(47);
        if (ix == -1) {
            ix = path.lastIndexOf(92);
        }
        if ((ix = ((String)(fileName = ix == -1 ? path : path.substring(ix + 1))).lastIndexOf(46)) != -1) {
            fileName = ((String)fileName).substring(0, ix);
        }
        fileName = (type = part.getType()).equals("http://schemas.xmlsoap.org/wsdl/") ? (String)fileName + ".wsdl" : (part.getType().equals("http://www.w3.org/2001/XMLSchema") ? (String)fileName + ".xsd" : (this.getDefinition().getInterface() instanceof RestService && part.getType().equals(((RestService)this.getDefinition().getInterface()).getWadlVersion()) ? (String)fileName + ".wadl" : (String)fileName + ".xml"));
        if (urlPrefix != null) {
            fileName = urlPrefix + (String)fileName;
        }
        int cnt = 1;
        while (urlToFileMap.containsValue(fileName)) {
            ix = ((String)fileName).lastIndexOf(46);
            int iy = ((String)fileName).lastIndexOf("_");
            if (iy == -1) {
                iy = ix;
            }
            fileName = ((String)fileName).substring(0, iy) + "_" + cnt + ((String)fileName).substring(ix);
            ++cnt;
        }
        urlToFileMap.put(part.getUrl(), (String)fileName);
    }

    private void replaceImportsAndIncludes(XmlObject xmlObject, Map<String, String> urlToFileMap, String baseUrl) throws Exception {
        String[] paths;
        for (String path : paths = this.getLocationXPathsToReplace()) {
            XmlObject[] locations;
            for (XmlObject location : locations = xmlObject.selectPath(path)) {
                SimpleValue wsdlImport = (SimpleValue)location;
                this.replaceLocation(urlToFileMap, baseUrl, wsdlImport);
            }
        }
    }

    protected abstract String[] getLocationXPathsToReplace();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void replaceLocation(Map<String, String> urlToFileMap, String baseUrl, SimpleValue wsdlImport) throws Exception {
        String location = wsdlImport.getStringValue();
        if (location == null) return;
        if (location.startsWith("file:") || location.indexOf("://") > 0) {
            String newLocation = urlToFileMap.get(location);
            if (newLocation == null) throw new Exception("Missing local file for [" + newLocation + "]");
            wsdlImport.setStringValue(newLocation);
            return;
        } else {
            String loc = Tools.joinRelativeUrl(baseUrl, location);
            String newLocation = urlToFileMap.get(loc);
            if (newLocation == null) {
                newLocation = urlToFileMap.get(loc.replaceAll("/", "\\\\"));
            }
            if (newLocation == null) {
                newLocation = urlToFileMap.get(loc.replaceAll("\\\\", "/"));
            }
            if (newLocation == null) throw new Exception("Missing local file for [" + loc + "]");
            wsdlImport.setStringValue(newLocation);
        }
    }
}

