/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.support.components;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.submit.transports.http.DocumentContent;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlContext;
import com.eviware.soapui.support.editor.EditorDocument;
import com.eviware.soapui.support.editor.xml.support.AbstractXmlDocument;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.annotation.Nonnull;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;

public class RequestXmlDocument
extends AbstractXmlDocument
implements PropertyChangeListener {
    private final WsdlRequest request;
    private boolean updating;

    public RequestXmlDocument(WsdlRequest request) {
        this.request = request;
        request.addPropertyChangeListener("request", this);
    }

    @Override
    public void setDocumentContent(DocumentContent documentContent) {
        if (!this.updating) {
            this.updating = true;
            this.request.setRequestContent(documentContent.getContentAsString());
            this.fireContentChanged();
            this.updating = false;
        }
    }

    @Override
    public String getContentType() {
        return "application/soap+xml";
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.updating) {
            this.updating = true;
            this.fireContentChanged();
            this.updating = false;
        }
    }

    @Override
    public SchemaTypeSystem getTypeSystem() {
        WsdlInterface iface = this.request.getOperation().getInterface();
        WsdlContext wsdlContext = iface.getWsdlContext();
        try {
            return wsdlContext.getSchemaTypeSystem();
        }
        catch (Exception e1) {
            SoapUI.logError(e1);
            return XmlBeans.getBuiltinTypeSystem();
        }
    }

    @Override
    public void release() {
        this.request.removePropertyChangeListener("request", this);
    }

    @Override
    @Nonnull
    public DocumentContent getDocumentContent(EditorDocument.Format format) {
        return new DocumentContent(null, this.request.getRequestContent());
    }
}

