/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.support;

import com.eviware.soapui.support.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import org.apache.commons.httpclient.URIException;
import org.apache.http.client.utils.URIUtils;

public class HttpUtils {
    private static String pingErrorMessage;

    public static boolean isErrorStatus(int statusCode) {
        return statusCode >= 400;
    }

    public static String extractHttpHeaderParameter(String headerString, String parameterName) {
        int ix2;
        if (!StringUtils.hasContent(headerString) || !StringUtils.hasContent(parameterName)) {
            return null;
        }
        int ix = headerString.indexOf(parameterName + "=\"");
        if (ix > 0 && (ix2 = headerString.indexOf(34, ix + parameterName.length() + 2)) > ix) {
            return headerString.substring(ix + parameterName.length() + 2, ix2);
        }
        return null;
    }

    public static String completeUrlWithHttpIfProtocolIsNotHttpOrHttpsOrPropertyExpansion(String endpoint) {
        if (StringUtils.isNullOrEmpty(endpoint)) {
            return endpoint;
        }
        String lowerCaseEndpoint = (endpoint = endpoint.trim()).toLowerCase();
        if (!(lowerCaseEndpoint.startsWith("http://") || lowerCaseEndpoint.startsWith("https://") || endpoint.startsWith("$"))) {
            return "http://" + endpoint;
        }
        return endpoint;
    }

    public static String completeUrlWithHttpIfProtocolIsMissing(String endpoint) {
        if (StringUtils.isNullOrEmpty(endpoint)) {
            return endpoint;
        }
        if (!(endpoint = endpoint.trim()).contains("://")) {
            return "http://" + endpoint;
        }
        return endpoint;
    }

    public static boolean ping(String host, int timeout) {
        pingErrorMessage = "No Error";
        try {
            InetAddress address = InetAddress.getByName(host);
            return address.isReachable(timeout);
        }
        catch (Exception e) {
            pingErrorMessage = e.getMessage();
            return false;
        }
    }

    public static String urlEncodeWithUtf8(String input) {
        try {
            return URLEncoder.encode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Unexpected error: charset UTF-8 not available", e);
        }
    }

    public static String getPingErrorMessage() {
        return pingErrorMessage;
    }

    public static URI createUri(org.apache.commons.httpclient.URI uri) throws URISyntaxException, URIException {
        return HttpUtils.createUri(uri.getScheme(), uri.getUserinfo(), uri.getHost(), uri.getPort(), uri.getEscapedPath(), uri.getEscapedQuery(), uri.getEscapedFragment());
    }

    public static URI createUri(String scheme, String userinfo, String host, int port, String escapedPath, String escapedQuery, String escapedFragment) throws URISyntaxException {
        return URIUtils.createURI((String)scheme, (String)((String)(userinfo == null ? "" : userinfo + "@") + host), (int)port, (String)escapedPath, (String)escapedQuery, (String)escapedFragment);
    }
}

