/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.settings;

import com.eviware.soapui.config.SettingConfig;
import com.eviware.soapui.config.SettingsConfig;
import com.eviware.soapui.impl.settings.WeakSettingsListener;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.settings.SettingsListener;
import com.eviware.soapui.support.types.StringToStringMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class XmlBeansSettingsImpl
implements Settings {
    private final Settings parent;
    private final SettingsConfig config;
    private final Map<String, SettingConfig> values = Collections.synchronizedMap(new HashMap());
    private final Map<String, String> valueCache = Collections.synchronizedMap(new StringToStringMap());
    private final Set<SettingsListener> listeners = new HashSet<SettingsListener>();
    private final ModelItem item;
    private final SettingsListener settingsListener = new WeakSettingsListener(new InternalSettingsListener());

    public XmlBeansSettingsImpl(ModelItem item, Settings parent, SettingsConfig config) {
        this.item = item;
        this.config = config;
        this.parent = parent;
        List<SettingConfig> settingList = config.getSettingList();
        for (SettingConfig setting : settingList) {
            this.values.put(setting.getId(), setting);
        }
        if (parent != null) {
            parent.addSettingsListener(this.settingsListener);
        }
    }

    @Override
    public boolean isSet(String id) {
        return this.values.containsKey(id);
    }

    @Override
    public String getString(String id, String defaultValue) {
        String cachedValue = this.valueCache.get(id);
        if (cachedValue != null) {
            return cachedValue;
        }
        SettingConfig setting = this.values.get(id);
        if (setting != null) {
            String value = setting.getStringValue();
            this.valueCache.put(id, value);
            return value;
        }
        return this.parent == null ? defaultValue : this.parent.getString(id, defaultValue);
    }

    @Override
    public void setString(String id, String value) {
        String oldValue = this.getString(id, null);
        if (oldValue == null && value == null) {
            return;
        }
        if (value != null && value.equals(oldValue)) {
            return;
        }
        if (value == null) {
            this.clearSetting(id);
        } else {
            if (!this.values.containsKey(id)) {
                SettingConfig setting = this.config.addNewSetting();
                setting.setId(id);
                this.values.put(id, setting);
            }
            this.values.get(id).setStringValue(value);
            this.valueCache.put(id, value);
        }
        this.notifySettingChanged(id, value, oldValue);
    }

    private void notifySettingChanged(String id, String value, String oldValue) {
        SettingsListener[] l;
        for (SettingsListener listener : l = this.listeners.toArray(new SettingsListener[this.listeners.size()])) {
            listener.settingChanged(id, value, oldValue);
        }
    }

    @Override
    public void reloadSettings() {
        this.notifySettingsReloaded();
    }

    private void notifySettingsReloaded() {
        SettingsListener[] l;
        for (SettingsListener listener : l = this.listeners.toArray(new SettingsListener[this.listeners.size()])) {
            listener.settingsReloaded();
        }
    }

    @Override
    public boolean getBoolean(String id) {
        return this.getBoolean(id, false);
    }

    @Override
    public boolean getBoolean(String id, boolean defaultValue) {
        String value = this.getString(id, null);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return this.parent == null ? defaultValue : this.parent.getBoolean(id);
    }

    @Override
    public long getLong(String id, long defaultValue) {
        String value = this.getString(id, null);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.parent == null ? defaultValue : this.parent.getLong(id, defaultValue);
    }

    @Override
    public void setBoolean(String id, boolean value) {
        if (!value) {
            this.setString(id, "false");
        } else {
            this.setString(id, "true");
        }
    }

    @Override
    public void addSettingsListener(SettingsListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeSettingsListener(SettingsListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void clearSetting(String id) {
        if (this.values.containsKey(id)) {
            int ix = this.config.getSettingList().indexOf(this.values.get(id));
            this.config.removeSetting(ix);
            this.values.remove(id);
            this.valueCache.remove(id);
        }
    }

    public ModelItem getModelItem() {
        return this.item;
    }

    public void release() {
        if (this.listeners != null) {
            this.listeners.clear();
        }
        if (this.parent != null) {
            this.parent.removeSettingsListener(this.settingsListener);
        }
    }

    @Override
    public void setLong(String id, long value) {
        this.setString(id, Long.toString(value));
    }

    public void setConfig(SettingsConfig soapuiSettings) {
        StringToStringMap changed = new StringToStringMap();
        for (SettingConfig config : soapuiSettings.getSettingList()) {
            if (config.getStringValue().equals(this.getString(config.getId(), null))) continue;
            changed.put(config.getId(), this.getString(config.getId(), null));
        }
        this.values.clear();
        this.config.set(soapuiSettings);
        List<SettingConfig> settingList = this.config.getSettingList();
        for (SettingConfig settingConfig : settingList) {
            this.values.put(settingConfig.getId(), settingConfig);
        }
        for (Map.Entry entry : changed.entrySet()) {
            this.notifySettingChanged((String)entry.getKey(), this.getString((String)entry.getKey(), null), (String)entry.getValue());
        }
        this.notifySettingsReloaded();
    }

    private final class InternalSettingsListener
    implements SettingsListener {
        private InternalSettingsListener() {
        }

        @Override
        public void settingChanged(String name, String newValue, String oldValue) {
            if (!XmlBeansSettingsImpl.this.values.containsKey(name)) {
                XmlBeansSettingsImpl.this.notifySettingChanged(name, newValue, oldValue);
            }
        }

        @Override
        public void settingsReloaded() {
            XmlBeansSettingsImpl.this.notifySettingsReloaded();
        }
    }
}

