/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.panels.request.views.json.actions;

import com.eviware.soapui.support.JsonUtil;
import com.eviware.soapui.support.UISupport;
import com.fasterxml.jackson.databind.JsonNode;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class FormatJsonAction
extends AbstractAction {
    private static final String TITLE = "Format JSON";
    private static final String TOOLTIP = "Pretty-prints JSON";
    private static final Logger log = LogManager.getLogger(FormatJsonAction.class);
    private final RSyntaxTextArea textArea;

    public FormatJsonAction(String title, RSyntaxTextArea textArea) {
        super(title);
        this.textArea = textArea;
        this.putValue("SmallIcon", UISupport.createImageIcon("/format_request.gif"));
        this.putValue("ShortDescription", TOOLTIP);
        if (UISupport.isMac()) {
            String keyStroke = "shift meta F";
            this.putValue("AcceleratorKey", UISupport.getKeyStroke(keyStroke));
            textArea.getInputMap().put(KeyStroke.getKeyStroke(keyStroke), this);
        } else {
            String keyStroke = "alt F";
            this.putValue("AcceleratorKey", UISupport.getKeyStroke(keyStroke));
            textArea.getInputMap().put(KeyStroke.getKeyStroke(keyStroke), this);
        }
    }

    public FormatJsonAction(RSyntaxTextArea textArea) {
        this(TITLE, textArea);
    }

    protected boolean isValidJson(String jsonText) {
        return JsonUtil.isValidJson(jsonText);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            Rectangle visibleRect = this.textArea.getVisibleRect();
            String message = this.textArea.getText();
            if (!this.isValidJson(message)) {
                return;
            }
            JsonNode json = JsonUtil.parseTrimmedTextToJsonNode(message);
            this.textArea.setText(JsonUtil.format(json));
            this.textArea.setCaretPosition(0);
            SwingUtilities.invokeLater(() -> this.textArea.scrollRectToVisible(visibleRect));
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }
}

