/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.panels.request.views.json;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.rest.panels.request.views.json.actions.FormatJsonAction;
import com.eviware.soapui.impl.support.AbstractHttpRequestInterface;
import com.eviware.soapui.impl.support.http.HttpRequestInterface;
import com.eviware.soapui.impl.support.panels.AbstractHttpXmlRequestDesktopPanel;
import com.eviware.soapui.impl.wsdl.submit.transports.http.HttpResponse;
import com.eviware.soapui.support.JsonUtil;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.actions.FindAndReplaceDialog;
import com.eviware.soapui.support.actions.FindAndReplaceable;
import com.eviware.soapui.support.editor.views.AbstractXmlEditorView;
import com.eviware.soapui.support.xml.SyntaxEditorUtil;
import com.eviware.soapui.support.xml.actions.EnableLineNumbersAction;
import com.eviware.soapui.support.xml.actions.GoToLineAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import net.sf.json.JSON;
import net.sf.json.JSONException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class JsonResponseView
extends AbstractXmlEditorView<AbstractHttpXmlRequestDesktopPanel.HttpResponseDocument>
implements PropertyChangeListener {
    private final HttpRequestInterface<?> httpRequest;
    private FindAndReplaceableTextArea contentEditor;
    private RTextScrollPane editorScrollPane;
    private boolean updatingRequest;
    private JPanel panel;
    private FormatJsonAction formatJsonAction;
    private EnableLineNumbersAction enableLineNumbersAction;
    private GoToLineAction goToLineAction;
    private FindAndReplaceDialog findAndReplaceDialog;
    private SaveJsonTextAreaAction saveJsonAction;

    public JsonResponseView(AbstractHttpXmlRequestDesktopPanel.HttpResponseMessageEditor httpRequestMessageEditor, HttpRequestInterface<?> httpRequest) {
        super("JSON", httpRequestMessageEditor, "JSON Response");
        this.httpRequest = httpRequest;
        httpRequest.addPropertyChangeListener(this);
    }

    @Override
    public JComponent getComponent() {
        if (this.panel == null) {
            this.panel = new JPanel(new BorderLayout());
            this.panel.add((Component)UISupport.createToolbar(), "North");
            this.panel.add(this.buildContent(), "Center");
            this.panel.add(this.buildStatus(), "South");
        }
        return this.panel;
    }

    @Override
    public void release() {
        super.release();
        this.httpRequest.removePropertyChangeListener(this);
    }

    private Component buildStatus() {
        return new JPanel();
    }

    private Component buildContent() {
        JPanel contentPanel = new JPanel(new BorderLayout());
        this.contentEditor = new FindAndReplaceableTextArea();
        this.contentEditor.setSyntaxEditingStyle("text/javascript");
        SyntaxEditorUtil.decorateSyntaxArea(this.contentEditor);
        this.editorScrollPane = new RTextScrollPane((RTextArea)this.contentEditor);
        this.buildPopup(this.contentEditor.getPopupMenu(), this.contentEditor);
        HttpResponse response = this.httpRequest.getResponse();
        if (response != null) {
            this.setEditorContent(response);
        }
        this.editorScrollPane.setFoldIndicatorEnabled(true);
        this.editorScrollPane.setLineNumbersEnabled(true);
        contentPanel.add((Component)this.editorScrollPane);
        this.contentEditor.setEditable(false);
        return contentPanel;
    }

    private void buildPopup(JPopupMenu inputPopup, FindAndReplaceableTextArea editArea) {
        this.formatJsonAction = new FormatJsonAction(editArea);
        this.findAndReplaceDialog = new FindAndReplaceDialog(editArea);
        this.enableLineNumbersAction = new EnableLineNumbersAction(this.editorScrollPane, "Toggle Line Numbers");
        this.goToLineAction = new GoToLineAction(editArea, "Go To Line");
        this.saveJsonAction = new SaveJsonTextAreaAction(editArea, "Save");
        inputPopup.add(this.saveJsonAction);
        inputPopup.addSeparator();
        inputPopup.add(this.findAndReplaceDialog);
        inputPopup.addSeparator();
        inputPopup.add(this.goToLineAction);
        inputPopup.add(this.enableLineNumbersAction);
        inputPopup.addSeparator();
        inputPopup.add(this.formatJsonAction);
    }

    protected void setEditorContent(HttpResponse httpResponse) {
        if (httpResponse == null || httpResponse.getContentAsString() == null) {
            this.contentEditor.setText("");
        } else if (JsonUtil.seemsToBeJsonContentType(httpResponse.getContentType())) {
            String content;
            try {
                JSON json = new JsonUtil().parseTrimmedText(httpResponse.getContentAsString());
                content = json.isEmpty() ? "<Empty JSON content>" : json.toString(3);
            }
            catch (JSONException e) {
                content = httpResponse.getContentAsString();
            }
            this.contentEditor.setText(content);
        } else {
            this.contentEditor.setText("The content you are trying to view cannot be viewed as JSON");
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(AbstractHttpRequestInterface.RESPONSE_PROPERTY) && !this.updatingRequest) {
            this.updatingRequest = true;
            this.setEditorContent((HttpResponse)evt.getNewValue());
            this.updatingRequest = false;
        }
    }

    @Override
    public boolean saveDocument(boolean validate) {
        return false;
    }

    @Override
    public void setEditable(boolean enabled) {
    }

    @Override
    public int getSupportScoreForContentType(String contentType) {
        return JsonUtil.seemsToBeJsonContentType(contentType) ? 2 : 0;
    }

    private static class FindAndReplaceableTextArea
    extends RSyntaxTextArea
    implements FindAndReplaceable {
        private FindAndReplaceableTextArea() {
        }

        @Override
        public void setSelectedText(String txt) {
            this.replaceSelection(txt);
        }

        @Override
        public JComponent getEditComponent() {
            return this;
        }
    }

    private final class SaveJsonTextAreaAction
    extends AbstractAction {
        private final RSyntaxTextArea textArea;
        private String dialogTitle;
        private final Logger log;

        public SaveJsonTextAreaAction(RSyntaxTextArea editArea, String dialogTitle) {
            super("Save as...");
            this.log = LogManager.getLogger(SaveJsonTextAreaAction.class);
            this.textArea = editArea;
            this.dialogTitle = dialogTitle;
            if (UISupport.isMac()) {
                this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu S"));
            } else {
                this.putValue("AcceleratorKey", UISupport.getKeyStroke("ctrl S"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent event) {
            File file = UISupport.getFileDialogs().saveAs(this, this.dialogTitle, ".json", "JSON Files (*.json)", null);
            if (file == null) {
                return;
            }
            FileWriter writer = null;
            try {
                writer = new FileWriter(file);
                writer.write(this.textArea.getText());
                writer.close();
                this.log.info("JSON written to [" + file.getAbsolutePath() + "]");
            }
            catch (IOException e1) {
                UISupport.showErrorMessage("Error saving json to file: " + e1.getMessage());
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        SoapUI.logError(e);
                    }
                }
            }
        }
    }
}

