/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.panels.request.inspectors.schema;

import com.eviware.soapui.impl.rest.RestRequest;
import com.eviware.soapui.impl.rest.RestService;
import com.eviware.soapui.impl.rest.panels.request.inspectors.schema.InferredSchemaManager;
import com.eviware.soapui.impl.settings.XmlBeansSettingsImpl;
import com.eviware.soapui.impl.wadl.inference.ConflictHandler;
import com.eviware.soapui.impl.wsdl.submit.transports.http.HttpResponse;
import com.eviware.soapui.impl.wsdl.submit.transports.jms.JMSResponse;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.iface.SubmitListener;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.editor.EditorView;
import com.eviware.soapui.support.editor.inspectors.AbstractXmlInspector;
import com.eviware.soapui.support.editor.xml.XmlDocument;
import com.eviware.soapui.support.log.JLogList;
import com.eviware.soapui.support.xml.SyntaxEditorUtil;
import com.eviware.soapui.support.xml.XmlUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class InferredSchemaInspector
extends AbstractXmlInspector
implements SubmitListener {
    private SchemaTabs tabs;
    private RestService service;
    private RestRequest request;
    private Handler handler;
    private Thread thread;

    protected InferredSchemaInspector(RestRequest request) {
        super("Schema", "Inferred Schema", true, "InferredSchema");
        this.service = request.getResource().getService();
        this.request = request;
        request.addSubmitListener(this);
    }

    @Override
    public JComponent getComponent() {
        if (this.tabs == null) {
            this.tabs = new SchemaTabs();
            InferredSchemaManager.addPropertyChangeListener(this.service, this.tabs);
        }
        return this.tabs;
    }

    @Override
    public boolean isEnabledFor(EditorView<XmlDocument> view) {
        return !view.getViewId().equals("Raw");
    }

    @Override
    public void afterSubmit(Submit submit, SubmitContext context) {
        XmlObject xml;
        if (submit.getResponse() == null) {
            return;
        }
        HttpResponse httpResponse = (HttpResponse)submit.getResponse();
        String content = httpResponse.getContentAsXml();
        if (content == null || content.equals("<xml/>")) {
            return;
        }
        try {
            URL url = httpResponse.getURL();
            Object defaultNamespace = null;
            if (url != null) {
                defaultNamespace = url.getProtocol() + "://" + url.getHost();
            } else if (httpResponse instanceof JMSResponse) {
                defaultNamespace = ((JMSResponse)httpResponse).getEndpoint();
            }
            XmlOptions options = new XmlOptions().setLoadSubstituteNamespaces(Collections.singletonMap("", defaultNamespace));
            xml = XmlUtils.createXmlObject(content, options);
        }
        catch (XmlException e) {
            e.printStackTrace();
            return;
        }
        if (!submit.getStatus().equals((Object)Submit.Status.CANCELED) && !InferredSchemaManager.getInferredSchema(this.service).validate(xml)) {
            this.setTitle("Schema (conflicts)");
            if (this.thread != null && this.thread.isAlive()) {
                this.handler.kill();
                try {
                    this.thread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.handler = new Handler(this.tabs, xml);
            this.thread = new Thread(this.handler);
            this.thread.start();
        }
    }

    @Override
    public boolean beforeSubmit(Submit submit, SubmitContext context) {
        return true;
    }

    @Override
    public void release() {
        super.release();
        this.request.removeSubmitListener(this);
        InferredSchemaManager.removePropertyChangeListener(this.service, this.tabs);
        if (this.thread != null && this.thread.isAlive()) {
            this.handler.kill();
        }
    }

    public RestRequest getRequest() {
        return this.request;
    }

    private class SchemaTabs
    extends JTabbedPane
    implements ActionListener,
    PropertyChangeListener,
    ListSelectionListener {
        private JLogList log;
        private JPanel conflicts = new JPanel();
        private JButton resolveButton;
        private JCheckBox auto;
        private Handler handler;
        private RSyntaxTextArea xsd;
        private JList schemaList;
        public static final String AUTO_INFER_SCHEMAS = "AutoInferSchemas";
        public static final String NO_NAMESPACE = "<no namespace>";

        public SchemaTabs() {
            this.conflicts.setLayout(new BorderLayout());
            this.auto = new JCheckBox("Auto-Resolve");
            this.auto.setToolTipText("Automatically modify inferred schema from received Responses");
            this.auto.setOpaque(false);
            UISupport.setFixedSize(this.auto, 120, 20);
            XmlBeansSettingsImpl settings = InferredSchemaInspector.this.getRequest().getSettings();
            if (settings.isSet(AUTO_INFER_SCHEMAS)) {
                this.auto.setSelected(settings.getBoolean(AUTO_INFER_SCHEMAS));
            }
            this.auto.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    InferredSchemaInspector.this.getRequest().getSettings().setBoolean(SchemaTabs.AUTO_INFER_SCHEMAS, SchemaTabs.this.auto.isSelected());
                }
            });
            this.resolveButton = new JButton("Resolve conflicts");
            this.resolveButton.setEnabled(false);
            this.resolveButton.setActionCommand("resolve");
            this.resolveButton.addActionListener(this);
            JXToolBar toolbar = UISupport.createToolbar();
            toolbar.addFixed(this.auto);
            toolbar.addFixed(this.resolveButton);
            this.log = new JLogList("Schema log");
            this.conflicts.add((Component)toolbar, "North");
            this.conflicts.add((Component)this.log, "Center");
            this.addTab("Conflicts", this.conflicts);
            this.schemaList = new JList<String>(InferredSchemaManager.getInferredSchema(InferredSchemaInspector.this.service).getNamespaces());
            this.schemaList.setSelectionMode(0);
            this.schemaList.addListSelectionListener(this);
            toolbar = UISupport.createToolbar();
            toolbar.addFixed(UISupport.createToolbarButton(new RemoveNamespaceAction()));
            JPanel listPanel = new JPanel();
            listPanel.setLayout(new BorderLayout());
            listPanel.add((Component)toolbar, "North");
            listPanel.add((Component)new JScrollPane(this.schemaList), "Center");
            this.xsd = SyntaxEditorUtil.createDefaultXmlSyntaxTextArea();
            this.xsd.setEditable(false);
            this.update();
            this.addTab("Schemas", new JSplitPane(1, listPanel, new JScrollPane((Component)this.xsd)));
        }

        public synchronized boolean awaitButton(Handler handler) {
            if (this.auto.isSelected()) {
                return false;
            }
            this.resolveButton.setEnabled(true);
            this.handler = handler;
            return true;
        }

        @Override
        public synchronized void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("resolve")) {
                this.resolveButton.setEnabled(false);
                this.handler.go();
            } else if (e.getActionCommand().equals("save")) {
                InferredSchemaManager.save(InferredSchemaInspector.this.service);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.update();
        }

        public void update() {
            String[] namespaces = InferredSchemaManager.getInferredSchema(InferredSchemaInspector.this.service).getNamespaces();
            for (int i = 0; i < namespaces.length; ++i) {
                if (!namespaces[i].equals("")) continue;
                namespaces[i] = NO_NAMESPACE;
            }
            this.schemaList.setListData(namespaces);
            if (this.schemaList.isSelectionEmpty()) {
                this.xsd.setText("");
            } else {
                this.xsd.setText(XmlUtils.prettyPrintXml(InferredSchemaManager.getInferredSchema(InferredSchemaInspector.this.service).getXsdForNamespace((String)this.schemaList.getSelectedValue())));
                this.xsd.setCaretPosition(0);
                this.xsd.scrollRectToVisible(new Rectangle(0, 0, (int)this.getSize().getWidth(), (int)this.getSize().getHeight()));
            }
        }

        public void logln(String line) {
            this.log.addLine(line);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting() && !this.schemaList.isSelectionEmpty()) {
                String namespace = (String)this.schemaList.getSelectedValue();
                if (namespace.equals(NO_NAMESPACE)) {
                    namespace = "";
                }
                this.xsd.setText(XmlUtils.prettyPrintXml(InferredSchemaManager.getInferredSchema(InferredSchemaInspector.this.service).getXsdForNamespace(namespace)));
                this.xsd.setCaretPosition(0);
                this.xsd.scrollRectToVisible(new Rectangle(0, 0, (int)this.getSize().getWidth(), (int)this.getSize().getHeight()));
            }
        }

        private class RemoveNamespaceAction
        extends AbstractAction {
            private RemoveNamespaceAction() {
                this.putValue("SmallIcon", UISupport.createImageIcon("/delete.png"));
                this.putValue("ShortDescription", "Removes selected inferred namespace definition");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String ns;
                if (!SchemaTabs.this.schemaList.isSelectionEmpty() && UISupport.confirm("Remove inferred namespace '" + (ns = (String)SchemaTabs.this.schemaList.getSelectedValue()) + "'?", "Remove namespace")) {
                    if (ns.equals(SchemaTabs.NO_NAMESPACE)) {
                        ns = "";
                    }
                    InferredSchemaManager.deleteNamespace(InferredSchemaInspector.this.service, ns);
                }
            }
        }
    }

    public class Handler
    implements ConflictHandler,
    Runnable {
        private SchemaTabs panel;
        private XmlObject xml;
        private List<String> paths;
        private boolean yesToAll = false;
        private boolean kill = false;

        public Handler(SchemaTabs panel, XmlObject xml) {
            this.panel = panel;
            this.xml = xml;
            this.paths = new ArrayList<String>();
        }

        @Override
        public synchronized void run() {
            try {
                if (this.panel.awaitButton(this)) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                } else {
                    this.yesToAll = true;
                }
                if (this.kill) {
                    return;
                }
                InferredSchemaManager.getInferredSchema(InferredSchemaInspector.this.service).learningValidate(this.xml, this);
                this.panel.update();
                InferredSchemaInspector.this.setTitle("Schema");
                InferredSchemaManager.save(InferredSchemaInspector.this.service);
            }
            catch (XmlException e) {
                InferredSchemaInspector.this.setTitle("Schema (invalid)");
            }
        }

        public synchronized void go() {
            this.notifyAll();
        }

        public synchronized void kill() {
            this.kill = true;
            this.notifyAll();
        }

        @Override
        public boolean callback(ConflictHandler.Event event, ConflictHandler.Type type, QName name, String path, String message) {
            StringBuilder s = new StringBuilder(message).append(" ");
            if (event == ConflictHandler.Event.CREATION) {
                this.paths.add(path);
                s.append("Create ");
            } else if (event == ConflictHandler.Event.MODIFICATION) {
                this.paths.add(path);
                s.append("Modify ");
            }
            if (type == ConflictHandler.Type.ELEMENT) {
                s.append("element '");
            } else if (type == ConflictHandler.Type.ATTRIBUTE) {
                s.append("attribute '");
            } else if (type == ConflictHandler.Type.TYPE) {
                s.append("type '");
            }
            s.append(name.getLocalPart()).append("' in namespace '").append(name.getNamespaceURI()).append("' at path ").append(path).append("?");
            if (!this.yesToAll) {
                int choice = UISupport.yesYesToAllOrNo(s.toString(), "Conflict");
                if (choice == 2) {
                    this.panel.logln(s.append(" FAIL").toString());
                    return false;
                }
                if (choice == 1) {
                    this.yesToAll = true;
                }
            }
            this.panel.logln(s.append(" OK").toString());
            return true;
        }
    }
}

