/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.panels.request.inspectors.representations;

import com.eviware.soapui.impl.rest.RestRepresentation;
import com.eviware.soapui.impl.rest.RestRequest;
import com.eviware.soapui.impl.rest.panels.request.inspectors.representations.AbstractRestRepresentationsInspector;
import com.eviware.soapui.impl.settings.XmlBeansSettingsImpl;
import com.eviware.soapui.impl.wsdl.submit.transports.http.HttpResponse;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.iface.SubmitListener;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.xml.XmlUtils;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import org.apache.xmlbeans.XmlCursor;

public class RestRequestRepresentationsInspector
extends AbstractRestRepresentationsInspector
implements SubmitListener {
    private JCheckBox enableRecordingCheckBox;
    public static final String RECORD_REQUEST_REPRESENTATIONS = "RecordRequestRepresentations";
    private RestRequest request;

    protected RestRequestRepresentationsInspector(RestRequest request) {
        super(request.getRestMethod(), "Representations", "Request Representations", new RestRepresentation.Type[]{RestRepresentation.Type.REQUEST});
        request.addSubmitListener(this);
        this.request = request;
    }

    @Override
    protected void addToToolbar(JXToolBar toolbar) {
        this.enableRecordingCheckBox = new JCheckBox("Auto-Create");
        this.enableRecordingCheckBox.setToolTipText("Automatically create Representations from sent Requests");
        this.enableRecordingCheckBox.setOpaque(false);
        UISupport.setFixedSize(this.enableRecordingCheckBox, 100, 20);
        toolbar.addFixed(this.enableRecordingCheckBox);
        XmlBeansSettingsImpl settings = this.request.getSettings();
        if (settings.isSet(RECORD_REQUEST_REPRESENTATIONS)) {
            this.enableRecordingCheckBox.setSelected(settings.getBoolean(RECORD_REQUEST_REPRESENTATIONS));
        } else {
            this.enableRecordingCheckBox.setSelected(this.getMethod().getResource() == null || this.getMethod().getResource().getService().isGenerated());
        }
        this.enableRecordingCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RestRequestRepresentationsInspector.this.request.getSettings().setBoolean(RestRequestRepresentationsInspector.RECORD_REQUEST_REPRESENTATIONS, RestRequestRepresentationsInspector.this.enableRecordingCheckBox.isSelected());
            }
        });
    }

    @Override
    public boolean beforeSubmit(Submit submit, SubmitContext context) {
        return true;
    }

    @Override
    public void afterSubmit(Submit submit, SubmitContext context) {
        HttpResponse response = (HttpResponse)submit.getResponse();
        if (response != null && this.enableRecordingCheckBox.isSelected()) {
            this.extractRepresentation(response);
        }
    }

    protected void extractRepresentation(HttpResponse response) {
        String repMediaType;
        int c;
        String responseContentType = response.getRequestHeaders().get("Content-Type", "");
        if (StringUtils.isNullOrEmpty(responseContentType)) {
            return;
        }
        responseContentType = responseContentType.split(";")[0].trim();
        RestRepresentation[] representations = this.getMethod().getRepresentations(RestRepresentation.Type.REQUEST, null);
        for (c = 0; c < representations.length && !responseContentType.equals(repMediaType = representations[c].getMediaType()); ++c) {
        }
        if (c == representations.length) {
            RestRepresentation representation = this.getMethod().addNewRepresentation(RestRepresentation.Type.REQUEST);
            representation.setMediaType(responseContentType);
            String xmlContent = response.getRequestContent();
            if (!xmlContent.equals("<xml/>")) {
                try {
                    XmlCursor cursor = XmlUtils.createXmlObject(xmlContent).newCursor();
                    cursor.toFirstChild();
                    representation.setElement(cursor.getName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void release() {
        super.release();
        this.request.removeSubmitListener(this);
    }
}

