/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.actions.service;

import com.eviware.soapui.impl.rest.RestService;
import com.eviware.soapui.impl.support.definition.export.WadlDefinitionExporter;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import java.io.File;

public class ExportWadlAction
extends AbstractSoapUIAction<RestService> {
    public static final String SOAPUI_ACTION_ID = "ExportWadlAction";

    public ExportWadlAction() {
        super("Export WADL", "Exports the entire WADL and included/imported files to a local directory");
    }

    @Override
    public void perform(RestService iface, Object param) {
        try {
            String path = this.exportDefinition(null, iface);
            if (path != null) {
                UISupport.showInfoMessage("WADL exported succesfully to [" + path + "]", "Export WADL");
            }
        }
        catch (Exception e1) {
            UISupport.showErrorMessage(e1);
        }
    }

    public String exportDefinition(String location, RestService iface) throws Exception {
        File folderName;
        if (!iface.isGenerated()) {
            boolean exportChanges = UISupport.confirm("Do you want the exported WADL to contain recent changes?", "WADL export option");
            iface.setExportChanges(exportChanges);
        }
        File file = folderName = location == null ? UISupport.getFileDialogs().openDirectory(this, "Select output directory", null) : new File(location);
        if (folderName == null) {
            return null;
        }
        WadlDefinitionExporter exporter = new WadlDefinitionExporter(iface);
        return exporter.export(folderName.getAbsolutePath());
    }
}

