/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.actions.oauth;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.rest.actions.oauth.BrowserListener;
import com.eviware.soapui.impl.rest.actions.oauth.UserBrowserFacade;
import com.eviware.soapui.support.components.WebViewBasedBrowserComponent;
import com.eviware.soapui.support.components.WebViewBasedBrowserComponentFactory;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class WebViewUserBrowserFacade
implements UserBrowserFacade {
    private WebViewBasedBrowserComponent browserComponent;
    private JFrame popupWindow;

    public WebViewUserBrowserFacade() {
        this(false);
    }

    public WebViewUserBrowserFacade(boolean addNavigationBar) {
        this.browserComponent = WebViewBasedBrowserComponentFactory.createBrowserComponent(addNavigationBar);
    }

    @Override
    public void open(URL url) {
        this.popupWindow = new JFrame("Browser");
        this.popupWindow.setIconImages(SoapUI.getFrameIcons());
        this.popupWindow.getContentPane().add(this.browserComponent.getComponent());
        this.popupWindow.setBounds(100, 100, 800, 600);
        this.popupWindow.setVisible(true);
        this.popupWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                WebViewUserBrowserFacade.this.browserComponent.close(true);
            }
        });
        this.browserComponent.navigate(url.toString());
    }

    @Override
    public void addBrowserListener(BrowserListener listener) {
        this.browserComponent.addBrowserStateListener(listener);
    }

    @Override
    public void removeBrowserStateListener(BrowserListener listener) {
        this.browserComponent.removeBrowserStateListener(listener);
    }

    @Override
    public void close() {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WebViewUserBrowserFacade.this.popupWindow.setVisible(false);
                    WebViewUserBrowserFacade.this.popupWindow.dispose();
                }
            });
            this.browserComponent.close(true);
        }
        catch (Exception e) {
            SoapUI.log.debug("Could not close window due to unexpected error: " + e.getMessage() + "!");
        }
    }

    @Override
    public void executeJavaScript(String script) {
        this.browserComponent.executeJavaScript(script);
    }
}

