/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.actions.oauth;

import com.eviware.soapui.support.StringUtils;
import org.apache.oltu.oauth2.client.response.OAuthAccessTokenResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.token.BasicOAuthToken;
import org.apache.oltu.oauth2.common.token.OAuthToken;
import org.apache.oltu.oauth2.common.utils.JSONUtils;
import org.apache.oltu.oauth2.common.utils.OAuthUtils;
import org.codehaus.jettison.json.JSONException;

public class OAuth2AccessTokenResponse
extends OAuthAccessTokenResponse {
    private static final String EXPIRES = "expires";

    public String getAccessToken() {
        return this.getParam("access_token");
    }

    public Long getExpiresIn() {
        String value = this.getParam("expires_in") == null ? this.getParam(EXPIRES) : this.getParam("expires_in");
        return value == null ? null : Long.valueOf(value);
    }

    public String getScope() {
        return this.getParam("scope");
    }

    public OAuthToken getOAuthToken() {
        return new BasicOAuthToken(this.getAccessToken(), this.getExpiresIn(), this.getRefreshToken(), this.getScope());
    }

    public String getRefreshToken() {
        return this.getParam("refresh_token");
    }

    protected void setBody(String body) throws OAuthProblemException {
        block3: {
            try {
                this.body = body;
                this.parameters = JSONUtils.parseJSON((String)body);
            }
            catch (JSONException e) {
                if (body.startsWith("#")) {
                    body = body.substring(1);
                }
                this.parameters = OAuthUtils.decodeForm((String)body);
                if (!StringUtils.isNullOrEmpty(this.getAccessToken())) break block3;
                throw OAuthProblemException.error((String)"unsupported_response_type", (String)"Invalid response! Response body is not application/json encoded or form-url-encoded");
            }
        }
    }

    protected void setContentType(String contentType) {
        this.contentType = contentType;
    }

    protected void setResponseCode(int code) {
        this.responseCode = code;
    }
}

