/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.actions.explorer;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.rest.actions.explorer.callback.EndpointExplorerCallback;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.PagePropertyMapper;
import com.eviware.soapui.support.components.WebViewBasedBrowserComponent;
import com.eviware.soapui.support.components.WebViewBasedBrowserComponentFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.KeyStroke;

public class EndpointExplorerAction
extends AbstractAction {
    private JDialog dialog;

    public EndpointExplorerAction() {
        this.putValue("Name", "Endpoint Explorer");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        WebViewBasedBrowserComponent browser = WebViewBasedBrowserComponentFactory.createBrowserComponent(false, WebViewBasedBrowserComponent.PopupStrategy.EXTERNAL_BROWSER);
        Component browserComponent = browser.getComponent();
        this.dialog = new JDialog(UISupport.getMainFrame(), "Endpoint Explorer", false);
        this.dialog.getContentPane().add(browserComponent);
        this.dialog.setSize(860, 435);
        this.dialog.setMinimumSize(new Dimension(860, 435));
        this.dialog.setLocationRelativeTo(null);
        this.dialog.setResizable(true);
        this.dialog.setVisible(true);
        this.dialog.setIconImage(UISupport.createImageIcon("/SoapUI-OS_16-16.png").getImage());
        this.dialog.getRootPane().registerKeyboardAction(event -> this.close(), KeyStroke.getKeyStroke(27, 0), 2);
        UISupport.centerDialog(this.dialog, UISupport.getMainFrame());
        UISupport.getMainFrame().setEnabled(false);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                UISupport.getMainFrame().setEnabled(true);
                EndpointExplorerAction.this.dialog.setVisible(false);
            }
        });
        String path = "/com/eviware/soapui/explorer/soapui-pro-api-endpoint-explorer-starter-page.html";
        String resource = this.getClass().getResource(path).toString();
        browser.navigate(resource);
        PagePropertyMapper pagePropertyMapper = browser.getPagePropertyMapper();
        if (pagePropertyMapper != null) {
            pagePropertyMapper.update("dontShow", !SoapUI.getSettings().getBoolean(UISettings.SHOW_ENDPOINT_EXPLORER_ON_START, true));
        }
        browser.addJavaScriptEventHandler("closeCallback", this);
        browser.addJavaScriptEventHandler("inspectorCallback", new EndpointExplorerCallback(browser));
    }

    public void close() {
        UISupport.getMainFrame().setEnabled(true);
        this.dialog.setVisible(false);
    }
}

