/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest;

import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.rest.RestResource;
import com.eviware.soapui.impl.rest.mock.RestMockResponse;
import com.eviware.soapui.impl.wsdl.submit.AbstractRestMessageExchange;
import com.eviware.soapui.impl.wsdl.submit.transports.http.HttpResponse;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.mock.MockRequest;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.model.mock.MockResult;
import com.eviware.soapui.support.types.StringToStringsMap;
import com.eviware.soapui.support.xml.XmlUtils;

public class RestMockResultMessageExchange
extends AbstractRestMessageExchange<MockResponse> {
    private final MockResult mockResult;
    private final MockResponse mockResponse;
    private final MockRequest mockRequest;

    public RestMockResultMessageExchange(MockResult mockResult) {
        super(mockResult.getMockResponse());
        this.mockResult = mockResult;
        this.mockResponse = (RestMockResponse)mockResult.getMockResponse();
        this.mockRequest = mockResult.getMockRequest();
    }

    @Override
    public String getEndpoint() {
        return this.mockRequest.getHttpRequest().getRequestURI();
    }

    @Override
    public String getRequestContent() {
        return this.mockRequest.getRequestContent();
    }

    @Override
    public StringToStringsMap getRequestHeaders() {
        return this.mockRequest.getRequestHeaders();
    }

    @Override
    public Attachment[] getRequestAttachments() {
        return ((MockResponse)this.getModelItem()).getAttachments();
    }

    @Override
    public Attachment[] getResponseAttachments() {
        return this.mockResponse.getAttachments();
    }

    @Override
    public String getResponseContent() {
        return this.mockResult.getResponseContent();
    }

    @Override
    public HttpResponse getResponse() {
        return null;
    }

    @Override
    public StringToStringsMap getResponseHeaders() {
        return this.mockResult == null ? new StringToStringsMap() : this.mockResult.getResponseHeaders();
    }

    @Override
    public long getTimeTaken() {
        return this.mockResult == null ? -1L : this.mockResult.getTimeTaken();
    }

    @Override
    public long getTimestamp() {
        return this.mockResult == null ? -1L : this.mockResult.getTimestamp();
    }

    @Override
    public boolean isDiscarded() {
        return this.discardResponse;
    }

    @Override
    public RestResource getResource() {
        return null;
    }

    @Override
    public RestRequestInterface getRestRequest() {
        return null;
    }

    @Override
    public Operation getOperation() {
        if (this.mockResponse != null && this.mockResponse instanceof RestMockResponse) {
            RestMockResponse restMockResponse = (RestMockResponse)this.mockResponse;
            if (this.mockResult.getMockOperation() != null) {
                return this.mockResult.getMockOperation().getOperation();
            }
            return restMockResponse.getMockOperation().getOperation();
        }
        return null;
    }

    @Override
    public int getResponseStatusCode() {
        return this.mockResponse.getResponseHttpStatus();
    }

    @Override
    public String getResponseContentType() {
        return this.mockResponse.getContentType();
    }

    @Override
    public byte[] getRawRequestData() {
        if (this.getRequestContent() == null) {
            return null;
        }
        return this.mockRequest.getRawRequestData();
    }

    @Override
    public boolean hasRawData() {
        return this.mockResponse == null;
    }

    @Override
    public byte[] getRawResponseData() {
        return this.mockResult.getRawResponseData();
    }

    @Override
    public String getRequestContentAsXml() {
        String result = this.getRequestContent();
        return XmlUtils.seemsToBeXml(result) ? result : "<not-xml/>";
    }
}

