/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.actions;

import com.eviware.soapui.analytics.Analytics;
import com.eviware.soapui.analytics.SoapUIActions;
import com.eviware.soapui.analytics.UniqueUserIdentifier;
import com.eviware.soapui.support.DefaultHyperlinkListener;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JFriendlyTextField;
import com.smartbear.analytics.OSUserDescription;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class SumbitUserInfoAction {
    private static final String FIRST_NAME_HINT = "Enter your first name";
    private static final String LAST_NAME_HINT = "Enter your last name";
    private static final String EMAIL_HINT = "Enter e-mail";
    private static final String DIALOG_CAPTION = "Stay Tuned!";
    private static final String DIALOG_MAIN_TEXT = "Want to stay in the loop?";
    private static final String DIALOG_DESCRIPTION = "Your privacy matters. This information will be used to provide you with best practices gained from our community of tens of millions of software experts, just like you. By submitting this form, you agree to our";
    private static final String TERMS_OF_USE = "Terms of Use";
    private static final String PRIVACY_POLICY = "Privacy Policy";
    private static final String OK_BTN_CAPTION = "Yes, I want to know";
    private static final String SKIP_BTN_CAPTION = "Skip";
    private static final String TERMS_OF_USE_URL = "https://smartbear.com/terms-of-use/";
    private static final String PRIVACY_POLICY_URL = "https://smartbear.com/privacy/";

    public void show() {
        CollectUserInfoDialog cui = new CollectUserInfoDialog();
        cui.setVisible(true);
    }

    private class CollectUserInfoDialog
    extends JDialog {
        private JLabel title;
        private JEditorPane description;
        private JFriendlyTextField textFieldFirstName;
        private JFriendlyTextField textFieldLastName;
        private JFriendlyTextField textFieldEmail;
        private static final String VALID_EMAIL_PATTERN = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
        private Pattern validEmailRegex;

        private void setBackgroundColor(JComponent curLabel) {
            curLabel.setOpaque(true);
            curLabel.setBackground(Color.WHITE);
        }

        public CollectUserInfoDialog() {
            super(UISupport.getMainFrame(), SumbitUserInfoAction.DIALOG_CAPTION, true);
            this.setDefaultCloseOperation(0);
            this.setResizable(false);
            this.setUndecorated(true);
            this.setModal(true);
            this.setBackground(Color.WHITE);
            JPanel jBasePanel = new JPanel(new BorderLayout(5, 5));
            jBasePanel.setBorder(new LineBorder(new Color(170, 170, 170), 2));
            this.setBackgroundColor(jBasePanel);
            this.add(jBasePanel);
            JPanel jBaseUserPanel = new JPanel(new BorderLayout(5, 5));
            this.setBackgroundColor(jBaseUserPanel);
            JLabel jCaption = new JLabel("  Stay Tuned!");
            jCaption.setOpaque(true);
            jCaption.setPreferredSize(new Dimension(300, 25));
            jCaption.setBackground(new Color(166, 192, 229));
            String dialogDescription = "Your privacy matters. This information will be used to provide you with best practices gained from our community of tens of millions of software experts, just like you. By submitting this form, you agree to our <a href=\"https://smartbear.com/terms-of-use/\" target=\"_top\">Terms of Use</a> and <a href=\"https://smartbear.com/privacy/\">Privacy Policy</a>.";
            jBaseUserPanel.add((Component)this.buildCaptionPanel(SumbitUserInfoAction.DIALOG_MAIN_TEXT, dialogDescription), "North");
            jBaseUserPanel.add(this.buildControlsPanel());
            jBasePanel.add((Component)jCaption, "North");
            jBasePanel.add(jBaseUserPanel);
            this.validEmailRegex = Pattern.compile(VALID_EMAIL_PATTERN);
            this.pack();
        }

        private JPanel buildCaptionPanel(String titleStr, String descriptionStr) {
            JPanel jRoot = new JPanel(new BorderLayout());
            jRoot.setBorder(new EmptyBorder(10, 30, 0, 25));
            this.setBackgroundColor(jRoot);
            jRoot.setPreferredSize(new Dimension(200, 100));
            this.title = new JLabel();
            this.setBackgroundColor(this.title);
            this.title.setText("<html><div style=\"font-size: 11px\"><b>" + titleStr + "</b></div></html>");
            Font font = UISupport.getEditorFont();
            String fontFamily = font.getFamily();
            this.description = new JEditorPane("text/html", "<html><div style=\"font-size: 9px\" face=\"" + fontFamily + "\">" + descriptionStr + "</div></html>");
            this.setBackgroundColor(this.description);
            this.description.setBorder(new EmptyBorder(5, 0, 0, 0));
            this.description.setEditable(false);
            this.description.addHyperlinkListener(new DefaultHyperlinkListener(this.description));
            jRoot.add((Component)this.title, "North");
            jRoot.add(this.description);
            return jRoot;
        }

        private JPanel buildControlsPanel() {
            JPanel jbase = new JPanel(new BorderLayout());
            JPanel jLeftPanel = new JPanel();
            jLeftPanel.setLayout(new BorderLayout());
            jLeftPanel.setBorder(new EmptyBorder(0, 0, 25, 0));
            JLabel arrowIcon = new JLabel(UISupport.createImageIcon("/big_arrow.png"));
            jLeftPanel.add((Component)arrowIcon, "South");
            this.setBackgroundColor(jLeftPanel);
            JPanel jControlsPanel = new JPanel(new BorderLayout());
            jControlsPanel.setBorder(new EmptyBorder(5, 2, 10, 35));
            this.setBackgroundColor(jControlsPanel);
            jControlsPanel.add((Component)this.buildButtonsPanel(), "South");
            jControlsPanel.add(this.buildUserInfoPanel());
            jbase.add((Component)jLeftPanel, "West");
            jbase.add(jControlsPanel);
            return jbase;
        }

        private JPanel buildUserInfoPanel() {
            this.textFieldFirstName = new JFriendlyTextField(SumbitUserInfoAction.FIRST_NAME_HINT);
            this.textFieldFirstName.setPreferredSize(new Dimension(300, 24));
            this.textFieldLastName = new JFriendlyTextField(SumbitUserInfoAction.LAST_NAME_HINT);
            this.textFieldLastName.setPreferredSize(new Dimension(300, 24));
            JPanel namePanel = new JPanel(new GridLayout(1, 2, 8, 8));
            this.setBackgroundColor(namePanel);
            namePanel.add(this.textFieldFirstName);
            namePanel.add(this.textFieldLastName);
            this.textFieldEmail = new JFriendlyTextField(SumbitUserInfoAction.EMAIL_HINT);
            this.textFieldEmail.setPreferredSize(new Dimension(300, 24));
            JPanel jHelpEmail = new JPanel(new BorderLayout());
            this.setBackgroundColor(jHelpEmail);
            jHelpEmail.add((Component)this.textFieldEmail, "North");
            JPanel userInfoContent = new JPanel(new BorderLayout(8, 8));
            this.setBackgroundColor(userInfoContent);
            userInfoContent.add((Component)namePanel, "North");
            userInfoContent.add((Component)jHelpEmail, "Center");
            return userInfoContent;
        }

        private JPanel buildButtonsPanel() {
            JButton jOkBtn = new JButton(SumbitUserInfoAction.OK_BTN_CAPTION);
            jOkBtn.setBorder(new LineBorder(new Color(200, 200, 200), 1));
            jOkBtn.setBackground(new Color(157, 200, 130));
            jOkBtn.setOpaque(true);
            jOkBtn.setForeground(Color.WHITE);
            jOkBtn.setPreferredSize(new Dimension(300, 24));
            jOkBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (CollectUserInfoDialog.this.handleOk()) {
                        Analytics.trackAction(SoapUIActions.STAY_TUNED_DIALOG_ACCEPTED);
                        CollectUserInfoDialog.this.setVisible(false);
                    }
                }
            });
            JPanel jOkPanel = new JPanel(new BorderLayout());
            jOkPanel.setBorder(new EmptyBorder(0, 0, 0, 10));
            this.setBackgroundColor(jOkPanel);
            jOkPanel.add(jOkBtn);
            JButton jSkip = new JButton(SumbitUserInfoAction.SKIP_BTN_CAPTION);
            jSkip.setBorder(new LineBorder(new Color(170, 170, 170), 1));
            jSkip.setForeground(new Color(170, 170, 170));
            if (UISupport.isMac()) {
                jSkip.setBackground(new Color(236, 236, 236));
            }
            jSkip.setOpaque(true);
            jSkip.setPreferredSize(new Dimension(60, 20));
            jSkip.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Analytics.trackAction(SoapUIActions.STAY_TUNED_DIALOG_SKIPPED);
                    CollectUserInfoDialog.this.setVisible(false);
                }
            });
            JPanel buttonsContent = new JPanel(new BorderLayout());
            buttonsContent.setBorder(new EmptyBorder(20, 0, 20, 0));
            this.setBackgroundColor(buttonsContent);
            buttonsContent.add((Component)jSkip, "East");
            buttonsContent.add(jOkPanel);
            return buttonsContent;
        }

        @Override
        public void setVisible(boolean b) {
            UISupport.centerDialog(this);
            super.setVisible(b);
        }

        private String getUserFirstName() {
            String name = this.textFieldFirstName.getText();
            name = name.replace(SumbitUserInfoAction.FIRST_NAME_HINT, "");
            return name;
        }

        private String getUserLastname() {
            String name = this.textFieldLastName.getText();
            name = name.replace(SumbitUserInfoAction.LAST_NAME_HINT, "");
            return name;
        }

        private String getUserEMail() {
            String email = this.textFieldEmail.getText();
            email = email.replace(SumbitUserInfoAction.EMAIL_HINT, "");
            return email;
        }

        protected boolean handleOk() {
            if (!this.validateFormValues()) {
                return false;
            }
            UniqueUserIdentifier userIdentifier = UniqueUserIdentifier.getInstance();
            OSUserDescription osUserDescription = new OSUserDescription(this.getUserFirstName(), this.getUserLastname(), this.getUserEMail(), userIdentifier.getUserId());
            Analytics.trackUserInfo(osUserDescription);
            return true;
        }

        private boolean validateFormValues() {
            ArrayList<String> fieldErrors = new ArrayList<String>();
            if (StringUtils.isNullOrEmpty(this.getUserFirstName())) {
                fieldErrors.add("your first name");
            }
            if (StringUtils.isNullOrEmpty(this.getUserLastname())) {
                fieldErrors.add("your last name");
            }
            if (!this.isValidEmailAddress(this.getUserEMail())) {
                fieldErrors.add("a valid email address");
            }
            if (fieldErrors.isEmpty()) {
                return true;
            }
            StringBuilder buf = new StringBuilder("You must enter ");
            int numberOfErrors = fieldErrors.size();
            for (int i = 0; i < numberOfErrors; ++i) {
                if (i > 0) {
                    buf.append(i < numberOfErrors - 1 ? ", " : " and ");
                }
                buf.append((String)fieldErrors.get(i));
            }
            buf.append(".");
            UISupport.showErrorMessage(buf.toString());
            return false;
        }

        private boolean isValidEmailAddress(String email) {
            return StringUtils.hasContent(email) && this.validEmailRegex.matcher(email).matches();
        }
    }
}

