/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.actions;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.actions.SoapUIPreferencesAction;
import com.eviware.soapui.analytics.Analytics;
import com.eviware.soapui.analytics.SoapUIActions;
import com.eviware.soapui.impl.wsdl.submit.transports.jms.util.HermesUtils;
import com.eviware.soapui.settings.ToolsSettings;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Map;
import javax.swing.AbstractAction;

public class StartHermesJMSButtonAction
extends AbstractAction {
    public StartHermesJMSButtonAction() {
        this.putValue("SmallIcon", UISupport.createImageIcon("/hermes-16x16.gif"));
        this.putValue("ShortDescription", "Start HermesJMS application");
        this.putValue("Name", "HermesJMS");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            String hermesHome = SoapUI.getSettings().getString(ToolsSettings.HERMES_JMS, HermesUtils.defaultHermesJMSPath());
            if (!this.isHermesHomeValid(hermesHome)) {
                UISupport.showErrorMessage("Please set Hermes JMS path in Preferences->Tools ! ");
                if (UISupport.getMainFrame() != null && SoapUIPreferencesAction.getInstance().show("Tools")) {
                    hermesHome = SoapUI.getSettings().getString(ToolsSettings.HERMES_JMS, HermesUtils.defaultHermesJMSPath());
                }
            }
            if (!this.isHermesHomeValid(hermesHome)) {
                return;
            }
            String extension = UISupport.isWindows() ? ".bat" : ".sh";
            String hermesBatPath = hermesHome + File.separator + "bin" + File.separator + "hermes" + extension;
            ProcessBuilder pb = new ProcessBuilder(hermesBatPath);
            Map<String, String> env = pb.environment();
            env.put("JAVA_HOME", System.getProperty("java.home"));
            pb.start();
            Analytics.trackAction(SoapUIActions.USE_HERMES_JMS_TOOL);
        }
        catch (Throwable t) {
            SoapUI.logError(t);
        }
    }

    private boolean isHermesHomeValid(String hermesHome) {
        File file = new File(hermesHome + File.separator + "bin" + File.separator + "hermes.bat");
        return file.exists();
    }
}

