/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.analytics.impl;

import com.mixpanel.mixpanelapi.ClientDelivery;
import com.mixpanel.mixpanelapi.MessageBuilder;
import com.mixpanel.mixpanelapi.MixpanelAPI;
import com.smartbear.analytics.ActionDescription;
import com.smartbear.analytics.AnalyticsManager;
import com.smartbear.analytics.AnalyticsUtils;
import com.smartbear.analytics.api.AnalyticsProviderFactory;
import com.smartbear.analytics.api.ProductInfo;
import com.smartbear.analytics.api.UserIdentificationInformation;
import com.smartbear.analytics.impl.BaseAnalyticsProvider;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;

public class SoapUIOSMixpanelProvider
extends BaseAnalyticsProvider {
    private static final Logger LOG = LogManager.getLogger(SoapUIOSMixpanelProvider.class);
    private MixpanelAPI mixpanelAPI = new MixpanelAPI();
    private MessageBuilder messageBuilder;
    private ProductInfo productInfo;
    private UserIdentificationInformation userIdentifier;
    private long sessionStartTime;
    private AnalyticsProviderFactory.HandleType handleType;

    public SoapUIOSMixpanelProvider(String projectToken, ProductInfo productInfo, UserIdentificationInformation userIdentifier, AnalyticsProviderFactory.HandleType handleType) {
        super(productInfo);
        this.messageBuilder = new MessageBuilder(projectToken);
        this.productInfo = productInfo;
        this.userIdentifier = userIdentifier;
        this.handleType = handleType;
    }

    @Override
    public void trackAction(ActionDescription actionDescription) {
        if (actionDescription.getCategory().equals((Object)AnalyticsManager.Category.MIXPANEL_PROFILE)) {
            this.updateProfile(actionDescription);
        } else {
            this.sendEventData(actionDescription);
        }
    }

    @Override
    public void trackError(Throwable error) {
        throw new UnsupportedOperationException();
    }

    private void updateProfile(ActionDescription actionDescription) {
        if (this.handleType != AnalyticsProviderFactory.HandleType.MANDATORY) {
            return;
        }
        try {
            JSONObject props = new JSONObject(actionDescription.getParams());
            JSONObject updateUser = this.messageBuilder.set(this.userIdentifier.getUserId(), props);
            this.mixpanelAPI.sendMessage(updateUser);
        }
        catch (IOException e) {
            LOG.debug("Error when updating user profile on Mixpanel");
        }
    }

    private void sendEventData(ActionDescription actionDescription) {
        JSONObject props = null;
        switch (actionDescription.getCategory()) {
            case SESSION_START: {
                if (this.handleType != AnalyticsProviderFactory.HandleType.MANDATORY) break;
                this.sessionStartTime = System.currentTimeMillis();
                props = new JSONObject(this.populateEventMapWithSessionData(actionDescription, false));
                break;
            }
            case SESSION_STOP: {
                if (this.handleType != AnalyticsProviderFactory.HandleType.MANDATORY) break;
                props = new JSONObject(this.populateEventMapWithSessionData(actionDescription, true));
                break;
            }
            case LICENSE_UPDATE: {
                if (this.handleType != AnalyticsProviderFactory.HandleType.MANDATORY) break;
                props = new JSONObject(this.populateEventMapWithActionData(actionDescription, false));
                break;
            }
            case VIRTSERVER: {
                if (this.handleType != AnalyticsProviderFactory.HandleType.USER_ALLOWED) break;
                props = new JSONObject(actionDescription.getParams());
                break;
            }
            default: {
                if (this.handleType != AnalyticsProviderFactory.HandleType.USER_ALLOWED) break;
                props = new JSONObject(this.populateEventMapWithActionData(actionDescription, true));
            }
        }
        if (props == null) {
            return;
        }
        JSONObject event = this.messageBuilder.event(this.userIdentifier.getUserId(), actionDescription.getActionName(), props);
        final ClientDelivery delivery = new ClientDelivery();
        delivery.addMessage(event);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SoapUIOSMixpanelProvider.this.mixpanelAPI.deliver(delivery);
                }
                catch (IOException e) {
                    LOG.debug("Error when sending event to Mixpanel");
                }
            }
        }).start();
    }

    private void sendActionEventData(ActionDescription actionDescription) {
    }

    private void sendLicenseEventData(ActionDescription actionDescription) {
    }

    private Map<String, Object> populateEventMapWithSessionData(ActionDescription actionDescription, boolean sessionStarted) {
        String session_str = "session_%s";
        String environment_str = "[environment] %s";
        HashMap<String, Object> event = new HashMap<String, Object>();
        this.addProductVersion(event);
        event.put(String.format("session_%s", "id"), actionDescription.getSessionId());
        if (sessionStarted) {
            event.put(String.format("session_%s", "phase"), "stop");
            event.put(String.format("session_%s", "duration"), String.valueOf((System.currentTimeMillis() - this.sessionStartTime) / 1000L));
        } else {
            event.put(String.format("session_%s", "phase"), "start");
        }
        event.put(String.format("session_%s", "start_time"), new Date(this.sessionStartTime).toString());
        event.put(String.format("[environment] %s", "os_name"), this.getOsName());
        event.put(String.format("[environment] %s", "os_version"), this.getOsVersion());
        event.put(String.format("[environment] %s", "java_version"), this.getJavaVersion());
        event.put(String.format("[environment] %s", "screensize"), this.getStrScreenSize());
        event.put(String.format("[environment] %s", "user_country"), this.getUserCountry());
        event.put(String.format("[environment] %s", "user_language"), this.getUserLanguage());
        return event;
    }

    private Map<String, Object> populateEventMapWithActionData(ActionDescription actionDescription, boolean addLicenseInfo) {
        HashMap<String, Object> event = new HashMap<String, Object>();
        event.put("action", actionDescription.getActionName());
        event.put("session_id", actionDescription.getSessionId());
        event.put("category", (Object)actionDescription.getCategory());
        event.put("screensize", AnalyticsUtils.getScreenSize());
        this.addProductVersion(event);
        Map<String, String> params = actionDescription.getParams();
        if (params != null) {
            for (String key : params.keySet()) {
                event.put(key, params.get(key));
            }
        }
        return event;
    }

    private void addProductVersion(Map<String, Object> event) {
        String license_type_str = "license [%s] type";
        String license_id_str = "license [%s] id";
        String free_license_type_str = "license";
        event.put("product_name", this.getProductInfo().getName());
        event.put("product_version", this.getProductInfo().getVersion());
        event.put("license", "OPEN_SOURCE");
    }
}

