/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.analytics;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnalyticsUtils {
    private static final Logger logger = LogManager.getLogger(AnalyticsUtils.class);
    private static String cachedValue = null;

    public static String getMacAddressString() {
        if (cachedValue == null) {
            cachedValue = AnalyticsUtils.findMacAddress();
        }
        return cachedValue;
    }

    public static String findMacAddress() {
        try {
            String firstInterface = null;
            HashMap<String, String> addressByNetwork = new HashMap<String, String>();
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface network = networkInterfaces.nextElement();
                byte[] bmac = network.getHardwareAddress();
                if (bmac == null) continue;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < bmac.length; ++i) {
                    sb.append(String.format("%02X%s", bmac[i], i < bmac.length - 1 ? "-" : ""));
                }
                if (!sb.toString().isEmpty()) {
                    addressByNetwork.put(network.getName(), sb.toString());
                }
                if (sb.toString().isEmpty() || firstInterface != null) continue;
                firstInterface = network.getName();
            }
            if (firstInterface != null) {
                return (String)addressByNetwork.get(firstInterface);
            }
            return "";
        }
        catch (Exception e) {
            logger.warn("Couldn't determine MAC address - returning empty String");
            return "";
        }
    }

    public static String getScreenSize() {
        try {
            Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
            return String.format("%dx%d", (int)size.getWidth(), (int)size.getHeight());
        }
        catch (Throwable e) {
            return "0x0";
        }
    }
}

