/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlImageInput
extends HtmlInput {
    private static final long serialVersionUID = -2955826367201282767L;
    private boolean wasPositionSpecified_;
    private int xPosition_;
    private int yPosition_;

    HtmlImageInput(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
    }

    @Override
    public NameValuePair[] getSubmitKeyValuePairs() {
        String name = this.getNameAttribute();
        String prefix = StringUtils.isEmpty((String)name) ? "" : name + ".";
        if (this.wasPositionSpecified_) {
            NameValuePair valueX = new NameValuePair(prefix + 'x', String.valueOf(this.xPosition_));
            NameValuePair valueY = new NameValuePair(prefix + 'y', String.valueOf(this.yPosition_));
            if (prefix.length() > 0 && this.getPage().getWebClient().getBrowserVersion().isFirefox()) {
                return new NameValuePair[]{valueX, valueY, new NameValuePair(this.getNameAttribute(), this.getValueAttribute())};
            }
            return new NameValuePair[]{valueX, valueY};
        }
        return new NameValuePair[]{new NameValuePair(this.getNameAttribute(), this.getValueAttribute())};
    }

    public Page click() throws IOException {
        return this.click(0, 0);
    }

    @Override
    protected void doClickAction() throws IOException {
        HtmlForm form = this.getEnclosingForm();
        if (form != null) {
            form.submit(this);
        }
    }

    @Override
    public <P extends Page> P click(int x, int y) throws IOException, ElementNotFoundException {
        this.wasPositionSpecified_ = true;
        this.xPosition_ = x;
        this.yPosition_ = y;
        return super.click();
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        super.setDefaultValue(defaultValue);
        this.setValueAttribute(defaultValue);
    }
}

