/*
 * Decompiled with CFR 0.152.
 */
package hermes.util;

import hermes.util.GetCachingMethodInterceptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.jms.ConnectionFactory;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import net.sf.cglib.beans.BeanGenerator;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.NoOp;
import org.apache.log4j.Logger;

public class ReflectUtils {
    private static final Set<String> nonCompliantPackages = new HashSet<String>();
    private static final Logger log;

    private static boolean isPublicAndNonStatic(Method m) {
        return !Modifier.isStatic(m.getModifiers()) && Modifier.isPublic(m.getModifiers());
    }

    public static boolean isGetter(Method m) {
        return m.getName().startsWith("get") && ReflectUtils.isPublicAndNonStatic(m) && m.getParameterTypes().length == 0;
    }

    public static boolean isSetter(Method m) {
        return m.getName().startsWith("set") && ReflectUtils.isPublicAndNonStatic(m) && m.getParameterTypes().length == 1 && !m.getParameterTypes()[0].isArray();
    }

    public static Class getPropertyType(Method m) {
        if (ReflectUtils.isSetter(m)) {
            return m.getParameterTypes()[0];
        }
        if (ReflectUtils.isGetter(m)) {
            return m.getReturnType();
        }
        return Void.class;
    }

    public static String getPropertyName(Method m) {
        String s = m.getName().substring(3, m.getName().length());
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    public static boolean getterExists(Class clazz, String propertyName) {
        String methodName = "get" + propertyName;
        try {
            Method method = clazz.getMethod(methodName, new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static Object mixinGetterMethodsAndInstantiate(Class clazz) throws InstantiationException, IllegalAccessException {
        Method[] methods = clazz.getMethods();
        BeanGenerator beanGenerator = new BeanGenerator();
        beanGenerator.setSuperclass(clazz);
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!ReflectUtils.isSetter(m)) continue;
            log.debug((Object)("fixing property for " + methods[i].getName() + " type= " + ReflectUtils.getPropertyType(m)));
            beanGenerator.addProperty(ReflectUtils.getPropertyName(m), ReflectUtils.getPropertyType(m));
        }
        Class newClazz = (Class)beanGenerator.createClass();
        Callback[] callbacks = new Callback[]{new GetCachingMethodInterceptor(), NoOp.INSTANCE};
        return (ConnectionFactory)Enhancer.create((Class)newClazz, (Class[])new Class[]{ConnectionFactory.class, QueueConnectionFactory.class, TopicConnectionFactory.class}, (CallbackFilter)new CallbackFilter(){

            public int accept(Method m) {
                if (ReflectUtils.isGetter(m) || ReflectUtils.isSetter(m)) {
                    return 0;
                }
                return 1;
            }
        }, (Callback[])callbacks);
    }

    public static ConnectionFactory createConnectionFactory(Class clazz) throws InstantiationException, IllegalAccessException {
        ConnectionFactory factory = (ConnectionFactory)clazz.newInstance();
        if (nonCompliantPackages.contains(clazz.getPackage().getName())) {
            log.debug((Object)("found a non Java Bean compliant class, " + clazz.getName() + ", generating a new class and implementing an around advice to mixin getters"));
            return (ConnectionFactory)ReflectUtils.mixinGetterMethodsAndInstantiate(clazz);
        }
        return factory;
    }

    static {
        String prefixes = System.getProperty("hermes.nonComplientFactories.packagePrefix", "com.tibco.tibjms");
        StringTokenizer tokens = new StringTokenizer(prefixes, ",");
        while (tokens.hasMoreTokens()) {
            nonCompliantPackages.add(tokens.nextToken());
        }
        log = Logger.getLogger(ReflectUtils.class);
    }
}

