/*
 * Decompiled with CFR 0.152.
 */
package hermes.util;

import hermes.util.ReflectUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.log4j.Logger;

public final class GetCachingMethodInterceptor
implements MethodInterceptor {
    private static final Logger log = Logger.getLogger(GetCachingMethodInterceptor.class);
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public final Object intercept(Object object, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        if (ReflectUtils.isGetter(method)) {
            log.debug((Object)("GetCachingMethodInterceptor getter for " + ReflectUtils.getPropertyName(method) + " returns " + this.properties.get(ReflectUtils.getPropertyName(method))));
            return this.properties.get(ReflectUtils.getPropertyName(method));
        }
        log.debug((Object)("superName: " + proxy.getSuperName()));
        Object rval = proxy.invokeSuper(object, args);
        if (ReflectUtils.isSetter(method)) {
            String propertyName = ReflectUtils.getPropertyName(method);
            this.properties.put(propertyName, args[0]);
            log.debug((Object)("GetCachingMethodInterceptor setter for " + ReflectUtils.getPropertyName(method) + " with " + args[0]));
        }
        return rval;
    }
}

