/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing.actions;

import hermes.Hermes;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.model.tree.DestinationConfigTreeNode;
import hermes.browser.model.tree.HermesTreeNode;
import hermes.browser.tasks.BrowseDestinationTask;
import hermes.browser.tasks.MessageTaskListener;
import hermes.browser.tasks.Task;
import hermes.config.DestinationConfig;
import hermes.swing.actions.BrowseActionListenerAdapter;
import hermes.swing.actions.DirectoryCache;
import hermes.util.TextUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.jms.Message;
import javax.swing.JFileChooser;
import javax.swing.ProgressMonitor;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.apache.log4j.Logger;

public class SaveAllMessagesAsXMLAction
extends BrowseActionListenerAdapter {
    private static final Logger log = Logger.getLogger(SaveAllMessagesAsXMLAction.class);

    public SaveAllMessagesAsXMLAction() {
        this.putValue("Name", "Save all as XML...");
        this.putValue("ShortDescription", "Save all messages encoded a XML.");
        this.putValue("SmallIcon", IconCache.getIcon("hermes.messages.save.xml.many"));
        this.setEnabled(false);
        HermesBrowser.getBrowser().getBrowserTree().getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (e.getNewLeadSelectionPath() != null) {
                    SaveAllMessagesAsXMLAction.this.setEnabled(e.getNewLeadSelectionPath().getLastPathComponent() instanceof DestinationConfigTreeNode);
                } else {
                    SaveAllMessagesAsXMLAction.this.setEnabled(false);
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        try {
            DestinationConfigTreeNode destinationNode = HermesBrowser.getBrowser().getBrowserTree().getSelectedDestinationNodes().get(0);
            final DestinationConfig destinationConfig = destinationNode.getConfig();
            final Hermes hermes = ((HermesTreeNode)destinationNode.getParent()).getHermes();
            JFileChooser chooser = DirectoryCache.lastSaveAsDirectory == null ? new JFileChooser(new File(HermesBrowser.getBrowser().getRepositoryManager().getDirectory())) : new JFileChooser(DirectoryCache.lastSaveAsDirectory);
            if (chooser.showDialog((Component)((Object)HermesBrowser.getBrowser()), "Save All Messages...") == 0) {
                DirectoryCache.lastSaveAsDirectory = chooser.getCurrentDirectory();
                final File file = chooser.getSelectedFile();
                final ArrayList messages = new ArrayList();
                BrowseDestinationTask task = new BrowseDestinationTask(hermes, destinationConfig);
                final ProgressMonitor progress = new ProgressMonitor((Component)((Object)HermesBrowser.getBrowser()), "Saving from " + destinationConfig.getName() + " to " + file.getName(), "Browsing...", 0, 3);
                progress.setMillisToPopup(0);
                progress.setMillisToDecideToPopup(0);
                task.addTaskListener(new MessageTaskListener(){

                    @Override
                    public void onMessage(Task task, Message message) {
                        if (progress.isCanceled()) {
                            task.stop();
                        }
                        messages.add(message);
                        progress.setNote(messages.size() + " message" + TextUtils.plural(messages.size()) + " read");
                    }

                    @Override
                    public void onThrowable(Task task, Throwable t) {
                        HermesBrowser.getBrowser().showErrorDialog(t);
                    }

                    @Override
                    public void onStopped(Task task) {
                        if (!progress.isCanceled()) {
                            this.doSave();
                        } else {
                            Hermes.ui.getDefaultMessageSink().add("Cancelled");
                        }
                    }

                    @Override
                    public void onStatus(Task task, String status) {
                    }

                    @Override
                    public void onStarted(Task task) {
                        Hermes.ui.getDefaultMessageSink().add("Browsing " + destinationConfig.getName() + "...");
                        progress.setProgress(1);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private void doSave() {
                        FileOutputStream ostream = null;
                        try {
                            progress.setProgress(2);
                            progress.setNote("Saving to " + file.getName());
                            Hermes.ui.getDefaultMessageSink().add("Saving to " + file.getName());
                            ostream = new FileOutputStream(file);
                            hermes.toXML(messages, (OutputStream)ostream);
                            ostream.close();
                            Hermes.ui.getDefaultMessageSink().add(messages.size() + " message" + TextUtils.plural(messages.size()) + " saved to " + file.getName());
                        }
                        catch (Exception ex) {
                            HermesBrowser.getBrowser().showErrorDialog(ex);
                        }
                        finally {
                            progress.setProgress(3);
                            progress.close();
                            if (ostream != null) {
                                try {
                                    ostream.close();
                                }
                                catch (Exception ex) {
                                    log.error((Object)ex.getMessage(), (Throwable)ex);
                                }
                            }
                        }
                    }
                });
                task.start();
            }
        }
        catch (Exception e) {
            HermesBrowser.getBrowser().showErrorDialog("Unable to save:", e);
        }
    }
}

