/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing.actions;

import com.jidesoft.document.DocumentComponentEvent;
import com.jidesoft.document.DocumentComponentListener;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.components.MessagesDeleteable;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class DeleteMessagesAction
extends AbstractAction
implements DocumentComponentListener,
ListSelectionListener,
TableModelListener {
    public DeleteMessagesAction() {
        this.putValue("Name", "Delete");
        this.putValue("ShortDescription", "Delete selected messages");
        this.putValue("SmallIcon", IconCache.getIcon("hermes.messages.delete"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0, false));
        this.setEnabled(false);
        HermesBrowser.getBrowser().addDocumentComponentListener(this);
        HermesBrowser.getBrowser().addMessageSelectionListener(this);
    }

    private final void attachListener(Object source) {
        if (source instanceof MessagesDeleteable) {
            MessagesDeleteable action = (MessagesDeleteable)source;
            action.getTableModel().addTableModelListener(this);
        }
    }

    private final void detachListener(Object source) {
        if (source instanceof MessagesDeleteable) {
            MessagesDeleteable action = (MessagesDeleteable)source;
            action.getTableModel().removeTableModelListener(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (HermesBrowser.getBrowser().getDocumentPane().getActiveDocument() instanceof MessagesDeleteable) {
            MessagesDeleteable d = (MessagesDeleteable)HermesBrowser.getBrowser().getDocumentPane().getActiveDocument();
            d.delete();
        }
    }

    private void checkEnabled() {
        this.setEnabled(HermesBrowser.getBrowser().getDocumentPane().getActiveDocument() instanceof MessagesDeleteable);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.checkEnabled();
    }

    public void documentComponentActivated(DocumentComponentEvent event) {
        this.attachListener(event.getSource());
        this.checkEnabled();
    }

    public void documentComponentClosed(DocumentComponentEvent event) {
        this.detachListener(event.getSource());
        this.checkEnabled();
    }

    public void documentComponentClosing(DocumentComponentEvent event) {
        this.checkEnabled();
    }

    public void documentComponentDeactivated(DocumentComponentEvent event) {
        this.detachListener(event.getSource());
        this.checkEnabled();
    }

    public void documentComponentMoved(DocumentComponentEvent event) {
        this.checkEnabled();
    }

    public void documentComponentMoving(DocumentComponentEvent event) {
        this.checkEnabled();
    }

    public void documentComponentOpened(DocumentComponentEvent event) {
        this.attachListener(event.getSource());
        this.checkEnabled();
    }

    public void documentComponentDocked(DocumentComponentEvent arg0) {
    }

    public void documentComponentFloated(DocumentComponentEvent arg0) {
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.checkEnabled();
    }
}

