/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing.actions;

import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.model.tree.MessageStoreTreeNode;
import hermes.browser.model.tree.MessageStoreURLTreeNode;
import hermes.store.MessageStore;
import hermes.store.MessageStoreManager;
import hermes.swing.actions.ActionSupport;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.jms.JMSException;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class CreateNewMessageStoreAction
extends ActionSupport {
    private static final Logger log = Logger.getLogger(CreateNewMessageStoreAction.class);

    public CreateNewMessageStoreAction() {
        this.putValue("Name", "New Message Store...");
        this.putValue("ShortDescription", "Create new JMS message Store.");
        this.putValue("SmallIcon", IconCache.getIcon("hermes.store.new"));
        this.setEnabled(!HermesBrowser.getBrowser().isRestricted() && !HermesBrowser.getBrowser().isMessageStoresDisabled());
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        String name = JOptionPane.showInputDialog((Component)((Object)HermesBrowser.getBrowser()), "Message store name:", null);
        if (name != null && !name.equals("")) {
            try {
                TreePath treePath = HermesBrowser.getBrowser().getBrowserTree().getSelectionPath();
                MessageStore store = null;
                if (treePath != null) {
                    if (treePath.getLastPathComponent() instanceof MessageStoreURLTreeNode) {
                        MessageStoreURLTreeNode node = (MessageStoreURLTreeNode)treePath.getLastPathComponent();
                        store = MessageStoreManager.create(node.getURL(), name);
                    } else if (treePath.getLastPathComponent() instanceof MessageStoreTreeNode) {
                        MessageStoreTreeNode node = (MessageStoreTreeNode)treePath.getLastPathComponent();
                        MessageStoreURLTreeNode parent = (MessageStoreURLTreeNode)node.getParent();
                        store = MessageStoreManager.create(parent.getURL(), name);
                    }
                }
                if (store == null) {
                    store = MessageStoreManager.create(name);
                }
                HermesBrowser.getBrowser().getBrowserTree().getBrowserModel().onMessageStoreAdded(store);
            }
            catch (JMSException e) {
                HermesBrowser.getBrowser().showErrorDialog(e);
            }
        }
    }
}

