/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing.actions;

import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.model.tree.DestinationConfigTreeNode;
import hermes.browser.model.tree.HermesTreeNode;
import hermes.swing.actions.ActionSupport;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class CopyBrowserNodeAction
extends ActionSupport {
    private static final Logger log = Logger.getLogger(CopyBrowserNodeAction.class);

    public CopyBrowserNodeAction() {
        this.putValue("Name", "Duplicate...");
        this.putValue("ShortDescription", "Duplicate the sessions/destination configuration.");
        this.putValue("SmallIcon", IconCache.getIcon("copy"));
        this.setEnabled(false);
        if (!HermesBrowser.getBrowser().isRestricted()) {
            this.enableOnBrowserTreeSelection(new Class[]{HermesTreeNode.class, DestinationConfigTreeNode.class}, (Action)this, true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        try {
            if (this.getBrowserTree().getSelectionPath() != null) {
                TreeNode node = (TreeNode)this.getBrowserTree().getSelectionPath().getLastPathComponent();
                if (node instanceof HermesTreeNode) {
                    HermesTreeNode hermesNode = (HermesTreeNode)node;
                    String newName = JOptionPane.showInputDialog((Component)((Object)HermesBrowser.getBrowser()), "Enter new name for this session:", "Copy of " + hermesNode.getHermes().getId());
                    if (newName != null && !newName.equals("") && !newName.equals(hermesNode.getHermes().getId())) {
                        HermesBrowser.getConfigDAO().duplicateSession(HermesBrowser.getBrowser().getConfig(), hermesNode.getHermes().getId(), newName);
                        HermesBrowser.getBrowser().saveConfig();
                        HermesBrowser.getBrowser().loadConfig();
                    }
                } else if (node instanceof DestinationConfigTreeNode) {
                    DestinationConfigTreeNode destinationNode = (DestinationConfigTreeNode)node;
                    HermesTreeNode hermesNode = destinationNode.getHermesTreeNode();
                    String newName = JOptionPane.showInputDialog((Component)((Object)HermesBrowser.getBrowser()), "Enter new name for this destination:", "Copy of " + destinationNode.getConfig().getName());
                    if (newName != null && !newName.equals("") && !newName.equals(destinationNode.getConfig().getName())) {
                        hermesNode.getHermes().addDestinationConfig(HermesBrowser.getConfigDAO().duplicate(destinationNode.getConfig()));
                        HermesBrowser.getBrowser().saveConfig();
                        HermesBrowser.getBrowser().loadConfig();
                    }
                }
            }
        }
        catch (Exception ex) {
            HermesBrowser.getBrowser().showErrorDialog("Copying object: " + ex.getMessage(), ex);
        }
    }
}

