/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing.actions;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.Transferable;
import javax.swing.Action;

public class ClipboardFlavourListener
implements FlavorListener {
    private Action action;
    private DataFlavor flavor;

    public ClipboardFlavourListener(Action action, DataFlavor flavor) {
        this.action = action;
        this.flavor = flavor;
    }

    @Override
    public void flavorsChanged(FlavorEvent arg0) {
        try {
            if (Toolkit.getDefaultToolkit().getSystemClipboard().isDataFlavorAvailable(this.flavor)) {
                Transferable clipboardContent = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
                this.action.setEnabled(clipboardContent != null && clipboardContent.isDataFlavorSupported(this.flavor));
            } else {
                this.action.setEnabled(false);
            }
        }
        catch (IllegalStateException ex) {
            this.action.setEnabled(false);
        }
    }
}

