/*
 * Decompiled with CFR 0.152.
 */
package hermes.providers.file;

import hermes.Domain;
import hermes.HermesException;
import hermes.providers.file.Commitable;
import hermes.providers.file.FileConnection;
import hermes.providers.file.FileMessageConsumer;
import hermes.providers.file.FileMessageFactory;
import hermes.providers.file.FileMessageProducer;
import hermes.providers.file.FileQueue;
import hermes.providers.file.FileQueueBrowser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class FileSession
extends FileMessageFactory
implements QueueSession {
    private static final Logger log = Logger.getLogger(FileSession.class);
    private static final String SEPARATOR = System.getProperty("file.separator");
    private FileConnection connection;
    private MessageListener listener;
    private boolean transacted;
    private int ackMode;
    private Collection onCommit = new ArrayList();

    public FileSession(FileConnection connection, boolean transacted, int ackMode) {
        this.connection = connection;
        this.transacted = transacted;
        this.ackMode = ackMode;
    }

    public void close() throws JMSException {
        this.onCommit.clear();
    }

    public void commit() throws JMSException {
        for (Commitable c : this.onCommit) {
            c.commit();
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.listener;
    }

    public boolean getTransacted() throws JMSException {
        return this.transacted;
    }

    public void recover() throws JMSException {
    }

    public void rollback() throws JMSException {
        for (Commitable c : this.onCommit) {
            c.rollback();
        }
    }

    public void run() {
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.listener = listener;
    }

    public QueueBrowser createBrowser(Queue arg0, String arg1) throws JMSException {
        return new FileQueueBrowser(this, (FileQueue)arg0, arg1);
    }

    public QueueBrowser createBrowser(Queue arg0) throws JMSException {
        return new FileQueueBrowser(this, (FileQueue)arg0);
    }

    public Queue createQueue(String queueName) throws JMSException {
        try {
            if (this.getConnection().getFactory().getBaseDirectory() != null) {
                queueName = this.getConnection().getFactory().getBaseDirectory() + SEPARATOR + queueName;
            }
            return (Queue)super.getDestination(queueName, Domain.QUEUE);
        }
        catch (NamingException ex) {
            throw new HermesException(ex);
        }
    }

    public QueueReceiver createReceiver(Queue arg0, String arg1) throws JMSException {
        try {
            FileMessageConsumer rval = new FileMessageConsumer(this, (FileQueue)arg0, arg1);
            this.onCommit.add(rval);
            return rval;
        }
        catch (IOException e) {
            throw new HermesException(e);
        }
    }

    public QueueReceiver createReceiver(Queue arg0) throws JMSException {
        try {
            FileMessageConsumer rval = new FileMessageConsumer(this, (FileQueue)arg0, null);
            this.onCommit.add(rval);
            return rval;
        }
        catch (IOException e) {
            throw new HermesException(e);
        }
    }

    public QueueSender createSender(Queue arg0) throws JMSException {
        FileMessageProducer rval = new FileMessageProducer(this, (FileQueue)arg0);
        this.onCommit.add(rval);
        return rval;
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        try {
            return new FileQueue();
        }
        catch (IOException e) {
            throw new HermesException(e);
        }
    }

    public FileConnection getConnection() {
        return this.connection;
    }

    public MessageConsumer createConsumer(Destination arg0, String arg1, boolean arg2) throws JMSException {
        try {
            FileMessageConsumer rval = new FileMessageConsumer(this, (FileQueue)arg0, null);
            this.onCommit.add(rval);
            return rval;
        }
        catch (IOException e) {
            throw new HermesException(e);
        }
    }

    public MessageConsumer createConsumer(Destination arg0, String arg1) throws JMSException {
        try {
            FileMessageConsumer rval = new FileMessageConsumer(this, (FileQueue)arg0, null);
            this.onCommit.add(rval);
            return rval;
        }
        catch (IOException e) {
            throw new HermesException(e);
        }
    }

    public MessageConsumer createConsumer(Destination arg0) throws JMSException {
        try {
            FileMessageConsumer rval = new FileMessageConsumer(this, (FileQueue)arg0, null);
            this.onCommit.add(rval);
            return rval;
        }
        catch (IOException e) {
            throw new HermesException(e);
        }
    }

    public TopicSubscriber createDurableSubscriber(Topic arg0, String arg1, String arg2, boolean arg3) throws JMSException {
        return null;
    }

    public TopicSubscriber createDurableSubscriber(Topic arg0, String arg1) throws JMSException {
        return null;
    }

    public MessageProducer createProducer(Destination arg0) throws JMSException {
        FileMessageProducer rval = new FileMessageProducer(this, (FileQueue)arg0);
        this.onCommit.add(rval);
        return rval;
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        return null;
    }

    public Topic createTopic(String arg0) throws JMSException {
        return null;
    }

    public int getAcknowledgeMode() throws JMSException {
        return 0;
    }

    public void unsubscribe(String arg0) throws JMSException {
    }
}

