/*
 * Decompiled with CFR 0.152.
 */
package hermes.providers.file;

import hermes.Domain;
import hermes.HermesException;
import hermes.MessageFactory;
import hermes.providers.file.FileQueue;
import hermes.providers.messages.MapMessageImpl;
import hermes.providers.messages.MessageImpl;
import hermes.providers.messages.ObjectMessageImpl;
import hermes.providers.messages.TextMessageImpl;
import java.io.File;
import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.naming.NamingException;

public class FileMessageFactory
implements MessageFactory {
    @Override
    public BytesMessage createBytesMessage() throws JMSException {
        throw new HermesException("BytesMessage not supported");
    }

    @Override
    public MapMessage createMapMessage() throws JMSException {
        return new MapMessageImpl();
    }

    @Override
    public ObjectMessage createObjectMessage() throws JMSException {
        return new ObjectMessageImpl();
    }

    @Override
    public StreamMessage createStreamMessage() throws JMSException {
        throw new HermesException("StreamMessage not supported");
    }

    @Override
    public TextMessage createTextMessage() throws JMSException {
        return new TextMessageImpl();
    }

    @Override
    public TextMessage createTextMessage(String text) throws JMSException {
        return new TextMessageImpl(text);
    }

    @Override
    public Message createMessage() throws JMSException {
        return new MessageImpl();
    }

    @Override
    public Destination getDestination(String name, Domain domain) throws JMSException, NamingException {
        File file = new File(name);
        return new FileQueue(file);
    }

    @Override
    public String getDestinationName(Destination to) throws JMSException {
        if (to instanceof Queue) {
            return ((Queue)to).getQueueName();
        }
        return ((Topic)to).getTopicName();
    }

    @Override
    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        return new ObjectMessageImpl(object);
    }
}

