/*
 * Decompiled with CFR 0.152.
 */
package hermes.impl.naming;

import hermes.config.HermesConfig;
import java.io.StringWriter;
import java.io.Writer;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import org.apache.log4j.Logger;

public class ConfigBinding
implements Referenceable {
    private static final Logger log = Logger.getLogger(ConfigBinding.class);
    static final String HERMES_XML = "hermesXML";
    private HermesConfig hermesConfig;

    public ConfigBinding(HermesConfig hermesConfig) {
    }

    @Override
    public Reference getReference() throws NamingException {
        try {
            StringWriter stringWriter = new StringWriter();
            JAXBContext jc = JAXBContext.newInstance((String)"hermes.config");
            Marshaller m = jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)this.getConfig(), (Writer)stringWriter);
            StringRefAddr refAddr = new StringRefAddr(HERMES_XML, stringWriter.getBuffer().toString());
            return new Reference(this.getClass().getName(), refAddr);
        }
        catch (PropertyException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new NamingException("cannot create HermesConfig reference: " + e.getMessage());
        }
        catch (JAXBException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new NamingException("cannot create HermesConfig reference: " + e.getMessage());
        }
    }

    public HermesConfig getConfig() throws NamingException {
        if (this.hermesConfig == null) {
            throw new NamingException("Hermes configuration is null");
        }
        return this.hermesConfig;
    }
}

