/*
 * Decompiled with CFR 0.152.
 */
package hermes.ext.weblogic;

import hermes.Hermes;
import hermes.HermesAdmin;
import hermes.HermesAdminFactory;
import hermes.HermesException;
import hermes.JNDIConnectionFactory;
import hermes.ext.weblogic.WebLogicJMSAdmin;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class WebLogicJMSAdminFactory
implements HermesAdminFactory {
    private static final Logger log = Logger.getLogger(WebLogicJMSAdminFactory.class);
    private String webLogicDomain = "mydomain";
    private String jmsServer = "MyJMS Server";
    private String webLogicServer = "MyServer";

    @Override
    public HermesAdmin createSession(Hermes hermes, ConnectionFactory connectionFactory) throws JMSException, NamingException {
        if (connectionFactory instanceof JNDIConnectionFactory) {
            JNDIConnectionFactory jndiCF = (JNDIConnectionFactory)connectionFactory;
            return new WebLogicJMSAdmin(hermes, this, jndiCF.createContext());
        }
        throw new HermesException("Provider is not WebLogicJMS");
    }

    public String getJmsServer() {
        return this.jmsServer;
    }

    public String getWebLogicDomain() {
        return this.webLogicDomain;
    }

    public String getWebLogicServer() {
        return this.webLogicServer;
    }

    public void setJmsServer(String string) {
        this.jmsServer = string;
    }

    public void setWebLogicDomain(String string) {
        this.webLogicDomain = string;
    }

    public void setWebLogicServer(String string) {
        this.webLogicServer = string;
    }
}

