/*
 * Decompiled with CFR 0.152.
 */
package hermes.ext.fiorano;

import fiorano.jms.runtime.admin.MQAdminConnection;
import fiorano.jms.runtime.admin.MQAdminService;
import hermes.Domain;
import hermes.Hermes;
import hermes.HermesAdmin;
import hermes.HermesException;
import hermes.config.DestinationConfig;
import hermes.ext.HermesAdminSupport;
import java.util.Map;
import java.util.TreeMap;
import javax.jms.Destination;
import javax.jms.JMSException;

public class FioranoAdmin
extends HermesAdminSupport
implements HermesAdmin {
    private static final String DELIVERABLE_MESSGAES = "deliverable";
    private static final String UNDELETED_MESSGAES = "undeleted";
    private MQAdminConnection adminConnection;
    private MQAdminService adminService;

    public FioranoAdmin(Hermes hermes, MQAdminConnection adminConnection) {
        super(hermes);
        this.adminConnection = adminConnection;
    }

    protected synchronized MQAdminService getAdminService() throws JMSException {
        if (this.adminService == null) {
            if (this.adminConnection != null) {
                this.adminService = this.adminConnection.getMQAdminService();
            } else {
                throw new HermesException("FioranoMQ plugin is closed");
            }
        }
        return this.adminService;
    }

    @Override
    public int truncate(DestinationConfig dConfig) throws JMSException {
        int rval = this.getDepth(dConfig);
        if (dConfig.getDomain().intValue() == Domain.QUEUE.getId()) {
            this.getAdminService().purgeQueueMessages(this.getRealDestinationName(dConfig));
        } else if (dConfig.getDomain().intValue() == Domain.TOPIC.getId() && dConfig.isDurable()) {
            this.getAdminService().purgeSubscriptionMessages(this.getHermes().getConnection().getClientID(), dConfig.getClientID());
        } else {
            throw new HermesException("Domain for " + dConfig.getName() + " is unknown.");
        }
        return rval;
    }

    @Override
    public int getDepth(DestinationConfig dConfig) throws JMSException {
        if (dConfig.getDomain().intValue() == Domain.QUEUE.getId()) {
            return (int)this.getAdminService().getNumberOfDeliverableMessages(this.getRealDestinationName(dConfig));
        }
        String clientId = this.getHermes().getConnection().getClientID();
        String subId = dConfig.getClientID();
        return (int)this.getAdminService().getNumberOfDeliverableMessages(clientId, subId);
    }

    @Override
    public Map getStatistics(DestinationConfig dConfig) throws JMSException {
        TreeMap<String, Long> map = new TreeMap<String, Long>();
        Domain domain = Domain.getDomain(dConfig.getDomain());
        if (domain == Domain.QUEUE) {
            map.put(DELIVERABLE_MESSGAES, new Long(this.getAdminService().getNumberOfDeliverableMessages(dConfig.getName())));
            map.put(UNDELETED_MESSGAES, new Long(this.getAdminService().getNumberOfUndeletedMessages(dConfig.getName())));
        } else if (dConfig.isDurable()) {
            String clientId = this.getHermes().getConnection().getClientID();
            String subId = dConfig.getClientID();
            map.put(DELIVERABLE_MESSGAES, new Long(this.getAdminService().getNumberOfDeliverableMessages(dConfig.getName(), subId)));
        }
        return map;
    }

    public int truncate(Destination destination) throws JMSException {
        String queueName = this.getHermes().getDestinationName(destination);
        long endIndex = this.getAdminService().getNumberOfDeliverableMessages(queueName);
        this.getAdminService().purgeQueueMessages(queueName);
        return (int)endIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws JMSException {
        try {
            this.adminConnection.close();
        }
        finally {
            this.adminConnection = null;
            this.adminService = null;
        }
    }
}

