/*
 * Decompiled with CFR 0.152.
 */
package hermes.ext;

import hermes.Domain;
import hermes.Hermes;
import hermes.HermesAdminListener;
import hermes.HermesException;
import hermes.JNDIConnectionFactory;
import hermes.browser.HermesBrowser;
import hermes.browser.MessageRenderer;
import hermes.config.DestinationConfig;
import hermes.impl.TopicBrowser;
import hermes.util.JMSUtils;
import hermes.util.TextUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.QueueBrowser;
import javax.jms.Topic;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.swing.ProgressMonitor;
import org.apache.log4j.Logger;

public abstract class HermesAdminSupport {
    private static final Logger log = Logger.getLogger(HermesAdminSupport.class);
    private static final Map<String, Object> defaultStatistics = new HashMap<String, Object>();
    private final Set<HermesAdminListener> listeners = new HashSet<HermesAdminListener>();
    private final List statisticsHeader = new ArrayList();
    private final Map destinationConfigs = new HashMap();
    private final Hermes hermes;
    private boolean isNameInNamespaceCheck = true;
    private long ms = 10000L;

    public static Map getDefaultStatistics() {
        return defaultStatistics;
    }

    public HermesAdminSupport(Hermes hermes) {
        this.hermes = hermes;
    }

    public void delete(DestinationConfig dConfig, Collection<String> messageIds) throws JMSException, NamingException {
        this.delete(dConfig, messageIds, null);
    }

    public void delete(DestinationConfig dConfig, Collection<String> messageIds, ProgressMonitor progress) throws JMSException, NamingException {
        StringBuffer sqlBuffer = new StringBuffer();
        Iterator<String> iter = messageIds.iterator();
        while (iter.hasNext()) {
            sqlBuffer.append("JMSMessageID = '").append((Object)iter.next()).append("'");
            if (!iter.hasNext()) continue;
            sqlBuffer.append(" or ");
        }
        Destination d = this.getHermes().getDestination(dConfig.getName(), Domain.getDomain(dConfig.getDomain()));
        String sql = sqlBuffer.toString();
        for (int deleted = 0; deleted < messageIds.size(); ++deleted) {
            Message m = this.hermes.receive(d, this.ms, sql);
            if (m != null) {
                if (progress == null) continue;
                progress.setNote(deleted + " message" + TextUtils.plural(deleted) + " deleted");
                progress.setProgress(deleted);
                if (!progress.isCanceled()) continue;
                this.hermes.rollback();
                return;
            }
            throw new JMSException("Timeout reading from MessageConsumer to delete messages");
        }
    }

    public void addListener(HermesAdminListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(HermesAdminListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyDestinationAdded(DestinationConfig config) {
        for (HermesAdminListener listener : this.listeners) {
            listener.onDestinationAdded(config);
        }
    }

    protected void notifyDestinationRemoved(DestinationConfig config) {
        for (HermesAdminListener listener : this.listeners) {
            listener.onDestinationRemoved(config);
        }
    }

    public long getAge(DestinationConfig dest) throws JMSException {
        Message topMessage;
        long rval = 0L;
        QueueBrowser browser = this.hermes.createBrowser(dest);
        Enumeration iter = browser.getEnumeration();
        if (iter.hasMoreElements() && (topMessage = (Message)iter.nextElement()) != null) {
            rval = topMessage.getJMSTimestamp();
        }
        browser.close();
        return rval;
    }

    public abstract int getDepth(DestinationConfig var1) throws JMSException;

    public Hermes getHermes() {
        return this.hermes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int truncate(DestinationConfig dConfig) throws JMSException {
        boolean keepRunning = true;
        StringBuffer message = new StringBuffer();
        int numToDelete = 0;
        ProgressMonitor monitor = new ProgressMonitor((Component)((Object)HermesBrowser.getBrowser()), "Deleting from " + dConfig.getName(), "Discovering size of " + dConfig.getName(), 0, 102);
        monitor.setMillisToDecideToPopup(100);
        monitor.setMillisToPopup(400);
        try {
            QueueBrowser browser = this.getHermes().createBrowser(dConfig);
            Enumeration iter = browser.getEnumeration();
            monitor.setProgress(1);
            Hermes.ui.getDefaultMessageSink().add("Discovering size of " + dConfig.getName());
            while (iter.hasMoreElements() && keepRunning && !monitor.isCanceled()) {
                iter.nextElement();
                ++numToDelete;
            }
            browser.close();
            this.getHermes().rollback();
            if (monitor.isCanceled()) {
                keepRunning = false;
            }
            String message2 = dConfig.getName() + " is already empty.";
            message2 = numToDelete == 1 ? "Deleting one message from " + dConfig.getName() : "Deleting " + numToDelete + " messages from " + dConfig.getName();
            Hermes.ui.getDefaultMessageSink().add(message2);
            monitor.setProgress(2);
            Destination destination = this.getHermes().getDestination(dConfig.getName(), Domain.getDomain(dConfig.getDomain()));
            for (int i = 0; i < numToDelete && keepRunning && !monitor.isCanceled(); ++i) {
                Message m = null;
                while (m == null && keepRunning) {
                    m = this.getHermes().receive(destination, 10000L);
                }
                monitor.setNote(new Long(i) + " messages deleted");
                float l_i = i;
                float l_numToDelete = numToDelete;
                int progress = Math.round(2.0f + l_i / l_numToDelete * 100.0f);
                monitor.setProgress(progress);
            }
            if (monitor.isCanceled()) {
                keepRunning = false;
            }
            if (numToDelete > 0) {
                if (keepRunning) {
                    this.getHermes().commit();
                    message.append("Committed. ").append(numToDelete).append(" messages deleted from " + dConfig.getName());
                } else {
                    this.getHermes().rollback();
                    message.append("Trucate of ").append(dConfig.getName()).append(" rolled back");
                }
            }
        }
        catch (Exception ex) {
            message.append("During truncate of ").append(dConfig.getName()).append(": ").append(ex.getMessage());
            log.error((Object)ex);
        }
        finally {
            if (monitor != null) {
                monitor.close();
            }
        }
        Hermes.ui.getDefaultMessageSink().add(message);
        return numToDelete;
    }

    public Map getStatistics(DestinationConfig destination) throws JMSException {
        return defaultStatistics;
    }

    public Collection getStatistics(Collection destinations) throws JMSException {
        ArrayList<Map> rval = new ArrayList<Map>();
        for (DestinationConfig d : destinations) {
            rval.add(this.getStatistics(d));
        }
        return rval;
    }

    public Enumeration createBrowserProxy(Enumeration iter) throws JMSException {
        return iter;
    }

    protected Collection discoverDurableSubscriptions(String topicName, String jndiName) throws JMSException {
        return new ArrayList();
    }

    private void discoverDestinationConfigsFromContext(String path, Context ctx, Collection<DestinationConfig> rval, Set<String> visited) throws JMSException {
        try {
            if (this.isNameInNamespaceCheck) {
                try {
                    if (visited.contains(ctx.getNameInNamespace())) {
                        return;
                    }
                    visited.add(ctx.getNameInNamespace());
                }
                catch (OperationNotSupportedException ex) {
                    this.isNameInNamespaceCheck = false;
                }
            }
            NamingEnumeration<NameClassPair> iter = ctx.list("");
            while (iter.hasMore()) {
                NameClassPair entry = iter.next();
                try {
                    Object object = ctx.lookup(entry.getName());
                    DestinationConfig config = null;
                    if (object instanceof Destination) {
                        Domain domain = Domain.getDomain((Destination)object);
                        if (domain == Domain.QUEUE) {
                            config = HermesBrowser.getConfigDAO().createDestinationConfig();
                            config.setDomain(Domain.QUEUE.getId());
                        } else if (domain == Domain.TOPIC) {
                            config = HermesBrowser.getConfigDAO().createDestinationConfig();
                            config.setDomain(Domain.TOPIC.getId());
                            rval.addAll(this.discoverDurableSubscriptions(JMSUtils.getDestinationName((Destination)((Topic)object)), path == null ? entry.getName() : path + "/" + entry.getName()));
                        } else {
                            config = HermesBrowser.getConfigDAO().createDestinationConfig();
                            config.setDomain(Domain.UNKNOWN.getId());
                        }
                    } else if (object instanceof Context) {
                        String ctxPath = path == null ? entry.getName() : path + "/" + entry.getName();
                        this.discoverDestinationConfigsFromContext(ctxPath, (Context)object, rval, visited);
                    }
                    if (config == null) continue;
                    String binding = null;
                    binding = path == null ? entry.getName() : path + "/" + entry.getName();
                    config.setName(binding);
                    rval.add(config);
                }
                catch (Throwable ex) {
                    log.error((Object)("discoverDestinationConfig binding=" + entry.getName() + ": " + ex.getMessage()), ex);
                }
            }
        }
        catch (NamingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new HermesException(e);
        }
    }

    public Collection<DestinationConfig> discoverDestinationConfigs() throws JMSException {
        if (this.hermes.getConnectionFactory() instanceof JNDIConnectionFactory) {
            JNDIConnectionFactory cf = (JNDIConnectionFactory)this.hermes.getConnectionFactory();
            ArrayList<DestinationConfig> rval = new ArrayList<DestinationConfig>();
            Context ctx = cf.createContext();
            this.discoverDestinationConfigsFromContext(null, ctx, rval, new HashSet<String>());
            return rval;
        }
        throw new HermesException("The default provider extension cannot discover queues or topics on " + this.hermes.getConnectionFactory().getClass().getName());
    }

    public MessageRenderer getMessageRenderer() throws JMSException {
        return null;
    }

    public QueueBrowser createDurableSubscriptionBrowser(DestinationConfig dConfig) throws JMSException {
        return new TopicBrowser(this.getHermes().getSession(), this.getHermes().getDestinationManager(), dConfig);
    }

    public String getRealDestinationName(DestinationConfig dConfig) throws JMSException {
        try {
            return JMSUtils.getDestinationName(this.getHermes().getDestination(dConfig.getName(), Domain.getDomain(dConfig.getDomain())));
        }
        catch (NamingException ex) {
            throw new HermesException(ex);
        }
    }

    static {
        defaultStatistics.put("Unavailable", "No statistics currently available.");
    }
}

