/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.model;

import hermes.browser.model.MapTableModel;
import java.util.Map;
import org.apache.commons.collections.list.TreeList;
import org.apache.log4j.Logger;

public class KeyValueMapTableModel
extends MapTableModel {
    private static final Logger log = Logger.getLogger(KeyValueMapTableModel.class);
    private Map map;
    private TreeList headers = new TreeList();

    public KeyValueMapTableModel(Map map) {
        this.setMap(map);
    }

    @Override
    public void setMap(Map map) {
        this.map = map;
        this.headers.clear();
        for (Map.Entry entry : map.entrySet()) {
            this.headers.add(entry.getKey());
        }
        this.fireTableStructureChanged();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        if (this.map != null) {
            return this.map.size();
        }
        return 0;
    }

    @Override
    public Object getValueAt(int y, int x) {
        String key = (String)this.headers.get(y);
        if (x == 0) {
            return key;
        }
        if (this.map.get(key) != null) {
            return this.map.get(key).toString();
        }
        return "null";
    }

    public Class getColumnClass(int x) {
        return String.class;
    }

    @Override
    public String getColumnName(int arg0) {
        if (arg0 == 0) {
            return "Property";
        }
        return "Value";
    }
}

