/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.dialog.message;

import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.StandardDialog;
import com.jidesoft.swing.JideSwingUtilities;
import hermes.Hermes;
import hermes.HermesRuntimeException;
import hermes.browser.HermesBrowser;
import hermes.browser.dialog.message.EditableMessageHeaderTableModel;
import hermes.browser.dialog.message.MessageHeaderTable;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class MessageEditor
extends StandardDialog {
    private static final long serialVersionUID = -5465641794588176447L;
    private static final Logger log = Logger.getLogger(MessageEditor.class);
    private Hermes hermes;
    private Message message;
    private boolean rval;

    public MessageEditor(Hermes hermes, Message message) throws JMSException {
        super((Frame)((Object)HermesBrowser.getBrowser()));
        this.hermes = hermes;
        this.message = hermes.duplicate(message);
        this.setMinimumSize(new Dimension(300, 400));
    }

    public Message getMessage() {
        return this.message;
    }

    public JComponent createBannerPanel() {
        return null;
    }

    public boolean edit() {
        this.pack();
        JideSwingUtilities.centerWindow((Window)((Object)this));
        this.show();
        return this.rval;
    }

    public ButtonPanel createButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        JButton okButton = new JButton("OK");
        JButton cancelButton = new JButton("Cancel");
        buttonPanel.addButton((AbstractButton)okButton);
        buttonPanel.addButton((AbstractButton)cancelButton);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageEditor.this.rval = true;
                MessageEditor.this.dispose();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageEditor.this.rval = false;
                MessageEditor.this.dispose();
            }
        });
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        return buttonPanel;
    }

    public JComponent createContentPanel() {
        try {
            EditableMessageHeaderTableModel tableModel = new EditableMessageHeaderTableModel(this.message);
            MessageHeaderTable table = new MessageHeaderTable(tableModel);
            return table;
        }
        catch (JMSException ex) {
            throw new HermesRuntimeException((Exception)((Object)ex));
        }
    }
}

