/*
 * Decompiled with CFR 0.152.
 */
package hermes.ant;

import hermes.Domain;
import hermes.Hermes;
import hermes.ant.AbstractTask;
import hermes.ant.DestinationSelectionType;
import hermes.ant.HermesFactory;
import hermes.store.MessageStore;
import hermes.store.MessageStoreManager;
import hermes.util.JMSUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.QueueBrowser;
import org.apache.tools.ant.BuildException;

public class ReplayMessagesTask
extends AbstractTask {
    private String queue;
    private String topic;
    private String jdbcURL;
    private String storeId;
    private int commitInterval = 1;
    private boolean timed = false;
    private List<DestinationSelectionType> storeDestinations = new ArrayList<DestinationSelectionType>();

    public void addConfigured(DestinationSelectionType storeDestination) {
        this.storeDestinations.add(storeDestination);
    }

    public void execute() throws BuildException {
        MessageStore messageStore;
        Destination toDestination;
        Hermes myHermes;
        if (this.storeId == null) {
            throw new BuildException("storeId not set");
        }
        try {
            myHermes = HermesFactory.createHermes(this.getConfig(), this.getHermes());
            if (this.queue != null || this.topic != null) {
                Domain domain = this.queue != null ? Domain.QUEUE : Domain.TOPIC;
                String destinationName = this.queue != null ? this.queue : this.topic;
                toDestination = myHermes.getDestination(destinationName, domain);
            } else {
                toDestination = null;
            }
            messageStore = this.jdbcURL == null ? MessageStoreManager.create(this.storeId) : MessageStoreManager.create(this.jdbcURL, this.storeId);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        try {
            if (this.storeDestinations.size() == 0) {
                if (toDestination == null) {
                    this.log("Replaying all messages from store " + messageStore.getId() + " to " + myHermes.getId());
                }
                this.doReplay(messageStore, myHermes, toDestination);
            } else {
                for (DestinationSelectionType storeDestinationConfig : this.storeDestinations) {
                    Destination storeDestination = myHermes.getDestination(storeDestinationConfig.getName(), storeDestinationConfig.asDomain());
                    this.doReplay(messageStore, storeDestination, myHermes, toDestination);
                }
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            try {
                if (myHermes != null) {
                    myHermes.close();
                }
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
    }

    private void doReplay(MessageStore store, Hermes hermes) throws JMSException {
        this.doReplay(store, null, hermes, null);
    }

    private void doReplay(MessageStore store, Hermes hermes, Destination hermesDestination) throws JMSException {
        this.doReplay(store, null, hermes, hermesDestination);
    }

    private void doReplay(MessageStore store, Destination storeDestination, Hermes hermes, Destination hermesDestination) throws JMSException {
        MessageStore.HeaderPolicy headerPolicy = hermesDestination == null ? MessageStore.HeaderPolicy.DESTINATION_ONLY : MessageStore.HeaderPolicy.NO_HEADER;
        QueueBrowser browser = storeDestination == null ? store.visit(hermes, headerPolicy) : store.visit(hermes, storeDestination, headerPolicy);
        int messagesSent = 0;
        long lastTimestamp = 0L;
        Enumeration iter = browser.getEnumeration();
        while (iter.hasMoreElements()) {
            Message message = (Message)iter.nextElement();
            if (message == null) continue;
            if (hermesDestination == null) {
                hermes.send(message.getJMSDestination(), message);
            } else {
                hermes.send(hermesDestination, message);
            }
            if (++messagesSent % this.commitInterval == 0 && hermes.getTransacted()) {
                hermes.commit();
            }
            if (!this.timed || lastTimestamp == 0L) continue;
            long delay = message.getJMSTimestamp() - lastTimestamp;
            if (delay > 0L) {
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            lastTimestamp = message.getJMSTimestamp();
        }
        hermes.commit();
        JMSUtils.closeQuietly(browser);
        hermes.close();
    }

    public boolean isTimed() {
        return this.timed;
    }

    public void setTimed(boolean timed) {
        this.timed = timed;
    }

    public String getQueue() {
        return this.queue;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getJdbcURL() {
        return this.jdbcURL;
    }

    public void setJdbcURL(String jdbcURL) {
        this.jdbcURL = jdbcURL;
    }

    public int getCommitInterval() {
        return this.commitInterval;
    }

    public void setCommitInterval(int commitInterval) {
        this.commitInterval = commitInterval;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }
}

