/*
 * Decompiled with CFR 0.152.
 */
package hermes.ant;

import hermes.Domain;
import hermes.Hermes;
import hermes.ant.AbstractTask;
import hermes.ant.HermesFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;

public class PutTextTask
extends AbstractTask {
    private static final Logger log = Logger.getLogger(PutTextTask.class);
    private String destination;
    private String file;

    public void execute() throws BuildException {
        if (this.destination == null) {
            throw new BuildException("destination property not set");
        }
        if (this.file == null) {
            throw new BuildException("file property for the message XML file not set");
        }
        try {
            String line;
            Hermes myHermes = HermesFactory.createHermes(this.getConfig(), this.getHermes());
            Destination destination = myHermes.getDestination(this.getDestination(), Domain.UNKNOWN);
            BufferedReader reader = new BufferedReader(new FileReader(new File(this.getFile())));
            TextMessage textMessage = myHermes.createTextMessage();
            StringBuffer buffer = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
            }
            textMessage.setText(buffer.toString());
            myHermes.send(destination, (Message)textMessage);
            if (myHermes.getTransacted()) {
                myHermes.commit();
            }
            this.log(" message written to " + this.getDestination() + " on " + this.getHermes());
            myHermes.close();
        }
        catch (Throwable ex) {
            log.error((Object)ex.getMessage(), ex);
            throw new BuildException(ex);
        }
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }
}

