/*
 * Decompiled with CFR 0.152.
 */
package graphql.util;

import graphql.Assert;
import graphql.Internal;
import java.util.function.Supplier;

@Internal
class IntraThreadMemoizedSupplier<T>
implements Supplier<T> {
    private static final Object SENTINEL = new Object(){};
    private T value = SENTINEL;
    private final Supplier<T> delegate;

    IntraThreadMemoizedSupplier(Supplier<T> delegate) {
        this.delegate = Assert.assertNotNull(delegate);
    }

    @Override
    public T get() {
        T t = this.value;
        if (t == SENTINEL) {
            this.value = t = this.delegate.get();
        }
        return t;
    }
}

