/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.schema.GraphQLAppliedDirective;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLNamedSchemaElement;
import java.util.List;
import java.util.Map;

@PublicApi
public interface GraphQLDirectiveContainer
extends GraphQLNamedSchemaElement {
    public static final String CHILD_DIRECTIVES = "directives";
    public static final String CHILD_APPLIED_DIRECTIVES = "appliedDirectives";

    public List<GraphQLAppliedDirective> getAppliedDirectives();

    public Map<String, List<GraphQLAppliedDirective>> getAllAppliedDirectivesByName();

    public GraphQLAppliedDirective getAppliedDirective(String var1);

    default public List<GraphQLAppliedDirective> getAppliedDirectives(String directiveName) {
        return this.getAllAppliedDirectivesByName().getOrDefault(directiveName, ImmutableKit.emptyList());
    }

    @Deprecated(since="2022-02-24")
    default public boolean hasDirective(String directiveName) {
        return this.getAllDirectivesByName().containsKey(directiveName);
    }

    default public boolean hasAppliedDirective(String directiveName) {
        return this.getAllAppliedDirectivesByName().containsKey(directiveName);
    }

    @Deprecated(since="2022-02-24")
    public List<GraphQLDirective> getDirectives();

    @Deprecated(since="2022-02-24")
    public Map<String, GraphQLDirective> getDirectivesByName();

    @Deprecated(since="2022-02-24")
    public Map<String, List<GraphQLDirective>> getAllDirectivesByName();

    @Deprecated(since="2022-02-24")
    public GraphQLDirective getDirective(String var1);

    @Deprecated(since="2022-02-24")
    default public List<GraphQLDirective> getDirectives(String directiveName) {
        return this.getAllDirectivesByName().getOrDefault(directiveName, ImmutableKit.emptyList());
    }
}

